/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLExtensionSchemaDefinition;
import org.verapdf.model.impl.axl.AXLXMPObject;
import org.verapdf.model.tools.xmp.SchemasDefinition;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.ValidatorsContainerCreator;
import org.verapdf.model.xmplayer.ExtensionSchemasContainer;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.impl.VeraPDFXMPNode;
import org.verapdf.xmp.options.PropertyOptions;

public class AXLExtensionSchemasContainer
extends AXLXMPObject
implements ExtensionSchemasContainer {
    public static final String EXTENSION_SCHEMAS_CONTAINER = "ExtensionSchemasContainer";
    public static final String EXTENSION_SCHEMA_DEFINITIONS = "ExtensionSchemaDefinitions";
    protected VeraPDFXMPNode xmpNode;
    protected final Map<String, SchemasDefinition> containerForPDFA_1;
    protected final Map<String, SchemasDefinition> containerForPDFA_2_3;
    protected final PDFAFlavour flavour;

    public AXLExtensionSchemasContainer(VeraPDFXMPNode xmpNode, Map<String, SchemasDefinition> containerForPDFA_1, Map<String, SchemasDefinition> containerForPDFA_2_3, PDFAFlavour flavour) {
        super(EXTENSION_SCHEMAS_CONTAINER);
        this.xmpNode = xmpNode;
        this.containerForPDFA_1 = containerForPDFA_1;
        this.containerForPDFA_2_3 = containerForPDFA_2_3;
        this.flavour = flavour;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ExtensionSchemaDefinitions": {
                return this.getExtensionSchemaDefinitions();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLExtensionSchemaDefinition> getExtensionSchemaDefinitions() {
        if (this.xmpNode != null && this.xmpNode.getOptions().isArray()) {
            ArrayList<AXLExtensionSchemaDefinition> res = new ArrayList<AXLExtensionSchemaDefinition>();
            for (VeraPDFXMPNode node : this.xmpNode.getChildren()) {
                ValidatorsContainer containerForPDFA_1 = ValidatorsContainerCreator.EMPTY_VALIDATORS_CONTAINER;
                ValidatorsContainer containerForPDFA_2_3 = ValidatorsContainerCreator.EMPTY_VALIDATORS_CONTAINER;
                for (VeraPDFXMPNode child : node.getChildren()) {
                    SchemasDefinition schemasDefinitionForPDFA_2_3;
                    if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !"namespaceURI".equals(child.getName())) continue;
                    String namespace = child.getValue();
                    SchemasDefinition schemasDefinitionForPDFA_1 = this.containerForPDFA_1.get(namespace);
                    if (schemasDefinitionForPDFA_1 != null) {
                        containerForPDFA_1 = schemasDefinitionForPDFA_1.getValidatorsContainer();
                    }
                    if ((schemasDefinitionForPDFA_2_3 = this.containerForPDFA_2_3.get(namespace)) == null) continue;
                    containerForPDFA_2_3 = schemasDefinitionForPDFA_2_3.getValidatorsContainer();
                }
                res.add(new AXLExtensionSchemaDefinition(node, containerForPDFA_1, containerForPDFA_2_3, this.flavour));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Boolean getisValidBag() {
        PropertyOptions options = this.xmpNode.getOptions();
        return options.isArray() && !options.isArrayOrdered() && !options.isArrayAlternate();
    }

    public String getprefix() {
        return this.xmpNode == null ? null : this.xmpNode.getPrefix();
    }
}

