/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.RuleId;
import org.verapdf.processor.AbstractBatchHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.ItemDetails;
import org.verapdf.report.FeaturesReport;

class SingleLineResultHandler
extends AbstractBatchHandler {
    private static final String pass = "PASS ";
    private static final String fail = "FAIL ";
    private static final String ioExcepMess = "IOException caught when writing to output stream";
    private static final String parseExcepMessTmpl = "%s does not appear to be a valid PDF file and could not be parsed.\n";
    private static final String pdfEncryptMessTmpl = "%s appears to be an encrypted PDF file and could not be processed.\n";
    private static final String ruleMessTmpl = "  %s%s-%d\n";
    private PrintWriter outputStreamWriter;
    private final boolean isVerbose;
    private final boolean logSuccess;
    private ItemDetails item;

    private SingleLineResultHandler(PrintWriter outputStreamWriter) {
        this(outputStreamWriter, false);
    }

    private SingleLineResultHandler(PrintWriter outputStreamWriter, boolean isVerbose) {
        this(outputStreamWriter, isVerbose, false);
    }

    private SingleLineResultHandler(PrintWriter outputStreamWriter, boolean isVerbose, boolean logSuccess) {
        this.outputStreamWriter = outputStreamWriter;
        this.isVerbose = isVerbose;
        this.logSuccess = logSuccess;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) {
    }

    @Override
    void resultStart(ProcessorResult result) {
        this.item = result.getProcessedItem();
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) {
        this.outputStreamWriter.write(String.format(parseExcepMessTmpl, this.item.getName()));
        this.outputStreamWriter.flush();
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) {
        this.outputStreamWriter.write(String.format(pdfEncryptMessTmpl, this.item.getName()));
        this.outputStreamWriter.flush();
    }

    @Override
    void validationSuccess(TaskResult taskResult, ValidationResult validationResult) throws VeraPDFException {
        String reportSummary = (validationResult.isCompliant() ? pass : fail) + this.item.getName() + "\n";
        try {
            this.outputStreamWriter.write(reportSummary);
            if (this.isVerbose || this.logSuccess) {
                this.processRules(validationResult);
            }
            this.outputStreamWriter.flush();
        }
        catch (IOException excep) {
            throw new VeraPDFException(ioExcepMess, excep);
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) {
        String reportSummary = "ERROR " + this.item.getName() + " " + taskResult.getType().fullName() + "\n";
        this.outputStreamWriter.write(reportSummary);
        this.outputStreamWriter.flush();
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featuresReport) {
    }

    @Override
    void featureFailure(TaskResult taskResult) {
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) {
    }

    @Override
    void fixerFailure(TaskResult taskResult) {
    }

    @Override
    void resultEnd(ProcessorResult result, Boolean isLogsEnabled) {
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) {
        this.close();
    }

    @Override
    public void close() {
        this.outputStreamWriter.flush();
        this.outputStreamWriter.close();
    }

    private void processRules(ValidationResult validationResult) throws IOException {
        HashSet<RuleId> passedRules = new HashSet<RuleId>();
        HashSet<RuleId> failedRules = new HashSet<RuleId>();
        for (TestAssertion assertion : validationResult.getTestAssertions()) {
            if (assertion.getStatus() == TestAssertion.Status.FAILED) {
                if (!this.isVerbose) continue;
                failedRules.add(assertion.getRuleId());
                continue;
            }
            if (!this.logSuccess) continue;
            passedRules.add(assertion.getRuleId());
        }
        if (this.isVerbose) {
            this.outputRules(failedRules, fail);
        }
        if (this.logSuccess) {
            this.outputRules(passedRules, pass);
        }
    }

    private void outputRules(Set<RuleId> rules, String messStart) throws IOException {
        for (RuleId id : rules) {
            this.outputStreamWriter.write(String.format(ruleMessTmpl, messStart, id.getClause(), id.getTestNumber()));
        }
    }

    static BatchProcessingHandler newInstance(PrintWriter outputStreamWriter) {
        return new SingleLineResultHandler(outputStreamWriter);
    }

    static BatchProcessingHandler newInstance(PrintWriter outputStreamWriter, boolean verbose) {
        return new SingleLineResultHandler(outputStreamWriter, verbose);
    }

    static BatchProcessingHandler newInstance(PrintWriter outputStreamWriter, boolean verbose, boolean logSuccess) {
        return new SingleLineResultHandler(outputStreamWriter, verbose, logSuccess);
    }
}

