/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import java.io.FilenameFilter;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.FileOutputMapper;
import org.verapdf.core.utils.RelativeDirectoryMapper;

final class VersioningMapper
implements FileOutputMapper {
    private static final String verPrefixOpen = "_(";
    private static final String verPrefixClose = ")";
    static final VersioningMapper defaultInstance = new VersioningMapper();
    protected final FileOutputMapper mapper;

    private VersioningMapper() {
        this(RelativeDirectoryMapper.defaultInstance());
    }

    private VersioningMapper(FileOutputMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public String getPrefix() {
        return this.mapper.getPrefix();
    }

    @Override
    public String getSuffix() {
        return this.mapper.getSuffix();
    }

    @Override
    public File mapFile(File orig) throws VeraPDFException {
        return VersioningMapper.version(this.mapper.mapFile(orig));
    }

    private static File version(File toCheck) {
        if (!toCheck.exists()) {
            return toCheck;
        }
        return VersioningMapper.newVersion(toCheck);
    }

    private static File newVersion(File orig) {
        int maxVersion = -1;
        for (File version : VersioningMapper.getVersions(orig)) {
            int vers = VersioningMapper.getVersion(orig, version);
            maxVersion = Math.max(vers, maxVersion);
        }
        Integer version = maxVersion + 1;
        String versionedName = String.format("%s%d%s", VersioningMapper.verStart(orig), version, VersioningMapper.verEnd(orig));
        return new File(orig.getParentFile(), versionedName);
    }

    static int getVersion(File orig, File version) {
        String verPart = version.getName().replace(VersioningMapper.verStart(orig), "").replace(VersioningMapper.verEnd(orig), "");
        try {
            return Integer.parseInt(verPart);
        }
        catch (NumberFormatException excep) {
            return -1;
        }
    }

    static VersioningMapper defaultInstance() {
        return defaultInstance;
    }

    static VersioningMapper newInstance(FileOutputMapper mapper) {
        return new VersioningMapper(mapper);
    }

    static String verStart(File orig) {
        String origName = orig.getName();
        String verStart = origName.lastIndexOf(".") < 1 ? origName + verPrefixOpen : origName.substring(0, origName.lastIndexOf(".")) + verPrefixOpen;
        return verStart;
    }

    static String verEnd(File orig) {
        String origName = orig.getName();
        String verEnd = origName.lastIndexOf(".") < 1 ? verPrefixClose : verPrefixClose + origName.substring(origName.lastIndexOf("."));
        return verEnd;
    }

    private static File[] getVersions(final File orig) {
        File parent = orig.getParentFile();
        File[] versions = parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (!name.startsWith(VersioningMapper.verStart(orig))) {
                    return false;
                }
                if (!name.endsWith(VersioningMapper.verEnd(orig))) {
                    return false;
                }
                return VersioningMapper.getVersion(orig, new File(dir, name)) >= 0;
            }
        });
        return versions;
    }
}

