/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import jakarta.xml.bind.JAXBException;
import java.io.Writer;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.AuditDurationImpl;
import org.verapdf.component.LogsSummary;
import org.verapdf.component.LogsSummaryImpl;
import org.verapdf.core.VeraPDFException;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractXmlHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.MetadataFixerReport;
import org.verapdf.processor.reports.Reports;
import org.verapdf.report.FeaturesReport;

class MrrHandler
extends AbstractXmlHandler {
    private final boolean logPassed;

    private MrrHandler(Writer dest) throws VeraPDFException {
        this(dest, false);
    }

    protected MrrHandler(Writer dest, boolean logPassed) throws VeraPDFException {
        super(dest);
        this.logPassed = logPassed;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) throws VeraPDFException {
        try {
            MrrHandler.startDoc(this.writer);
            this.writer.writeStartElement("report");
            this.addReleaseDetails();
            this.writer.writeStartElement("jobs");
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    private void addReleaseDetails() throws XMLStreamException, VeraPDFException {
        this.writer.writeStartElement("buildInformation");
        for (ReleaseDetails details : ReleaseDetails.getDetails()) {
            this.serializeElement(details, "releaseDetails", true, true);
        }
        this.writer.writeEndElement();
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        try {
            this.writer.writeStartElement("job");
            this.serializeElement(result.getProcessedItem(), "itemDetails", true, true);
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", true, true);
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", true, true);
    }

    @Override
    void validationSuccess(TaskResult taskResult, List<ValidationResult> validationResults) throws VeraPDFException {
        for (ValidationResult result : validationResults) {
            this.serializeElement(Reports.createValidationReport(result, this.logPassed), "validationResult", true, true);
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", true, true);
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featRep) throws VeraPDFException {
        this.serializeElement(featRep, "featuresReport", true, true);
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", true, true);
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        MetadataFixerReport mfRep = Reports.fromValues(fixerResult);
        this.serializeElement(mfRep, "fixerReport", true, true);
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        this.serializeElement(taskResult, "taskException", true, true);
    }

    @Override
    void resultEnd(ProcessorResult result, Boolean isLogsEnabled) throws VeraPDFException {
        LogsSummary logsSummary;
        AuditDuration duration = AuditDurationImpl.sumDuration(MrrHandler.getDurations(result));
        this.serializeElement(duration, "processingTime", true, true);
        if (isLogsEnabled.booleanValue() && (logsSummary = LogsSummaryImpl.getSummary()).getLogsCount() != 0) {
            this.serializeElement(logsSummary, "logs", true, true);
        }
        try {
            this.writer.writeEndElement();
            this.writer.flush();
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        try {
            this.writer.writeEndElement();
            this.serializeElement(summary, "batchSummary", true, true);
            this.writer.writeEndElement();
            this.writer.flush();
            MrrHandler.endDoc(this.writer);
        }
        catch (XMLStreamException excep) {
            throw MrrHandler.wrapStreamException(excep);
        }
        this.close();
    }

    protected static VeraPDFException wrapStreamException(JAXBException excep, String typePart) {
        return new VeraPDFException(String.format("Unmarshalling exception when streaming %s.", typePart), excep);
    }

    static BatchProcessingHandler newInstance(Writer dest, boolean logPassed) throws VeraPDFException {
        return new MrrHandler(dest, logPassed);
    }
}

