/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLPDFAIdentification;
import org.verapdf.model.impl.axl.AXLPDFUAIdentification;
import org.verapdf.model.impl.axl.AXLXMPPackage;
import org.verapdf.model.xmplayer.MainXMPPackage;
import org.verapdf.xmp.impl.VeraPDFMeta;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class AXLMainXMPPackage
extends AXLXMPPackage
implements MainXMPPackage {
    public static final String MAIN_XMP_PACKAGE_TYPE = "MainXMPPackage";
    public static final String PDFA_IDENTIFICATION = "PDFAIdentification";
    public static final String PDFUA_IDENTIFICATION = "PDFUAIdentification";

    public AXLMainXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid) {
        super(xmpMetadata, isSerializationValid, true, false, null, MAIN_XMP_PACKAGE_TYPE);
    }

    public AXLMainXMPPackage(VeraPDFMeta xmpMetadata, boolean isSerializationValid, boolean isClosedChoiceCheck) {
        super(xmpMetadata, isSerializationValid, true, isClosedChoiceCheck, null, MAIN_XMP_PACKAGE_TYPE);
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "PDFAIdentification": {
                return this.getPDFAIdentification();
            }
            case "PDFUAIdentification": {
                return this.getPDFUAIdentification();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLPDFUAIdentification> getPDFUAIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null && xmpMetadata.containsPropertiesFromNamespace("http://www.aiim.org/pdfua/ns/id/")) {
            ArrayList<AXLPDFUAIdentification> res = new ArrayList<AXLPDFUAIdentification>(1);
            res.add(new AXLPDFUAIdentification(xmpMetadata));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<AXLPDFAIdentification> getPDFAIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null && xmpMetadata.containsPropertiesFromNamespace("http://www.aiim.org/pdfa/ns/id/")) {
            ArrayList<AXLPDFAIdentification> res = new ArrayList<AXLPDFAIdentification>(1);
            res.add(new AXLPDFAIdentification(xmpMetadata));
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsPDFUAIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        return xmpMetadata != null && xmpMetadata.containsPropertiesFromNamespace("http://www.aiim.org/pdfua/ns/id/");
    }

    public Boolean getcontainsPDFAIdentification() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        return xmpMetadata != null && xmpMetadata.containsPropertiesFromNamespace("http://www.aiim.org/pdfa/ns/id/");
    }

    public String getdc_title() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null) {
            for (VeraPDFXMPNode node : xmpMetadata.getProperties()) {
                if (!"http://purl.org/dc/elements/1.1/".equals(node.getNamespaceURI()) || !"dc".equals(node.getPrefix()) || !"title".equals(node.getName())) continue;
                return node.getLanguageAlternative();
            }
        }
        return null;
    }

    public Set<String> getdeclarations() {
        VeraPDFMeta xmpMetadata = this.getXmpMetadata();
        if (xmpMetadata != null) {
            return xmpMetadata.getDeclarations();
        }
        return null;
    }
}

