/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.component.AuditDuration;
import org.verapdf.component.Components;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.FeaturesBatchSummary;
import org.verapdf.processor.reports.MetadataRepairBatchSummary;
import org.verapdf.processor.reports.ValidationBatchSummary;
import org.verapdf.processor.reports.ValidationBatchSummaryImpl;

@XmlRootElement(name="batchSummary")
final class BatchSummaryImpl
implements BatchSummary {
    private static final BatchSummary DEFAULT = new BatchSummaryImpl();
    @XmlElement
    private final ValidationBatchSummary validationReports;
    @XmlElement
    private final FeaturesBatchSummary featureReports;
    @XmlElement
    private final MetadataRepairBatchSummary repairReports;
    @XmlElement
    private final AuditDuration duration;
    @XmlAttribute
    private final int totalJobs;
    @XmlAttribute
    private final int failedToParse;
    @XmlAttribute
    private final int encrypted;
    @XmlAttribute
    private final int outOfMemory;
    @XmlAttribute
    private final int veraExceptions;

    private BatchSummaryImpl() {
        this(Components.defaultDuration(), ValidationBatchSummaryImpl.defaultInstance(), FeaturesBatchSummary.defaultInstance(), MetadataRepairBatchSummary.defaultInstance(), 0, 0, 0, 0, 0);
    }

    private BatchSummaryImpl(AuditDuration duration, ValidationBatchSummary validationSummary, FeaturesBatchSummary featureSummary, MetadataRepairBatchSummary repairSummary, int totalJobs, int failedToParse, int encrypted, int outOfMemory, int veraExceptions) {
        this.duration = duration;
        this.validationReports = validationSummary;
        this.featureReports = featureSummary;
        this.repairReports = repairSummary;
        this.totalJobs = totalJobs;
        this.failedToParse = failedToParse;
        this.encrypted = encrypted;
        this.outOfMemory = outOfMemory;
        this.veraExceptions = veraExceptions;
    }

    @Override
    public AuditDuration getDuration() {
        return this.duration;
    }

    @Override
    public ValidationBatchSummary getValidationSummary() {
        return this.validationReports;
    }

    @Override
    public FeaturesBatchSummary getFeaturesSummary() {
        return this.featureReports;
    }

    @Override
    public MetadataRepairBatchSummary getRepairSummary() {
        return this.repairReports;
    }

    @Override
    public int getTotalJobs() {
        return this.totalJobs;
    }

    @Override
    public int getFailedParsingJobs() {
        return this.failedToParse;
    }

    @Override
    public boolean isMultiJob() {
        return this.totalJobs > 1;
    }

    @Override
    public int getFailedEncryptedJobs() {
        return this.encrypted;
    }

    @Override
    public int getOutOfMemory() {
        return this.outOfMemory;
    }

    @Override
    public int getVeraExceptions() {
        return this.veraExceptions;
    }

    public static BatchSummary defaultInstance() {
        return DEFAULT;
    }

    static BatchSummary fromValues(AuditDuration duration, ValidationBatchSummary validationSummary, FeaturesBatchSummary featureSummary, MetadataRepairBatchSummary repairSummary, int totalJobs, int failedToParse, int encrypted, int outOfMemory, int veraExceptions) {
        return new BatchSummaryImpl(duration, validationSummary, featureSummary, repairSummary, totalJobs, failedToParse, encrypted, outOfMemory, veraExceptions);
    }

    static class Adapter
    extends XmlAdapter<BatchSummaryImpl, BatchSummary> {
        Adapter() {
        }

        public BatchSummary unmarshal(BatchSummaryImpl summary) {
            return summary;
        }

        public BatchSummaryImpl marshal(BatchSummary summary) {
            return (BatchSummaryImpl)summary;
        }
    }
}

