/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.processor.AbstractXmlHandler;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.report.FeaturesReport;

final class RawResultHandler
extends AbstractXmlHandler {
    private static final Logger logger = Logger.getLogger(RawResultHandler.class.getCanonicalName());
    private static final String raw = "rawResults";
    private final boolean format;
    private final boolean fragment;

    private RawResultHandler(Writer dest) throws VeraPDFException {
        super(dest);
        this.format = true;
        this.fragment = true;
    }

    private RawResultHandler(Writer dest, int indentSize, boolean format, boolean fragment) throws VeraPDFException {
        super(dest, indentSize);
        this.format = format;
        this.fragment = fragment;
    }

    @Override
    public void handleBatchStart(ProcessorConfig config) throws VeraPDFException {
        try {
            RawResultHandler.startDoc(this.writer);
            this.indentElement(raw);
            XmlSerialiser.toXml(config, this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "config"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "config");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    @Override
    void resultStart(ProcessorResult result) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(result.getProcessedItem(), this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "item"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "item");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    @Override
    void parsingSuccess(TaskResult taskResult) {
    }

    @Override
    void parsingFailure(TaskResult taskResult) throws VeraPDFException {
        this.outputTask(taskResult);
    }

    @Override
    void pdfEncrypted(TaskResult taskResult) throws VeraPDFException {
        this.outputTask(taskResult);
    }

    @Override
    void validationSuccess(TaskResult taskResult, ValidationResult validationResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(validationResult, this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "validationResult"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "validationResult");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    @Override
    void validationFailure(TaskResult taskResult) throws VeraPDFException {
        this.outputTask(taskResult);
    }

    @Override
    void featureSuccess(TaskResult taskResult, FeaturesReport featuresReport) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(featuresReport, this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "featuresReport"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "featuresReport");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    @Override
    void featureFailure(TaskResult taskResult) throws VeraPDFException {
        this.outputTask(taskResult);
    }

    @Override
    void fixerSuccess(TaskResult taskResult, MetadataFixerResult fixerResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(fixerResult, this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "fixerResult"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "fixerResult");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    @Override
    void fixerFailure(TaskResult taskResult) throws VeraPDFException {
        this.outputTask(taskResult);
    }

    @Override
    void resultEnd(ProcessorResult result) {
    }

    @Override
    public void handleBatchEnd(BatchSummary summary) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(summary, this.writer, this.format, this.fragment);
            this.outdentElement();
            this.writer.flush();
            RawResultHandler.endDoc(this.writer);
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "summary"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "summary");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "summary");
        }
    }

    private void outputTask(TaskResult taskResult) throws VeraPDFException {
        try {
            XmlSerialiser.toXml(taskResult, this.writer, this.format, this.fragment);
            this.writer.flush();
        }
        catch (JAXBException excep) {
            logger.log(Level.WARNING, String.format("Unmarshalling exception when streaming %s.", "taskResult"), excep);
            throw RawResultHandler.wrapMarshallException(excep, "taskResult");
        }
        catch (XMLStreamException excep) {
            logger.log(Level.WARNING, String.format("XmlStreamException caught when %s output writer.", "writing"), excep);
            throw RawResultHandler.wrapStreamException(excep, "config");
        }
    }

    static final BatchProcessingHandler newInstance(Writer dest) throws VeraPDFException {
        return new RawResultHandler(dest);
    }

    static final BatchProcessingHandler newInstance(Writer dest, int indent) throws VeraPDFException {
        return new RawResultHandler(dest, indent, true, false);
    }

    static final BatchProcessingHandler newInstance(Writer dest, int indent, boolean format) throws VeraPDFException {
        return new RawResultHandler(dest, indent, format, false);
    }

    static final BatchProcessingHandler newInstance(Writer dest, int indent, boolean format, boolean fragment) throws VeraPDFException {
        return new RawResultHandler(dest, indent, format, fragment);
    }
}

