/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.EnumSet;
import javax.xml.bind.JAXBException;
import org.verapdf.component.Components;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.XmlSerialiser;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.metadata.fixer.MetadataFixerConfig;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.verapdf.pdfa.validation.validators.ValidatorConfig;
import org.verapdf.processor.BatchFileProcessor;
import org.verapdf.processor.BatchProcessingHandler;
import org.verapdf.processor.BatchProcessor;
import org.verapdf.processor.FormatOption;
import org.verapdf.processor.ItemProcessor;
import org.verapdf.processor.MrrHandler;
import org.verapdf.processor.ProcessorConfig;
import org.verapdf.processor.ProcessorConfigImpl;
import org.verapdf.processor.ProcessorImpl;
import org.verapdf.processor.ProcessorResult;
import org.verapdf.processor.ProcessorResultImpl;
import org.verapdf.processor.RawResultHandler;
import org.verapdf.processor.SingleLineResultHandler;
import org.verapdf.processor.TaskResult;
import org.verapdf.processor.TaskResultImpl;
import org.verapdf.processor.TaskType;
import org.verapdf.processor.plugins.PluginsCollectionConfig;
import org.verapdf.processor.reports.BatchSummary;
import org.verapdf.processor.reports.Reports;

public final class ProcessorFactory {
    private ProcessorFactory() {
    }

    public static ProcessorConfig defaultConfig() {
        return ProcessorConfigImpl.defaultInstance();
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, String mdFolder) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, mdFolder);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, customProfile);
    }

    public static ProcessorConfig fromValues(ValidatorConfig config, FeatureExtractorConfig featureConfig, PluginsCollectionConfig pluginsCollectionConfig, MetadataFixerConfig fixerConfig, EnumSet<TaskType> tasks, ValidationProfile customProfile, String mdFolder) {
        return ProcessorConfigImpl.fromValues(config, featureConfig, pluginsCollectionConfig, fixerConfig, tasks, customProfile, mdFolder);
    }

    public static void configToXml(ProcessorConfig toConvert, OutputStream stream, boolean format) throws JAXBException {
        XmlSerialiser.toXml(toConvert, stream, format, false);
    }

    public static ProcessorConfig configFromXml(InputStream source) throws JAXBException {
        return (ProcessorConfig)XmlSerialiser.typeFromXml(ProcessorConfigImpl.class, source);
    }

    public static final ItemProcessor createProcessor(ProcessorConfig config) {
        return ProcessorImpl.newProcessor(config);
    }

    public static final BatchProcessor fileBatchProcessor(ProcessorConfig config) {
        return new BatchFileProcessor(ProcessorFactory.createProcessor(config));
    }

    public static final BatchProcessingHandler rawResultHandler() throws VeraPDFException {
        return ProcessorFactory.rawResultHandler(new PrintWriter(System.out));
    }

    public static final BatchProcessingHandler rawResultHandler(Writer dest) throws VeraPDFException {
        return RawResultHandler.newInstance(dest);
    }

    public static final BatchProcessingHandler rawResultHandler(Writer dest, int indentSize) throws VeraPDFException {
        return RawResultHandler.newInstance(dest, indentSize);
    }

    public static final BatchProcessingHandler getHandler(FormatOption option, boolean isVerbose, int maxFailedChecksPerRule, boolean logPassed) throws VeraPDFException {
        return ProcessorFactory.getHandler(option, isVerbose, System.out, maxFailedChecksPerRule, logPassed);
    }

    public static final BatchProcessingHandler getHandler(FormatOption option, boolean isVerbose, OutputStream reportStream, int maxFailedChecksPerRule, boolean logPassed) throws VeraPDFException {
        if (option == null) {
            throw new IllegalArgumentException("Arg option can not be null");
        }
        if (reportStream == null) {
            throw new IllegalArgumentException("Arg reportStream can not be null");
        }
        switch (option) {
            case TEXT: {
                return SingleLineResultHandler.newInstance(reportStream, isVerbose);
            }
            case XML: {
                return ProcessorFactory.rawResultHandler(new PrintWriter(reportStream));
            }
            case MRR: {
                return MrrHandler.newInstance(new PrintWriter(reportStream), logPassed, maxFailedChecksPerRule);
            }
        }
        throw new VeraPDFException("Unknown report format option: " + (Object)((Object)option));
    }

    public static void resultToXml(ProcessorResult toConvert, OutputStream stream, boolean prettyXml) throws JAXBException {
        XmlSerialiser.toXml(toConvert, stream, prettyXml, false);
    }

    public static ProcessorResult resultFromXml(InputStream source) throws JAXBException {
        return (ProcessorResult)XmlSerialiser.typeFromXml(ProcessorResultImpl.class, source);
    }

    public static void taskResultToXml(TaskResult toConvert, OutputStream dest, boolean prettyXml) throws JAXBException {
        XmlSerialiser.toXml(toConvert, dest, prettyXml, true);
    }

    public static TaskResult taskResultfromXml(InputStream source) throws JAXBException {
        return (TaskResult)XmlSerialiser.typeFromXml(TaskResultImpl.class, source);
    }

    public static final class BatchSummariser {
        private int jobs = 0;
        private int failedJobs = 0;
        private int valid = 0;
        private int invalid = 0;
        private int validExcep = 0;
        private int features = 0;
        private Components.Timer timer = Components.Timer.start();

        public void addProcessingResult(ProcessorResult result) {
            ++this.jobs;
            if (!result.isValidPdf() || result.isEncryptedPdf()) {
                ++this.failedJobs;
                return;
            }
            if (result.getTaskTypes().contains((Object)TaskType.VALIDATE) && result.getResultForTask(TaskType.VALIDATE).isExecuted()) {
                if (!result.getResultForTask(TaskType.VALIDATE).isSuccess()) {
                    ++this.validExcep;
                }
                if (result.getValidationResult().isCompliant()) {
                    ++this.valid;
                } else {
                    ++this.invalid;
                }
            }
            if (result.getTaskTypes().contains((Object)TaskType.EXTRACT_FEATURES) && result.getResultForTask(TaskType.EXTRACT_FEATURES).isExecuted() && result.getResultForTask(TaskType.EXTRACT_FEATURES).isSuccess()) {
                ++this.features;
            }
        }

        public BatchSummary summarise() {
            return Reports.createBatchSummary(this.timer, this.jobs, this.failedJobs, this.valid, this.invalid, this.validExcep, this.features);
        }
    }
}

