/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.axl;

import com.adobe.xmp.impl.VeraPDFXMPNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.axl.AXLExtensionSchemaObject;
import org.verapdf.model.impl.axl.AXLExtensionSchemaProperty;
import org.verapdf.model.impl.axl.AXLExtensionSchemaValueType;
import org.verapdf.model.tools.xmp.ValidatorsContainer;
import org.verapdf.model.tools.xmp.validators.SimpleTypeValidator;
import org.verapdf.model.tools.xmp.validators.URITypeValidator;
import org.verapdf.model.xmplayer.ExtensionSchemaDefinition;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class AXLExtensionSchemaDefinition
extends AXLExtensionSchemaObject
implements ExtensionSchemaDefinition {
    public static final String EXTENSION_SCHEMA_DEFINITION = "ExtensionSchemaDefinition";
    public static final String EXTENSION_SCHEMA_PROPERTIES = "ExtensionSchemaProperties";
    public static final String EXTENSION_SCHEMA_VALUE_TYPES = "ExtensionSchemaValueTypes";
    public static final String NAMESPACE_URI = "namespaceURI";
    private static final String PREFIX = "prefix";
    private static final String PROPERTY = "property";
    private static final String SCHEMA = "schema";
    private static final String VALUE_TYPE = "valueType";

    public AXLExtensionSchemaDefinition(VeraPDFXMPNode xmpNode, ValidatorsContainer containerForPDFA_1, ValidatorsContainer containerForPDFA_2_3, PDFAFlavour flavour) {
        super(EXTENSION_SCHEMA_DEFINITION, xmpNode, containerForPDFA_1, containerForPDFA_2_3, flavour);
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "ExtensionSchemaProperties": {
                return this.getExtensionSchemaProperties();
            }
            case "ExtensionSchemaValueTypes": {
                return this.getExtensionSchemaValueType();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<AXLExtensionSchemaValueType> getExtensionSchemaValueType() {
        if (this.xmpNode != null) {
            ArrayList<AXLExtensionSchemaValueType> res = new ArrayList<AXLExtensionSchemaValueType>();
            for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
                if (!child.getOptions().isArray()) break;
                for (VeraPDFXMPNode node : child.getChildren()) {
                    res.add(new AXLExtensionSchemaValueType(node, this.containerForPDFA_1, this.containerForPDFA_2_3, this.flavour));
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    private List<AXLExtensionSchemaProperty> getExtensionSchemaProperties() {
        if (this.xmpNode != null) {
            ArrayList<AXLExtensionSchemaProperty> res = new ArrayList<AXLExtensionSchemaProperty>();
            for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
                if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PROPERTY.equals(child.getName())) continue;
                if (!child.getOptions().isArray()) break;
                for (VeraPDFXMPNode node : child.getChildren()) {
                    res.add(new AXLExtensionSchemaProperty(node, this.containerForPDFA_1, this.containerForPDFA_2_3, this.flavour));
                }
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    @Override
    public Boolean getcontainsUndefinedFields() {
        boolean undef = false;
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!undef && "http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI())) {
                switch (child.getName()) {
                    case "namespaceURI": 
                    case "prefix": 
                    case "property": 
                    case "schema": 
                    case "valueType": {
                        break;
                    }
                    default: {
                        undef = true;
                        break;
                    }
                }
                continue;
            }
            undef = true;
            break;
        }
        return undef;
    }

    public Boolean getisNamespaceURIValidURI() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return new URITypeValidator().isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisPrefixValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisPropertyValidSeq() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PROPERTY.equals(child.getName())) continue;
            return child.getOptions().isArrayOrdered();
        }
        return Boolean.TRUE;
    }

    public Boolean getisSchemaValidText() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !SCHEMA.equals(child.getName())) continue;
            return SimpleTypeValidator.fromValue(SimpleTypeValidator.SimpleTypeEnum.TEXT).isCorresponding(child);
        }
        return Boolean.TRUE;
    }

    public Boolean getisValueTypeValidSeq() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return child.getOptions().isArrayOrdered();
        }
        return Boolean.TRUE;
    }

    public String getnamespaceURIPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !NAMESPACE_URI.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getprefixPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PREFIX.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getpropertyPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !PROPERTY.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getschemaPrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !SCHEMA.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }

    public String getvalueTypePrefix() {
        for (VeraPDFXMPNode child : this.xmpNode.getChildren()) {
            if (!"http://www.aiim.org/pdfa/ns/schema#".equals(child.getNamespaceURI()) || !VALUE_TYPE.equals(child.getName())) continue;
            return child.getPrefix();
        }
        return null;
    }
}

