/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pdfa.results;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.verapdf.pdfa.results.Location;

@XmlRootElement(name="location")
final class LocationImpl
implements Location {
    private static final LocationImpl DEFAULT = new LocationImpl();
    private static final String DEREF_REGEX = "\\([0-9]{1,} ([a-zA-Z]{4})";
    private static final String DEREF_REPL = "\\(";
    private static final Pattern DEREF_PATTERN = Pattern.compile("\\([0-9]{1,} ([a-zA-Z]{4})");
    @XmlElement
    private final String level;
    @XmlElement
    private final String context;

    private LocationImpl() {
        this("level", "context");
    }

    private LocationImpl(String level, String context) {
        this.level = level;
        this.context = context;
    }

    @Override
    public String getLevel() {
        return this.level;
    }

    @Override
    public String getContext() {
        return this.context;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        if (!Objects.equals(this.getContext(), other.getContext())) {
            return false;
        }
        return Objects.equals(this.getLevel(), other.getLevel());
    }

    public final String toString() {
        return "Location [level=" + this.level + ", context=" + this.context + "]";
    }

    static LocationImpl defaultInstance() {
        return DEFAULT;
    }

    static LocationImpl fromValues(String level, String context) {
        Matcher matcher;
        String deRefdContext = context;
        if (context != null && (matcher = DEREF_PATTERN.matcher(context)).find()) {
            deRefdContext = matcher.replaceAll(DEREF_REPL + matcher.group(1));
        }
        return new LocationImpl(level, deRefdContext);
    }

    static class Adapter
    extends XmlAdapter<LocationImpl, Location> {
        Adapter() {
        }

        public Location unmarshal(LocationImpl locationImpl) {
            return locationImpl;
        }

        public LocationImpl marshal(Location location) {
            return (LocationImpl)location;
        }
    }
}

