/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.images.PDXImage;

public class GFImageXObjectFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(GFImageXObjectFeaturesObject.class.getCanonicalName());
    private static final String ID = "id";
    private PDXImage imageXObject;
    private String id;
    private String colorSpaceChild;
    private String maskChild;
    private String sMaskChild;
    private Set<String> alternatesChild;

    public GFImageXObjectFeaturesObject(PDXImage imageXObject, String id, String colorSpaceChild, String maskChild, String sMaskChild, Set<String> alternatesChild) {
        this.imageXObject = imageXObject;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
        this.maskChild = maskChild;
        this.sMaskChild = sMaskChild;
        this.alternatesChild = alternatesChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.IMAGE_XOBJECT;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.imageXObject != null && !this.imageXObject.empty()) {
            List filtersList;
            Long struct;
            FeatureTreeNode mask;
            Long bitsPerComponent;
            Long height;
            Long width;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"xobject");
            root.setAttribute("type", "image");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            if ((width = this.imageXObject.getWidth()) != null) {
                GFCreateNodeHelper.addNotEmptyNode("width", String.valueOf(width), root);
            }
            if ((height = this.imageXObject.getHeight()) != null) {
                GFCreateNodeHelper.addNotEmptyNode("height", String.valueOf(height), root);
            }
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shading = root.addChild("colorSpace");
                shading.setAttribute(ID, this.colorSpaceChild);
            }
            if ((bitsPerComponent = this.imageXObject.getBitsPerComponent()) != null) {
                GFCreateNodeHelper.addNotEmptyNode("bitsPerComponent", String.valueOf(bitsPerComponent), root);
            }
            root.addChild("imageMask").setValue(String.valueOf(this.imageXObject.getImageMask()));
            if (this.maskChild != null) {
                mask = root.addChild("mask");
                mask.setAttribute(ID, this.maskChild);
            }
            GFCreateNodeHelper.addNotEmptyNode("interpolate", String.valueOf(this.imageXObject.isInterpolate()), root);
            GFCreateNodeHelper.parseIDSet(this.alternatesChild, "alternate", "alternates", root);
            if (this.sMaskChild != null) {
                mask = root.addChild("sMask");
                mask.setAttribute(ID, this.sMaskChild);
            }
            if ((struct = this.imageXObject.getStructParent()) != null) {
                GFCreateNodeHelper.addNotEmptyNode("structParent", String.valueOf(struct), root);
            }
            if (!(filtersList = this.imageXObject.getFilters()).isEmpty()) {
                FeatureTreeNode filters = root.addChild("filters");
                for (ASAtom name : filtersList) {
                    GFCreateNodeHelper.addNotEmptyNode("filter", name.getValue(), filters);
                }
            }
            GFCreateNodeHelper.parseMetadata(this.imageXObject.getMetadata(), "metadata", root, collection);
            collection.addNewFeatureTree(FeatureObjectType.IMAGE_XOBJECT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        if (this.imageXObject != null && !this.imageXObject.empty()) {
            InputStream metadata = null;
            PDMetadata pdMetadata = this.imageXObject.getMetadata();
            if (pdMetadata != null) {
                metadata = pdMetadata.getStream();
            }
            ArrayList<ImageFeaturesData.Filter> filters = new ArrayList<ImageFeaturesData.Filter>();
            List atomFilters = this.imageXObject.getFilters();
            if (!atomFilters.isEmpty()) {
                ArrayList filtersNames = new ArrayList();
                List<COSObject> decodeList = GFImageXObjectFeaturesObject.getDecodeList(this.imageXObject.getKey(ASAtom.DECODE_PARMS));
                block16: for (int i = 0; i < filtersNames.size(); ++i) {
                    String filterNameValue;
                    ASAtom filterName = (ASAtom)filtersNames.get(i);
                    COSObject dic = i < decodeList.size() ? decodeList.get(i) : null;
                    switch (filterNameValue = filterName.getValue()) {
                        case "LZWDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, GFImageXObjectFeaturesObject.createLZWFilterMap(dic), null));
                            continue block16;
                        }
                        case "FlateDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, GFImageXObjectFeaturesObject.createFlatFilterMap(dic), null));
                            continue block16;
                        }
                        case "CCITTFaxDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, GFImageXObjectFeaturesObject.getCCITTFaxFiltersMap(dic), null));
                            continue block16;
                        }
                        case "DCTDecode": {
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, GFImageXObjectFeaturesObject.getDCTFiltersMap(dic), null));
                            continue block16;
                        }
                        case "JBIG2Decode": {
                            COSObject globals;
                            ASInputStream global = null;
                            if (dic != null && (globals = dic.getKey(ASAtom.JBIG2_GLOBALS)).getType() == COSObjType.COS_STREAM) {
                                global = globals.getData(COSStream.FilterFlags.DECODE);
                            }
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, new HashMap(), global));
                            continue block16;
                        }
                        case "Crypt": {
                            if (dic == null || !ASAtom.IDENTITY.equals((Object)dic.getNameKey(ASAtom.NAME))) {
                                LOGGER.log(Level.FINE, "An Image has a Crypt filter");
                                return null;
                            }
                        }
                        default: {
                            filters.add(ImageFeaturesData.Filter.newInstance((String)filterNameValue, new HashMap(), null));
                        }
                    }
                }
            }
            Integer width = GFImageXObjectFeaturesObject.getIntegerWithDefault(this.imageXObject.getWidth(), null);
            Integer height = GFImageXObjectFeaturesObject.getIntegerWithDefault(this.imageXObject.getHeight(), null);
            return ImageFeaturesData.newInstance((InputStream)metadata, (InputStream)this.imageXObject.getObject().getData(), (Integer)width, (Integer)height, filters);
        }
        return null;
    }

    private static List<COSObject> getDecodeList(COSObject base) {
        ArrayList<COSObject> res = new ArrayList<COSObject>();
        if (base != null) {
            if (base.getType() == COSObjType.COS_DICT) {
                res.add(base);
            } else if (base.getType() == COSObjType.COS_ARRAY) {
                for (COSObject baseElem : (COSArray)base.getDirectBase()) {
                    if (baseElem.getType() == COSObjType.COS_DICT) {
                        res.add(baseElem);
                        continue;
                    }
                    res.add(null);
                }
            }
        }
        return res;
    }

    private static Map<String, String> getCCITTFaxFiltersMap(COSObject base) {
        HashMap<String, String> res = new HashMap<String, String>();
        if (base != null) {
            GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "K", base.getIntegerKey(ASAtom.K), 0);
            GFImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfLine", base.getBooleanKey(ASAtom.COLORS), Boolean.FALSE);
            GFImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EncodedByteAlign", base.getBooleanKey(ASAtom.BITS_PER_COMPONENT), Boolean.FALSE);
            GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", base.getIntegerKey(ASAtom.COLUMNS), 1728);
            GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Rows", base.getIntegerKey(ASAtom.ROWS), 0);
            GFImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "EndOfBlock", base.getBooleanKey(ASAtom.getASAtom((String)"EndOfBlock")), Boolean.TRUE);
            GFImageXObjectFeaturesObject.putBooleanAsStringWithDefault(res, "BlackIs1", base.getBooleanKey(ASAtom.BLACK_IS_1), Boolean.FALSE);
            GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "DamagedRowsBeforeError", base.getIntegerKey(ASAtom.getASAtom((String)"DamagedRowsBeforeError")), 0);
        } else {
            res.put("K", "0");
            res.put("EndOfLine", "false");
            res.put("EncodedByteAlign", "false");
            res.put("Columns", "1728");
            res.put("Rows", "0");
            res.put("EndOfBlock", "true");
            res.put("BlackIs1", "false");
            res.put("DamagedRowsBeforeError", "0");
        }
        return res;
    }

    private static Map<String, String> getDCTFiltersMap(COSObject base) {
        Long colorTransform;
        HashMap<String, String> res = new HashMap<String, String>();
        if (base != null && (colorTransform = base.getIntegerKey(ASAtom.getASAtom((String)"ColorTransform"))) != null) {
            res.put("ColorTransform", String.valueOf(colorTransform));
        }
        return res;
    }

    private static Map<String, String> createLZWFilterMap(COSObject base) {
        if (base == null) {
            Map<String, String> retVal = GFImageXObjectFeaturesObject.createDefaultFlatFilterMap();
            retVal.put("EarlyChange", "1");
            return retVal;
        }
        Map<String, String> retVal = GFImageXObjectFeaturesObject.createFlatFilterMap(base);
        GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(retVal, "EarlyChange", base.getIntegerKey(ASAtom.EARLY_CHANGE), 1);
        return retVal;
    }

    private static Map<String, String> createFlatFilterMap(COSObject base) {
        if (base == null) {
            return GFImageXObjectFeaturesObject.createDefaultFlatFilterMap();
        }
        HashMap<String, String> res = new HashMap<String, String>();
        GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Predictor", base.getIntegerKey(ASAtom.PREDICTOR), 1);
        GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Colors", base.getIntegerKey(ASAtom.COLORS), 1);
        GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "BitsPerComponent", base.getIntegerKey(ASAtom.BITS_PER_COMPONENT), 8);
        GFImageXObjectFeaturesObject.putIntegerAsStringWithDefault(res, "Columns", base.getIntegerKey(ASAtom.COLUMNS), 1);
        return res;
    }

    private static Map<String, String> createDefaultFlatFilterMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("Predictor", "1");
        res.put("Colors", "1");
        res.put("BitsPerComponent", "8");
        res.put("Columns", "1");
        return res;
    }

    private static Integer getIntegerWithDefault(Long value, Integer defaultValue) {
        if (value != null) {
            return value.intValue();
        }
        return defaultValue;
    }

    private static void putIntegerAsStringWithDefault(Map<String, String> map, String key, Long value, Integer defaultValue) {
        if (value != null) {
            map.put(key, String.valueOf(value));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }

    private static void putBooleanAsStringWithDefault(Map<String, String> map, String key, Boolean value, Boolean defaultValue) {
        if (value != null) {
            map.put(key, String.valueOf(value));
        } else if (defaultValue != null) {
            map.put(key, defaultValue.toString());
        }
    }
}

