/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSString;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.encryption.AccessPermissions;
import org.verapdf.pd.encryption.PDEncryption;

public class GFDocSecurityFeaturesObject
implements IFeaturesObject {
    private PDEncryption encryption;

    public GFDocSecurityFeaturesObject(PDEncryption encryption) {
        this.encryption = encryption;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.DOCUMENT_SECURITY;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.encryption != null && !this.encryption.empty()) {
            COSString userKey;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"documentSecurity");
            GFCreateNodeHelper.addNotEmptyNode("filter", this.encryption.getFilter(), root);
            GFCreateNodeHelper.addNotEmptyNode("subFilter", this.encryption.getSubFilter(), root);
            GFCreateNodeHelper.addNotEmptyNode("version", String.valueOf(this.encryption.getV()), root);
            GFCreateNodeHelper.addNotEmptyNode("length", String.valueOf(this.encryption.getLength()), root);
            COSString ownerKey = this.encryption.getO();
            if (ownerKey != null) {
                GFCreateNodeHelper.addNotEmptyNode("ownerKey", ownerKey.getHexString(), root);
            }
            if ((userKey = this.encryption.getU()) != null) {
                GFCreateNodeHelper.addNotEmptyNode("userKey", userKey.getHexString(), root);
            }
            GFCreateNodeHelper.addNotEmptyNode("encryptMetadata", String.valueOf(this.encryption.isEncryptMetadata()), root);
            AccessPermissions accessPermissions = this.encryption.getUserPermissions();
            if (accessPermissions != null) {
                GFCreateNodeHelper.addNotEmptyNode("printAllowed", String.valueOf(accessPermissions.canPrint()), root);
                GFCreateNodeHelper.addNotEmptyNode("printDegradedAllowed", String.valueOf(accessPermissions.canPrintDegraded()), root);
                GFCreateNodeHelper.addNotEmptyNode("changesAllowed", String.valueOf(accessPermissions.canModify()), root);
                GFCreateNodeHelper.addNotEmptyNode("modifyAnnotationsAllowed", String.valueOf(accessPermissions.canModifyAnnotations()), root);
                GFCreateNodeHelper.addNotEmptyNode("fillingSigningAllowed", String.valueOf(accessPermissions.canFillInForm()), root);
                GFCreateNodeHelper.addNotEmptyNode("documentAssemblyAllowed", String.valueOf(accessPermissions.canAssembleDocument()), root);
                GFCreateNodeHelper.addNotEmptyNode("extractContentAllowed", String.valueOf(accessPermissions.canExtractContent()), root);
                GFCreateNodeHelper.addNotEmptyNode("extractAccessibilityAllowed", String.valueOf(accessPermissions.canExtractForAccessibility()), root);
            }
            collection.addNewFeatureTree(FeatureObjectType.DOCUMENT_SECURITY, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

