/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSString;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.SignatureFeaturesData;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDSignature;

public class GFSignatureFeaturesObject
implements IFeaturesObject {
    private PDSignature signature;

    public GFSignatureFeaturesObject(PDSignature signature) {
        this.signature = signature;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.SIGNATURE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult featureExtractionResult) throws FeatureParsingException {
        if (this.signature != null && !this.signature.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"signature");
            GFCreateNodeHelper.addNotEmptyNode("filter", this.signature.getFilter(), root);
            GFCreateNodeHelper.addNotEmptyNode("subFilter", this.signature.getSubfilter(), root);
            COSString contents = this.signature.getContents();
            if (contents != null) {
                GFCreateNodeHelper.addNotEmptyNode("contents", contents.getHexString(), root);
            }
            GFCreateNodeHelper.addNotEmptyNode("name", this.signature.getName(), root);
            GFCreateNodeHelper.createDateNode("signDate", root, this.signature.getSignDate(), featureExtractionResult);
            GFCreateNodeHelper.addNotEmptyNode("location", this.signature.getLocation(), root);
            GFCreateNodeHelper.addNotEmptyNode("reason", this.signature.getReason(), root);
            GFCreateNodeHelper.addNotEmptyNode("contactInfo", this.signature.getContactInfo(), root);
            featureExtractionResult.addNewFeatureTree(FeatureObjectType.SIGNATURE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        COSString contents = this.signature.getContents();
        ByteArrayInputStream stream = contents == null ? null : new ByteArrayInputStream(contents.get());
        return SignatureFeaturesData.newInstance((InputStream)stream, (String)GFCreateNodeHelper.getStringFromASAtom(this.signature.getFilter()), (String)GFCreateNodeHelper.getStringFromASAtom(this.signature.getSubfilter()), (String)this.signature.getName(), (Calendar)this.signature.getSignDate(), (String)this.signature.getLocation(), (String)this.signature.getReason(), (String)this.signature.getContactInfo());
    }
}

