/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FontFeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType3Font;

public class GFFontFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(GFFontFeaturesObject.class.getCanonicalName());
    private static final String ID = "id";
    private PDFont font;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public GFFontFeaturesObject(PDFont font, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.font = font;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.FONT;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.font != null && !this.font.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"font");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            ASAtom fontSubtype = this.font.getSubtype();
            GFCreateNodeHelper.addNotEmptyNode("type", fontSubtype, root);
            if (fontSubtype != ASAtom.TYPE3) {
                GFCreateNodeHelper.addNotEmptyNode("baseFont", this.font.getName(), root);
            }
            if (fontSubtype == ASAtom.TYPE0) {
                GFCreateNodeHelper.parseIDSet(this.fontChild, "descendantFont", null, root.addChild("descendantFonts"));
                GFFontFeaturesObject.parseFontDescriptior(this.font.getFontDescriptor(), root, collection);
            } else if (fontSubtype == ASAtom.TRUE_TYPE || fontSubtype == ASAtom.TYPE1 || fontSubtype == ASAtom.MM_TYPE1 || fontSubtype == ASAtom.TYPE3) {
                ASAtom name;
                Long lc;
                PDSimpleFont sFont = (PDSimpleFont)this.font;
                Long fc = sFont.getFirstChar();
                if (fc != null && fc != -1L) {
                    root.addChild("firstChar").setValue(String.valueOf(fc));
                }
                if ((lc = sFont.getLastChar()) != null && lc != -1L) {
                    root.addChild("lastChar").setValue(String.valueOf(lc));
                }
                GFFontFeaturesObject.parseWidths(sFont.getWidths(), fc, root.addChild("widths"));
                COSObject enc = sFont.getEncoding();
                if (enc.getType() == COSObjType.COS_NAME) {
                    GFCreateNodeHelper.addNotEmptyNode("encoding", enc, root);
                } else if (enc.getType() == COSObjType.COS_DICT && (name = enc.getNameKey(ASAtom.BASE_ENCODING)) != null) {
                    GFCreateNodeHelper.addNotEmptyNode("encoding", name, root);
                }
                GFFontFeaturesObject.parseFontDescriptior(this.font.getFontDescriptor(), root, collection);
                if (sFont.getSubtype() == ASAtom.TYPE3) {
                    PDType3Font type3 = (PDType3Font)sFont;
                    GFCreateNodeHelper.addBoxFeature("fontBBox", type3.getFontBoundingBox(), root);
                    GFCreateNodeHelper.parseMatrix(type3.getFontMatrix(), root.addChild("fontMatrix"));
                    this.parseResources(root);
                }
            } else if (fontSubtype == ASAtom.CID_FONT_TYPE0 || fontSubtype == ASAtom.CID_FONT_TYPE2) {
                PDCIDFont cid = (PDCIDFont)this.font;
                GFCreateNodeHelper.addNotEmptyNode("type", cid.getSubtype(), root);
                GFCreateNodeHelper.addNotEmptyNode("baseFont", cid.getName(), root);
                Double dw = cid.getDefaultWidth();
                root.addChild("defaultWidth").setValue(String.valueOf(dw));
                PDCIDSystemInfo cidSystemInfo = cid.getCIDSystemInfo();
                if (cidSystemInfo != null) {
                    FeatureTreeNode cidS = root.addChild("cidSystemInfo");
                    GFCreateNodeHelper.addNotEmptyNode("registry", cidSystemInfo.getRegistry(), cidS);
                    GFCreateNodeHelper.addNotEmptyNode("ordering", cidSystemInfo.getOrdering(), cidS);
                    Long supplement = cidSystemInfo.getSupplement();
                    if (supplement != null) {
                        cidS.addChild("supplement").setValue(String.valueOf(supplement));
                    }
                }
                GFFontFeaturesObject.parseFontDescriptior(this.font.getFontDescriptor(), root, collection);
            }
            collection.addNewFeatureTree(FeatureObjectType.FONT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        PDFontDescriptor descriptor;
        if (this.font != null && !this.font.empty() && (descriptor = this.font.getFontDescriptor()) != null && !descriptor.empty()) {
            COSStream file = descriptor.getFontFile();
            if (file == null) {
                file = descriptor.getFontFile2();
            }
            if (file == null) {
                file = descriptor.getFontFile3();
            }
            if (file != null) {
                FontFeaturesData.Builder builder = new FontFeaturesData.Builder((InputStream)file.getData(COSStream.FilterFlags.DECODE));
                ASInputStream metadata = null;
                COSObject cosMetadata = file.getKey(ASAtom.METADATA);
                if (cosMetadata.getType() == COSObjType.COS_STREAM) {
                    metadata = cosMetadata.getData(COSStream.FilterFlags.DECODE);
                }
                builder.metadata(metadata);
                builder.fontName(GFCreateNodeHelper.getStringFromASAtom(descriptor.getFontName()));
                builder.fontFamily(descriptor.getFontFamily());
                builder.fontStretch(GFCreateNodeHelper.getStringFromASAtom(descriptor.getFontStretch()));
                builder.fontWeight(descriptor.getFontWeight());
                Long flags = descriptor.getFlags();
                builder.flags(flags == null ? null : Integer.valueOf(flags.intValue()));
                double[] rex = descriptor.getFontBoundingBox();
                if (rex != null) {
                    ArrayList<Double> rect = new ArrayList<Double>(rex.length);
                    for (int i = 0; i < rex.length; ++i) {
                        rect.add(rex[i]);
                    }
                    builder.fontBBox(rect);
                }
                COSObject descriptorDict = descriptor.getObject();
                builder.italicAngle(descriptor.getItalicAngle());
                builder.ascent(descriptor.getAscent());
                builder.descent(descriptor.getDescent());
                builder.leading(this.getDoubleFromDict(ASAtom.LEADING, descriptorDict));
                builder.capHeight(descriptor.getCapHeight());
                builder.xHeight(this.getDoubleFromDict(ASAtom.XHEIGHT, descriptorDict));
                builder.stemV(descriptor.getStemV());
                builder.stemH(this.getDoubleFromDict(ASAtom.STEM_H, descriptorDict));
                builder.avgWidth(this.getDoubleFromDict(ASAtom.AVG_WIDTH, descriptorDict));
                builder.maxWidth(this.getDoubleFromDict(ASAtom.MAX_WIDTH, descriptorDict));
                builder.missingWidth(this.getDoubleFromDict(ASAtom.MISSING_WIDTH, descriptorDict));
                builder.charSet(descriptor.getCharSet());
                return builder.build();
            }
        }
        return null;
    }

    private static void parseFontDescriptior(PDFontDescriptor descriptor, FeatureTreeNode root, FeatureExtractionResult collection) throws FeatureParsingException {
        if (descriptor != null && !descriptor.empty()) {
            FeatureTreeNode descriptorNode = root.addChild("fontDescriptor");
            GFCreateNodeHelper.addNotEmptyNode("fontName", descriptor.getFontName(), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("fontFamily", descriptor.getFontFamily(), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("fontStretch", descriptor.getFontStretch(), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("fontWeight", GFFontFeaturesObject.getStringFromDouble(descriptor.getFontWeight()), descriptorNode);
            descriptorNode.addChild("fixedPitch").setValue(String.valueOf(descriptor.isFixedPitch()));
            descriptorNode.addChild("serif").setValue(String.valueOf(descriptor.isSerif()));
            descriptorNode.addChild("symbolic").setValue(String.valueOf(descriptor.isSymbolic()));
            descriptorNode.addChild("script").setValue(String.valueOf(descriptor.isScript()));
            descriptorNode.addChild("nonsymbolic").setValue(String.valueOf(descriptor.isNonsymbolic()));
            descriptorNode.addChild("italic").setValue(String.valueOf(descriptor.isItalic()));
            descriptorNode.addChild("allCap").setValue(String.valueOf(descriptor.isAllCap()));
            descriptorNode.addChild("smallCap").setValue(String.valueOf(descriptor.isScript()));
            descriptorNode.addChild("forceBold").setValue(String.valueOf(descriptor.isForceBold()));
            GFCreateNodeHelper.addBoxFeature("fontBBox", descriptor.getFontBoundingBox(), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("italicAngle", GFFontFeaturesObject.getStringFromDouble(descriptor.getItalicAngle()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("ascent", GFFontFeaturesObject.getStringFromDouble(descriptor.getAscent()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("descent", GFFontFeaturesObject.getStringFromDouble(descriptor.getDescent()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("leading", GFFontFeaturesObject.getStringFromDouble(descriptor.getLeading()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("capHeight", GFFontFeaturesObject.getStringFromDouble(descriptor.getCapHeight()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("xHeight", GFFontFeaturesObject.getStringFromDouble(descriptor.getXHeight()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("stemV", GFFontFeaturesObject.getStringFromDouble(descriptor.getStemV()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("stemH", GFFontFeaturesObject.getStringFromDouble(descriptor.getStemH()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("averageWidth", GFFontFeaturesObject.getStringFromDouble(descriptor.getAvgWidth()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("maxWidth", GFFontFeaturesObject.getStringFromDouble(descriptor.getMaxWidth()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("missingWidth", GFFontFeaturesObject.getStringFromDouble(descriptor.getMissingWidth()), descriptorNode);
            GFCreateNodeHelper.addNotEmptyNode("charSet", descriptor.getCharSet(), descriptorNode);
            COSStream file = descriptor.getFontFile();
            if (file == null) {
                file = descriptor.getFontFile2();
            }
            if (file == null) {
                file = descriptor.getFontFile3();
            }
            descriptorNode.addChild("embedded").setValue(String.valueOf(file != null));
            if (file != null) {
                PDMetadata fontProgramMetadata = new PDMetadata(file.getKey(ASAtom.METADATA));
                GFCreateNodeHelper.parseMetadata(fontProgramMetadata, "embeddedFileMetadata", descriptorNode, collection);
            }
        }
    }

    private static void parseWidths(COSObject array, Long firstChar, FeatureTreeNode parent) throws FeatureParsingException {
        if (firstChar != null && array.getType() == COSObjType.COS_ARRAY) {
            int fc = firstChar.intValue() == -1 ? 0 : firstChar.intValue();
            for (int i = 0; i < array.size(); ++i) {
                FeatureTreeNode element = parent.addChild("width");
                COSObject arElement = array.at(i);
                if (arElement.getType().isNumber()) {
                    element.setValue(String.valueOf(arElement.getReal()));
                }
                element.setAttribute("char", String.valueOf(i + fc));
            }
        }
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            GFCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            GFCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            GFCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            GFCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            GFCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            GFCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            GFCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }

    private Double getDoubleFromDict(ASAtom key, COSObject dict) {
        COSObject res = dict.getKey(key);
        if (!res.getType().isNumber()) {
            return null;
        }
        return res.getReal();
    }

    private static String getStringFromDouble(Double d) {
        return d == null ? null : Double.toString(d);
    }
}

