/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.images.PDXForm;

public class GFFormXObjectFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDXForm formXObject;
    private String id;
    private String groupColorSpaceChild;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public GFFormXObjectFeaturesObject(PDXForm formXObject, String id, String groupColorSpaceChild, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.formXObject = formXObject;
        this.id = id;
        this.groupColorSpaceChild = groupColorSpaceChild;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.FORM_XOBJECT;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.formXObject != null && !this.formXObject.empty()) {
            Long structParents;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"xobject");
            root.setAttribute("type", "form");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            GFCreateNodeHelper.addBoxFeature("bbox", this.formXObject.getBBox(), root);
            GFCreateNodeHelper.parseMatrix(this.formXObject.getMatrix(), root.addChild("matrix"));
            PDGroup group = this.formXObject.getGroup();
            if (group != null) {
                FeatureTreeNode groupNode = root.addChild("group");
                ASAtom groupSubtype = group.getSubtype();
                if (groupSubtype != null) {
                    GFCreateNodeHelper.addNotEmptyNode("subtype", groupSubtype, groupNode);
                    if (ASAtom.TRANSPARENCY.equals((Object)groupSubtype)) {
                        if (this.groupColorSpaceChild != null) {
                            FeatureTreeNode clr = groupNode.addChild("colorSpace");
                            clr.setAttribute(ID, this.groupColorSpaceChild);
                        }
                        groupNode.addChild("isolated").setValue(String.valueOf(group.isIsolated()));
                        groupNode.addChild("knockout").setValue(String.valueOf(group.isKnockout()));
                    }
                }
            }
            if ((structParents = this.formXObject.getStructParents()) != null) {
                root.addChild("structParents").setValue(String.valueOf(structParents));
            }
            GFCreateNodeHelper.parseMetadata(this.formXObject.getMetadata(), "metadata", root, collection);
            this.parseResources(root);
            collection.addNewFeatureTree(FeatureObjectType.FORM_XOBJECT, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            GFCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            GFCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            GFCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            GFCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            GFCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            GFCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            GFCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

