/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.patterns.PDTilingPattern;

public class GFTilingPatternFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDTilingPattern tilingPattern;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public GFTilingPatternFeaturesObject(PDTilingPattern tilingPattern, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.tilingPattern = tilingPattern;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.PATTERN;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.tilingPattern != null && !this.tilingPattern.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"pattern");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("type", "tiling");
            root.addChild("paintType").setValue(String.valueOf(this.tilingPattern.getPaintType()));
            root.addChild("tilingType").setValue(String.valueOf(this.tilingPattern.getTilingType()));
            GFCreateNodeHelper.addBoxFeature("bbox", this.tilingPattern.getBBox(), root);
            root.addChild("xStep").setValue(String.valueOf(this.tilingPattern.getXStep()));
            root.addChild("yStep").setValue(String.valueOf(this.tilingPattern.getYStep()));
            GFCreateNodeHelper.parseMatrix(this.tilingPattern.getMatrix(), root.addChild("matrix"));
            this.parseResources(root);
            collection.addNewFeatureTree(FeatureObjectType.PATTERN, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            GFCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            GFCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            GFCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            GFCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            GFCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            GFCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            GFCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

