/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.cos.COSStream;
import org.verapdf.external.ICCProfile;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.ICCProfileFeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.gf.tools.GFCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.pd.PDMetadata;

public class GFICCProfileFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(GFICCProfileFeaturesObject.class.getCanonicalName());
    private static final String ID = "id";
    private static final int HEADER_SIZE = 128;
    private static final int FF_FLAG = 255;
    private static final int REQUIRED_LENGTH = 4;
    private static final int VERSION_BYTE = 8;
    private static final int SUBVERSION_BYTE = 9;
    private ICCProfile profile;
    private String id;

    public GFICCProfileFeaturesObject(ICCProfile profile, String id) {
        this.profile = profile;
        this.id = id;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.ICCPROFILE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.profile != null && !this.profile.empty()) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"iccProfile");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            this.parseProfileHeader(root, collection);
            PDMetadata meta = this.profile.getMetadata();
            if (meta != null) {
                GFCreateNodeHelper.parseMetadata(meta, "metadata", root, collection);
            }
            collection.addNewFeatureTree(FeatureObjectType.ICCPROFILE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        ASInputStream stream = this.profile.getObject().getData(COSStream.FilterFlags.DECODE);
        InputStream metadata = null;
        PDMetadata meta = this.profile.getMetadata();
        if (meta != null) {
            metadata = meta.getStream();
        }
        Integer n = null;
        Long profileN = this.profile.getNumberOfColorants();
        if (profileN != null) {
            n = profileN.intValue();
        }
        ArrayList<Double> range = null;
        double[] profileRange = this.profile.getRange();
        if (profileRange != null) {
            range = new ArrayList<Double>(profileRange.length);
            for (double value : profileRange) {
                range.add(value);
            }
        }
        return ICCProfileFeaturesData.newInstance((InputStream)metadata, (InputStream)stream, (Integer)n, range);
    }

    private void parseProfileHeader(FeatureTreeNode root, FeatureExtractionResult collection) throws FeatureParsingException {
        try (ASInputStream iccData = this.profile.getObject().getData(COSStream.FilterFlags.DECODE);){
            byte[] profileBytes = GFCreateNodeHelper.inputStreamToByteArray((InputStream)iccData);
            if (profileBytes.length < 128) {
                ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)root, (String)"ICCProfile contains less than 128 bytes");
            } else {
                GFCreateNodeHelper.addNotEmptyNode("version", GFICCProfileFeaturesObject.getVersion(profileBytes), root);
                GFCreateNodeHelper.addNotEmptyNode("cmmType", this.profile.getCMMType(), root);
                GFCreateNodeHelper.addNotEmptyNode("dataColorSpace", this.profile.getColorSpace(), root);
                GFCreateNodeHelper.addNotEmptyNode("creator", this.profile.getCreator(), root);
                GFCreateNodeHelper.createDateNode("creationDate", root, this.profile.getCreationDate(), collection);
                GFCreateNodeHelper.addNotEmptyNode("defaultRenderingIntent", this.profile.getRenderingIntent(), root);
                GFCreateNodeHelper.addNotEmptyNode("copyright", this.profile.getCopyright(), root);
                GFCreateNodeHelper.addNotEmptyNode("description", this.profile.getDescription(), root);
                GFCreateNodeHelper.addNotEmptyNode("profileId", this.profile.getProfileID(), root);
                GFCreateNodeHelper.addNotEmptyNode("deviceModel", this.profile.getDeviceModel(), root);
                GFCreateNodeHelper.addNotEmptyNode("deviceManufacturer", this.profile.getDeviceManufacturer(), root);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Reading byte array from InputStream error", e);
            ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)root, (String)e.getMessage());
        }
    }

    private static String getVersion(byte[] header) {
        if (header[8] == 0 && header[9] == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(header[8] & 0xFF).append(".");
        builder.append((header[9] & 0xFF) >>> 4);
        return builder.toString();
    }
}

