/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.gf.objects;

import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.features.objects.FontFeaturesObjectAdapter;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.font.PDCIDFont;
import org.verapdf.pd.font.PDCIDSystemInfo;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDFontDescriptor;
import org.verapdf.pd.font.PDType3Font;

public class GFFontFeaturesObjectAdapter
implements FontFeaturesObjectAdapter {
    private PDFont font;
    private String id;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;
    private FontFeaturesObjectAdapter.FontDescriptorAdapter fontDescriptorAdapter;

    public GFFontFeaturesObjectAdapter(PDFont font, String id, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.font = font;
        this.id = id;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
        if (font != null && !font.empty()) {
            PDFontDescriptor descriptor = this.font.getFontDescriptor();
            this.fontDescriptorAdapter = descriptor != null && !descriptor.empty() ? new GFFontDescriptorAdapter(descriptor) : null;
        }
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getExtGStateChild() {
        return this.extGStateChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.extGStateChild);
    }

    public Set<String> getColorSpaceChild() {
        return this.colorSpaceChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.colorSpaceChild);
    }

    public Set<String> getPatternChild() {
        return this.patternChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.patternChild);
    }

    public Set<String> getShadingChild() {
        return this.shadingChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.shadingChild);
    }

    public Set<String> getXObjectChild() {
        return this.xobjectChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.xobjectChild);
    }

    public Set<String> getFontChild() {
        return this.fontChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.fontChild);
    }

    public Set<String> getPropertiesChild() {
        return this.propertiesChild == null ? Collections.emptySet() : Collections.unmodifiableSet(this.propertiesChild);
    }

    public String getType() {
        if (this.font != null && !this.font.empty()) {
            ASAtom subtype = this.font.getSubtype();
            return subtype == null ? null : subtype.getValue();
        }
        return null;
    }

    public String getBaseFont() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getName();
        }
        return null;
    }

    public Long getFirstChar() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getFirstChar();
        }
        return null;
    }

    public Long getLastChar() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getLastChar();
        }
        return null;
    }

    public String getEncoding() {
        if (this.font != null && !this.font.empty()) {
            COSObject enc = this.font.getEncoding();
            if (enc.getType() == COSObjType.COS_NAME) {
                return enc.getString();
            }
            if (enc.getType() == COSObjType.COS_DICT) {
                ASAtom name = enc.getNameKey(ASAtom.BASE_ENCODING);
                return name == null ? null : name.getValue();
            }
        }
        return null;
    }

    public double[] getBoundingBox() {
        if (this.font != null && !this.font.empty() && this.font.getSubtype() == ASAtom.TYPE3) {
            PDType3Font type3 = (PDType3Font)this.font;
            return type3.getFontBoundingBox();
        }
        return null;
    }

    public double[] getMatrix() {
        if (this.font != null && !this.font.empty() && this.font.getSubtype() == ASAtom.TYPE3) {
            PDType3Font type3 = (PDType3Font)this.font;
            return type3.getFontMatrix();
        }
        return null;
    }

    public boolean isCIDSystemInfoPresent() {
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2)) {
            PDCIDFont cid = (PDCIDFont)this.font;
            PDCIDSystemInfo cidSystemInfo = cid.getCIDSystemInfo();
            return cidSystemInfo != null;
        }
        return false;
    }

    public Double getDefaultWidth() {
        if (this.font != null && !this.font.empty()) {
            return this.font.getDefaultWidth();
        }
        return null;
    }

    public String getCIDSysInfoRegistry() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getRegistry();
        }
        return null;
    }

    public String getCIDSysInfoOrdering() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getOrdering();
        }
        return null;
    }

    public Long getCIDSysInfoSupplement() {
        PDCIDFont cid;
        PDCIDSystemInfo cidSystemInfo;
        ASAtom subtype;
        if (!(this.font == null || this.font.empty() || (subtype = this.font.getSubtype()) != ASAtom.CID_FONT_TYPE0 && subtype != ASAtom.CID_FONT_TYPE2 || (cidSystemInfo = (cid = (PDCIDFont)this.font).getCIDSystemInfo()) == null)) {
            return cidSystemInfo.getSupplement();
        }
        return null;
    }

    public FontFeaturesObjectAdapter.FontDescriptorAdapter getFontDescriptor() {
        return this.fontDescriptorAdapter;
    }

    public boolean isPDFObjectPresent() {
        return this.font != null && !this.font.empty();
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }

    private static class GFFontDescriptorAdapter
    implements FontFeaturesObjectAdapter.FontDescriptorAdapter {
        private PDFontDescriptor descriptor;
        private COSStream file;
        private PDMetadata metadata;

        GFFontDescriptorAdapter(PDFontDescriptor descriptor) {
            this.descriptor = descriptor;
            this.file = descriptor.getFontFile();
            if (this.file == null) {
                this.file = descriptor.getFontFile2();
            }
            if (this.file == null) {
                this.file = descriptor.getFontFile3();
            }
            if (this.file != null) {
                this.metadata = new PDMetadata(this.file.getKey(ASAtom.METADATA));
            }
        }

        public String getFontName() {
            ASAtom fontName = this.descriptor.getFontName();
            return fontName == null ? null : fontName.getValue();
        }

        public String getFontFamily() {
            return this.descriptor.getFontFamily();
        }

        public String getFontStretch() {
            ASAtom fontStretch = this.descriptor.getFontStretch();
            return fontStretch == null ? null : fontStretch.getValue();
        }

        public Double getFontWeight() {
            return this.descriptor.getFontWeight();
        }

        public boolean isFixedPitch() {
            return this.descriptor.isFixedPitch();
        }

        public boolean isSerif() {
            return this.descriptor.isSerif();
        }

        public boolean isSymbolic() {
            return this.descriptor.isSymbolic();
        }

        public boolean isScript() {
            return this.descriptor.isScript();
        }

        public boolean isNonSymbolic() {
            return this.descriptor.isNonsymbolic();
        }

        public boolean isItalic() {
            return this.descriptor.isItalic();
        }

        public boolean isAllcap() {
            return this.descriptor.isAllCap();
        }

        public boolean isSmallCap() {
            return this.descriptor.isSmallCap();
        }

        public boolean isForceBold() {
            return this.descriptor.isForceBold();
        }

        public double[] getFontBoundingBox() {
            return this.descriptor.getFontBoundingBox();
        }

        public Double getItalicAngle() {
            return this.descriptor.getItalicAngle();
        }

        public Double getAscent() {
            return this.descriptor.getAscent();
        }

        public Double getDescent() {
            return this.descriptor.getDescent();
        }

        public Double getLeading() {
            return this.descriptor.getLeading();
        }

        public Double getCapHeight() {
            return this.descriptor.getCapHeight();
        }

        public Double getXHeight() {
            return this.descriptor.getXHeight();
        }

        public Double getStemV() {
            return this.descriptor.getStemV();
        }

        public Double getStemH() {
            return this.descriptor.getStemH();
        }

        public Double getAverageWidth() {
            return this.descriptor.getAvgWidth();
        }

        public Double getMaxWidth() {
            return this.descriptor.getMaxWidth();
        }

        public Double getMissingWidth() {
            return this.descriptor.getMissingWidth();
        }

        public String getCharSet() {
            return this.descriptor.getCharSet();
        }

        public boolean isEmbedded() {
            return this.file != null;
        }

        public Long getFlags() {
            return this.descriptor.getFlags();
        }

        public InputStream getMetadataStream() {
            return this.metadata == null || this.metadata.empty() ? null : this.metadata.getStream();
        }

        public InputStream getData() {
            return this.file == null || this.metadata.empty() ? null : this.file.getData(COSStream.FilterFlags.DECODE);
        }
    }
}

