/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDGroup;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBFormXObjectFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDFormXObject formXObject;
    private String id;
    private String groupColorSpaceChild;
    private Set<String> extGStateChild;
    private Set<String> colorSpaceChild;
    private Set<String> patternChild;
    private Set<String> shadingChild;
    private Set<String> xobjectChild;
    private Set<String> fontChild;
    private Set<String> propertiesChild;

    public PBFormXObjectFeaturesObject(PDFormXObject formXObject, String id, String groupColorSpaceChild, Set<String> extGStateChild, Set<String> colorSpaceChild, Set<String> patternChild, Set<String> shadingChild, Set<String> xobjectChild, Set<String> fontChild, Set<String> propertiesChild) {
        this.formXObject = formXObject;
        this.id = id;
        this.groupColorSpaceChild = groupColorSpaceChild;
        this.extGStateChild = extGStateChild;
        this.colorSpaceChild = colorSpaceChild;
        this.patternChild = patternChild;
        this.shadingChild = shadingChild;
        this.xobjectChild = xobjectChild;
        this.fontChild = fontChild;
        this.propertiesChild = propertiesChild;
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.FORM_XOBJECT;
    }

    @Override
    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.formXObject != null) {
            COSBase cosBase;
            FeatureTreeNode root = FeatureTreeNode.createRootNode("xobject");
            root.setAttribute("type", "form");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            PBCreateNodeHelper.addBoxFeature("bbox", this.formXObject.getBBox(), root);
            PBCreateNodeHelper.parseFloatMatrix(this.formXObject.getMatrix().getValues(), root.addChild("matrix"));
            PDGroup group = this.formXObject.getGroup();
            if (group != null) {
                FeatureTreeNode groupNode = root.addChild("group");
                if (group.getSubType() != null) {
                    PBCreateNodeHelper.addNotEmptyNode("subtype", group.getSubType().getName(), groupNode);
                    if ("Transparency".equals(group.getSubType().getName())) {
                        if (this.groupColorSpaceChild != null) {
                            FeatureTreeNode clr = groupNode.addChild("colorSpace");
                            clr.setAttribute(ID, this.groupColorSpaceChild);
                        }
                        groupNode.addChild("isolated").setValue(String.valueOf(group.isIsolated()));
                        groupNode.addChild("knockout").setValue(String.valueOf(group.isKnockout()));
                    }
                }
            }
            if (this.formXObject.getCOSStream().getItem(COSName.STRUCT_PARENTS) != null) {
                root.addChild("structParents").setValue(String.valueOf(this.formXObject.getStructParents()));
            }
            if ((cosBase = this.formXObject.getCOSStream().getDictionaryObject(COSName.METADATA)) instanceof COSStream) {
                PDMetadata meta = new PDMetadata((COSStream)cosBase);
                PBCreateNodeHelper.parseMetadata(meta, "metadata", root, collection);
            }
            this.parseResources(root);
            collection.addNewFeatureTree(FeatureObjectType.FORM_XOBJECT, root);
            return root;
        }
        return null;
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        if (this.extGStateChild != null && !this.extGStateChild.isEmpty() || this.colorSpaceChild != null && !this.colorSpaceChild.isEmpty() || this.patternChild != null && !this.patternChild.isEmpty() || this.shadingChild != null && !this.shadingChild.isEmpty() || this.xobjectChild != null && !this.xobjectChild.isEmpty() || this.fontChild != null && !this.fontChild.isEmpty() || this.propertiesChild != null && !this.propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            PBCreateNodeHelper.parseIDSet(this.extGStateChild, "graphicsState", "graphicsStates", resources);
            PBCreateNodeHelper.parseIDSet(this.colorSpaceChild, "colorSpace", "colorSpaces", resources);
            PBCreateNodeHelper.parseIDSet(this.patternChild, "pattern", "patterns", resources);
            PBCreateNodeHelper.parseIDSet(this.shadingChild, "shading", "shadings", resources);
            PBCreateNodeHelper.parseIDSet(this.xobjectChild, "xobject", "xobjects", resources);
            PBCreateNodeHelper.parseIDSet(this.fontChild, "font", "fonts", resources);
            PBCreateNodeHelper.parseIDSet(this.propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }
}

