/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.font;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.fontbox.cmap.CMap;
import org.apache.fontbox.cmap.CMapParser;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.impl.pb.external.PBoxCMapFile;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDCMap;

public class PBoxPDCMap
extends PBoxPDObject
implements PDCMap {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDCMap.class);
    public static final String CMAP_TYPE = "PDCMap";
    public static final String EMBEDDED_FILE = "embeddedFile";
    public static final String USE_C_MAP = "UseCMap";

    public PBoxPDCMap(CMap cMap, COSStream cMapFile) {
        super(cMap, cMapFile, CMAP_TYPE);
    }

    @Override
    public String getCMapName() {
        return this.cMap.getName();
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "embeddedFile": {
                return this.getEmbeddedFile();
            }
            case "UseCMap": {
                return this.getUseCMap();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<CMapFile> getEmbeddedFile() {
        if (this.simplePDObject instanceof COSStream) {
            ArrayList<PBoxCMapFile> result = new ArrayList<PBoxCMapFile>(1);
            result.add(new PBoxCMapFile((COSStream)this.simplePDObject));
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    private List<PDCMap> getUseCMap() {
        if (this.simplePDObject instanceof COSStream) {
            COSBase useCMap = ((COSStream)this.simplePDObject).getDictionaryObject(USE_C_MAP);
            try {
                CMapParser cMapParser = new CMapParser();
                PBoxPDCMap pBoxPDCMap = null;
                if (useCMap instanceof COSName) {
                    CMap pdfboxCMap = cMapParser.parsePredefined(((COSName)useCMap).getName());
                    pBoxPDCMap = new PBoxPDCMap(pdfboxCMap, null);
                } else if (useCMap instanceof COSStream) {
                    CMap pdfboxCMap = cMapParser.parse(((COSStream)useCMap).getUnfilteredStream());
                    pBoxPDCMap = new PBoxPDCMap(pdfboxCMap, (COSStream)useCMap);
                }
                if (pBoxPDCMap != null) {
                    ArrayList<PBoxPDCMap> result = new ArrayList<PBoxPDCMap>(1);
                    result.add(pBoxPDCMap);
                    return Collections.unmodifiableList(result);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Error while processing cmap", e);
            }
        }
        return Collections.emptyList();
    }
}

