/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.images;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObjectProxy;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.impl.pb.cos.PBCosDict;
import org.verapdf.model.impl.pb.pd.PBoxPDResources;
import org.verapdf.model.impl.pb.pd.images.PBoxPDSMaskImage;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXForm;
import org.verapdf.model.impl.pb.pd.images.PBoxPDXImage;
import org.verapdf.model.pdlayer.PDSMaskImage;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.model.tools.resources.PDInheritableResources;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDXObject
extends PBoxPDResources
implements PDXObject {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDXObject.class);
    protected final PDDocument document;
    protected final PDFAFlavour flavour;
    public static final String X_OBJECT_TYPE = "PDXObject";
    public static final String OPI = "OPI";
    public static final String S_MASK = "SMask";
    protected final PDInheritableResources resources;
    private final String subtype;

    public PBoxPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject simplePDObject, PDDocument document, PDFAFlavour flavour) {
        this(simplePDObject, PDInheritableResources.EMPTY_EXTENDED_RESOURCES, X_OBJECT_TYPE, document, flavour);
    }

    protected PBoxPDXObject(COSObjectable simplePDObject, PDInheritableResources resources, String type, PDDocument document, PDFAFlavour flavour) {
        super(simplePDObject, type);
        this.resources = resources;
        this.subtype = PBoxPDXObject.getSubtype((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject);
        this.document = document;
        this.flavour = flavour;
    }

    private static String getSubtype(org.apache.pdfbox.pdmodel.graphics.PDXObject object) {
        COSBase base = object.getCOSStream().getDictionaryObject(COSName.SUBTYPE);
        return base instanceof COSName ? ((COSName)base).getName() : null;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "SMask": {
                return this.getSMask();
            }
            case "OPI": {
                return this.getOPI();
            }
        }
        return super.getLinkedObjects(link);
    }

    protected List<PDSMaskImage> getSMask() {
        try {
            PDSMaskImage xObject;
            COSStream cosStream = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
            COSBase smaskDictionary = cosStream.getDictionaryObject(COSName.SMASK);
            if (smaskDictionary instanceof COSDictionary && (xObject = this.getXObject(smaskDictionary)) != null) {
                ArrayList<PDSMaskImage> mask = new ArrayList<PDSMaskImage>(1);
                mask.add(xObject);
                return Collections.unmodifiableList(mask);
            }
        }
        catch (IOException e) {
            LOGGER.debug("Problems with obtaining SMask. " + e.getMessage(), e);
        }
        return Collections.emptyList();
    }

    private PDSMaskImage getXObject(COSBase smaskDictionary) throws IOException {
        org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject;
        COSName name = ((COSDictionary)smaskDictionary).getCOSName(COSName.NAME);
        String nameAsString = name != null ? name.getName() : null;
        PDResources resourcesLocal = null;
        if (this.simplePDObject instanceof PDFormXObject) {
            resourcesLocal = ((PDFormXObject)this.simplePDObject).getResources();
        }
        if ((pbObject = org.apache.pdfbox.pdmodel.graphics.PDXObject.createXObject(smaskDictionary, nameAsString, resourcesLocal)) instanceof PDImageXObjectProxy) {
            return new PBoxPDSMaskImage((PDImageXObjectProxy)pbObject, this.resources, this.document, this.flavour);
        }
        LOGGER.debug("SMask object is not an Image XObject");
        return null;
    }

    public static PDXObject getTypedPDXObject(org.apache.pdfbox.pdmodel.graphics.PDXObject pbObject, PDInheritableResources extendedResources, PDDocument document, PDFAFlavour flavour) {
        if (pbObject instanceof PDFormXObject) {
            PDFormXObject object = (PDFormXObject)pbObject;
            PDInheritableResources resources = extendedResources.getExtendedResources(object.getResources());
            return new PBoxPDXForm(object, resources, document, flavour);
        }
        if (pbObject instanceof PDImageXObjectProxy) {
            return new PBoxPDXImage((PDImageXObjectProxy)pbObject, extendedResources, document, flavour);
        }
        if (pbObject instanceof PDPostScriptXObject) {
            return new PBoxPDXObject(pbObject, document, flavour);
        }
        return null;
    }

    protected List<CosDict> getOPI() {
        return this.getLinkToDictionary(OPI);
    }

    protected List<CosDict> getLinkToDictionary(String key) {
        COSStream object = ((org.apache.pdfbox.pdmodel.graphics.PDXObject)this.simplePDObject).getCOSStream();
        COSBase item = object.getDictionaryObject(COSName.getPDFName(key));
        if (item instanceof COSDictionary) {
            ArrayList<PBCosDict> list = new ArrayList<PBCosDict>(1);
            list.add(new PBCosDict((COSDictionary)item, this.document, this.flavour));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

