/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.objects;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.objects.Feature;
import org.verapdf.features.objects.FeaturesObject;
import org.verapdf.features.objects.TilingPatternFeaturesObjectAdapter;
import org.verapdf.features.tools.CreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class TilingPatternFeaturesObject
extends FeaturesObject {
    private static final String ID = "id";

    public TilingPatternFeaturesObject(TilingPatternFeaturesObjectAdapter adapter) {
        super(adapter);
    }

    @Override
    public FeatureObjectType getType() {
        return FeatureObjectType.PATTERN;
    }

    @Override
    public FeatureTreeNode collectFeatures() throws FeatureParsingException {
        TilingPatternFeaturesObjectAdapter tpAdapter = (TilingPatternFeaturesObjectAdapter)this.adapter;
        FeatureTreeNode root = FeatureTreeNode.createRootNode("pattern");
        String id = tpAdapter.getID();
        if (id != null) {
            root.setAttribute(ID, id);
        }
        root.setAttribute("type", "tiling");
        root.addChild("paintType").setValue(String.valueOf(tpAdapter.getPaintType()));
        root.addChild("tilingType").setValue(String.valueOf(tpAdapter.getTilingType()));
        double[] bBox = tpAdapter.getBBox();
        CreateNodeHelper.addWidthHeightFeatures(bBox, root);
        CreateNodeHelper.addBoxFeature("bbox", bBox, root);
        root.addChild("xStep").setValue(String.format("%.3f", tpAdapter.getXStep()));
        root.addChild("yStep").setValue(String.format("%.3f", tpAdapter.getYStep()));
        CreateNodeHelper.parseMatrix(tpAdapter.getMatrix(), root.addChild("matrix"));
        this.parseResources(root);
        return root;
    }

    private void parseResources(FeatureTreeNode root) throws FeatureParsingException {
        TilingPatternFeaturesObjectAdapter tpAdapter = (TilingPatternFeaturesObjectAdapter)this.adapter;
        Set<String> extGStateChild = tpAdapter.getExtGStateChild();
        Set<String> colorSpaceChild = tpAdapter.getColorSpaceChild();
        Set<String> patternChild = tpAdapter.getPatternChild();
        Set<String> shadingChild = tpAdapter.getShadingChild();
        Set<String> xobjectChild = tpAdapter.getXObjectChild();
        Set<String> fontChild = tpAdapter.getFontChild();
        Set<String> propertiesChild = tpAdapter.getPropertiesChild();
        if (extGStateChild != null && !extGStateChild.isEmpty() || colorSpaceChild != null && !colorSpaceChild.isEmpty() || patternChild != null && !patternChild.isEmpty() || shadingChild != null && !shadingChild.isEmpty() || xobjectChild != null && !xobjectChild.isEmpty() || fontChild != null && !fontChild.isEmpty() || propertiesChild != null && !propertiesChild.isEmpty()) {
            FeatureTreeNode resources = root.addChild("resources");
            CreateNodeHelper.parseIDSet(extGStateChild, "graphicsState", "graphicsStates", resources);
            CreateNodeHelper.parseIDSet(colorSpaceChild, "colorSpace", "colorSpaces", resources);
            CreateNodeHelper.parseIDSet(patternChild, "pattern", "patterns", resources);
            CreateNodeHelper.parseIDSet(shadingChild, "shading", "shadings", resources);
            CreateNodeHelper.parseIDSet(xobjectChild, "xobject", "xobjects", resources);
            CreateNodeHelper.parseIDSet(fontChild, "font", "fonts", resources);
            CreateNodeHelper.parseIDSet(propertiesChild, "propertiesDict", "propertiesDicts", resources);
        }
    }

    @Override
    public FeaturesData getData() {
        return null;
    }

    static List<Feature> getFeaturesList() {
        return Collections.emptyList();
    }
}

