/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.operators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Stack;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.factory.operators.TransparencyGraphicsState;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.gf.model.impl.operator.color.GFOpColor;
import org.verapdf.gf.model.impl.operator.color.GFOpSetColor;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_J_line_cap;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_M_miter_limit;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_d;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_gs;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_i;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_j_line_join;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_ri;
import org.verapdf.gf.model.impl.operator.generalgs.GFOp_w_line_width;
import org.verapdf.gf.model.impl.operator.inlineimage.GFOp_BI;
import org.verapdf.gf.model.impl.operator.inlineimage.GFOp_EI;
import org.verapdf.gf.model.impl.operator.inlineimage.GFOp_ID;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_BDC;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_BMC;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_DP;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_EMC;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOp_MP;
import org.verapdf.gf.model.impl.operator.opclip.GFOp_WStar;
import org.verapdf.gf.model.impl.operator.opclip.GFOp_W_clip;
import org.verapdf.gf.model.impl.operator.opcompability.GFOp_BX;
import org.verapdf.gf.model.impl.operator.opcompability.GFOp_EX;
import org.verapdf.gf.model.impl.operator.opcompability.GFOp_Undefined;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_c;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_h;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_l;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_m_moveto;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_re;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_v;
import org.verapdf.gf.model.impl.operator.pathconstruction.GFOp_y;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOpPathPaint;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_BStar_eofill_stroke;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_B_fill_stroke;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_FStar;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_F_fill_obsolete;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_S_stroke;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_b_closepath_fill_stroke;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_bstar_closepath_eofill_stroke;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_f_fill;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_n;
import org.verapdf.gf.model.impl.operator.pathpaint.GFOp_s_close_stroke;
import org.verapdf.gf.model.impl.operator.shading.GFOp_sh;
import org.verapdf.gf.model.impl.operator.specialgs.GFOp_Q_grestore;
import org.verapdf.gf.model.impl.operator.specialgs.GFOp_cm;
import org.verapdf.gf.model.impl.operator.specialgs.GFOp_q_gsave;
import org.verapdf.gf.model.impl.operator.textobject.GFOpTextObject;
import org.verapdf.gf.model.impl.operator.textposition.GFOpTextPosition;
import org.verapdf.gf.model.impl.operator.textposition.GFOp_TD_Big;
import org.verapdf.gf.model.impl.operator.textposition.GFOp_Td;
import org.verapdf.gf.model.impl.operator.textposition.GFOp_Tm;
import org.verapdf.gf.model.impl.operator.textshow.GFOpTextShow;
import org.verapdf.gf.model.impl.operator.textshow.GFOp_DoubleQuote;
import org.verapdf.gf.model.impl.operator.textshow.GFOp_Quote;
import org.verapdf.gf.model.impl.operator.textshow.GFOp_TJ_Big;
import org.verapdf.gf.model.impl.operator.textshow.GFOp_Tj;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tc;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tf;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tl;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tr;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Ts;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tw;
import org.verapdf.gf.model.impl.operator.textstate.GFOp_Tz;
import org.verapdf.gf.model.impl.operator.type3font.GFOp_d0;
import org.verapdf.gf.model.impl.operator.type3font.GFOp_d1;
import org.verapdf.gf.model.impl.operator.xobject.GFOp_Do;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.gf.model.impl.pd.font.GFPDFont;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.gf.model.tools.FileSpecificationKeysHelper;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.operator.InlineImageOperator;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.structure.StructureElementAccessObject;
import org.verapdf.pdfa.flavours.PDFAFlavour;

class OperatorParser {
    private final Deque<GraphicState> graphicStateStack = new ArrayDeque<GraphicState>();
    private GraphicState graphicState;
    private final Deque<TransparencyGraphicsState> transparencyGraphicStateStack = new ArrayDeque<TransparencyGraphicsState>();
    private Stack<GFOpMarkedContent> markedContentStack = new Stack();
    private StructureElementAccessObject structureElementAccessObject;
    private TransparencyGraphicsState transparencyGraphicState = new TransparencyGraphicsState();

    OperatorParser(GraphicState inheritedGraphicState, StructureElementAccessObject structureElementAccessObject) {
        this.graphicState = inheritedGraphicState == null ? new GraphicState() : inheritedGraphicState;
        this.structureElementAccessObject = structureElementAccessObject;
    }

    public TransparencyGraphicsState getTransparencyGraphicState() {
        TransparencyGraphicsState tgs = new TransparencyGraphicsState();
        tgs.copyProperties(this.transparencyGraphicState);
        return tgs;
    }

    public RenderingMode getGSRenderingMode() {
        return this.graphicState.getRenderingMode();
    }

    void parseOperator(List<Operator> processedOperators, org.verapdf.operator.Operator rawOperator, PDResourcesHandler resourcesHandler, List<COSBase> arguments) {
        String operatorName;
        switch (operatorName = rawOperator.getOperator()) {
            case "d": {
                processedOperators.add(new GFOp_d(arguments));
                break;
            }
            case "gs": {
                OperatorParser.processExtGState(processedOperators, arguments, resourcesHandler, this.graphicState, this.transparencyGraphicState);
                break;
            }
            case "i": {
                processedOperators.add(new GFOp_i(arguments));
                break;
            }
            case "J": {
                processedOperators.add(new GFOp_J_line_cap(arguments));
                break;
            }
            case "j": {
                processedOperators.add(new GFOp_j_line_join(arguments));
                break;
            }
            case "M": {
                processedOperators.add(new GFOp_M_miter_limit(arguments));
                break;
            }
            case "ri": {
                processedOperators.add(new GFOp_ri(arguments));
                break;
            }
            case "w": {
                processedOperators.add(new GFOp_w_line_width(arguments));
                break;
            }
            case "BMC": {
                GFOp_BMC bmcOp = new GFOp_BMC(arguments);
                processedOperators.add(bmcOp);
                this.markedContentStack.push(bmcOp);
                break;
            }
            case "BDC": {
                PDFAFlavour.Specification specification = StaticContainers.getFlavour().getPart();
                if (specification == PDFAFlavour.Specification.ISO_19005_3 || specification == PDFAFlavour.Specification.ISO_19005_4) {
                    OperatorParser.checkAFKey(arguments, resourcesHandler);
                }
                GFOp_BDC bdcOp = new GFOp_BDC(arguments);
                processedOperators.add(bdcOp);
                this.markedContentStack.push(bdcOp);
                break;
            }
            case "EMC": {
                processedOperators.add(new GFOp_EMC(arguments));
                this.markedContentStack.pop();
                break;
            }
            case "MP": {
                processedOperators.add(new GFOp_MP(arguments));
                break;
            }
            case "DP": {
                processedOperators.add(new GFOp_DP(arguments));
                break;
            }
            case "W": {
                processedOperators.add(new GFOp_W_clip(arguments));
                break;
            }
            case "W*": {
                processedOperators.add(new GFOp_WStar(arguments));
                break;
            }
            case "G": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceGray.INSTANCE, ASAtom.DEVICEGRAY, true);
                processedOperators.add(OperatorParser.getStrokeColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "g": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceGray.INSTANCE, ASAtom.DEVICEGRAY, false);
                processedOperators.add(OperatorParser.getFillColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "RG": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceRGB.INSTANCE, ASAtom.DEVICERGB, true);
                processedOperators.add(OperatorParser.getStrokeColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "rg": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceRGB.INSTANCE, ASAtom.DEVICERGB, false);
                processedOperators.add(OperatorParser.getFillColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "K": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceCMYK.INSTANCE, ASAtom.DEVICECMYK, true);
                processedOperators.add(OperatorParser.getStrokeColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "k": {
                OperatorParser.processColorSpace(this.graphicState, resourcesHandler, PDDeviceCMYK.INSTANCE, ASAtom.DEVICECMYK, false);
                processedOperators.add(OperatorParser.getFillColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "CS": {
                this.graphicState.setStrokeColorSpace(resourcesHandler.getColorSpace(OperatorParser.getLastCOSName(arguments)));
                processedOperators.add(OperatorParser.getStrokeColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "cs": {
                this.graphicState.setFillColorSpace(resourcesHandler.getColorSpace(OperatorParser.getLastCOSName(arguments)));
                processedOperators.add(OperatorParser.getFillColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "SCN": {
                OperatorParser.processPatternColorSpace(arguments, this.graphicState, resourcesHandler, this.graphicState.getStrokeColorSpace(), true);
                processedOperators.add(OperatorParser.getStrokeColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "scn": {
                OperatorParser.processPatternColorSpace(arguments, this.graphicState, resourcesHandler, this.graphicState.getFillColorSpace(), false);
                processedOperators.add(OperatorParser.getFillColorOperator(arguments, resourcesHandler, this.graphicState));
                break;
            }
            case "SC": {
                processedOperators.add(new GFOpSetColor(arguments));
                break;
            }
            case "sc": {
                processedOperators.add(new GFOpSetColor(arguments));
                break;
            }
            case "ET": 
            case "BT": {
                processedOperators.add(new GFOpTextObject(arguments));
                break;
            }
            case "Td": {
                processedOperators.add(new GFOp_Td(arguments));
                break;
            }
            case "TD": {
                processedOperators.add(new GFOp_TD_Big(arguments));
                break;
            }
            case "Tm": {
                processedOperators.add(new GFOp_Tm(arguments));
                break;
            }
            case "T*": {
                processedOperators.add(new GFOpTextPosition(arguments));
                break;
            }
            case "Tj": {
                GFOp_Tj tj = new GFOp_Tj(arguments, this.graphicState.clone(), resourcesHandler, this.getCurrentMarkedContent(), this.structureElementAccessObject);
                OperatorParser.addFontAndColorSpace(tj, this.transparencyGraphicState);
                processedOperators.add(tj);
                break;
            }
            case "TJ": {
                GFOp_TJ_Big tjBig = new GFOp_TJ_Big(arguments, this.graphicState.clone(), resourcesHandler, this.getCurrentMarkedContent(), this.structureElementAccessObject);
                OperatorParser.addFontAndColorSpace(tjBig, this.transparencyGraphicState);
                processedOperators.add(tjBig);
                break;
            }
            case "'": {
                GFOp_Quote quote = new GFOp_Quote(arguments, this.graphicState.clone(), resourcesHandler, this.getCurrentMarkedContent(), this.structureElementAccessObject);
                OperatorParser.addFontAndColorSpace(quote, this.transparencyGraphicState);
                processedOperators.add(quote);
                break;
            }
            case "\"": {
                GFOp_DoubleQuote doubleQuote = new GFOp_DoubleQuote(arguments, this.graphicState.clone(), resourcesHandler, this.getCurrentMarkedContent(), this.structureElementAccessObject);
                OperatorParser.addFontAndColorSpace(doubleQuote, this.transparencyGraphicState);
                processedOperators.add(doubleQuote);
                break;
            }
            case "Tz": {
                processedOperators.add(new GFOp_Tz(arguments));
                break;
            }
            case "Tr": {
                this.graphicState.setRenderingMode(OperatorParser.getRenderingMode(arguments));
                processedOperators.add(new GFOp_Tr(arguments));
                break;
            }
            case "Tf": {
                this.graphicState.setFontName(OperatorParser.getFirstCOSName(arguments));
                processedOperators.add(new GFOp_Tf(arguments));
                break;
            }
            case "Tc": {
                processedOperators.add(new GFOp_Tc(arguments));
                break;
            }
            case "Tw": {
                processedOperators.add(new GFOp_Tw(arguments));
                break;
            }
            case "TL": {
                processedOperators.add(new GFOp_Tl(arguments));
                break;
            }
            case "Ts": {
                processedOperators.add(new GFOp_Ts(arguments));
                break;
            }
            case "d0": {
                processedOperators.add(new GFOp_d0(arguments));
                break;
            }
            case "d1": {
                processedOperators.add(new GFOp_d1(arguments));
                break;
            }
            case "BI": {
                OperatorParser.processInlineImage(processedOperators, (InlineImageOperator)rawOperator, resourcesHandler, arguments);
                break;
            }
            case "BX": {
                processedOperators.add(new GFOp_BX(arguments));
                break;
            }
            case "EX": {
                processedOperators.add(new GFOp_EX(arguments));
                break;
            }
            case "c": {
                processedOperators.add(new GFOp_c(arguments));
                break;
            }
            case "h": {
                processedOperators.add(new GFOp_h(arguments));
                break;
            }
            case "l": {
                processedOperators.add(new GFOp_l(arguments));
                break;
            }
            case "m": {
                processedOperators.add(new GFOp_m_moveto(arguments));
                break;
            }
            case "re": {
                processedOperators.add(new GFOp_re(arguments));
                break;
            }
            case "v": {
                processedOperators.add(new GFOp_v(arguments));
                break;
            }
            case "y": {
                processedOperators.add(new GFOp_y(arguments));
                break;
            }
            case "b": {
                GFOp_b_closepath_fill_stroke b_closepath_fill_stroke = new GFOp_b_closepath_fill_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(b_closepath_fill_stroke, this.transparencyGraphicState);
                processedOperators.add(b_closepath_fill_stroke);
                break;
            }
            case "B": {
                GFOp_B_fill_stroke b_fill_stroke = new GFOp_B_fill_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(b_fill_stroke, this.transparencyGraphicState);
                processedOperators.add(b_fill_stroke);
                break;
            }
            case "b*": {
                GFOp_bstar_closepath_eofill_stroke bstar_closepath_eofill_stroke = new GFOp_bstar_closepath_eofill_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(bstar_closepath_eofill_stroke, this.transparencyGraphicState);
                processedOperators.add(bstar_closepath_eofill_stroke);
                break;
            }
            case "B*": {
                GFOp_BStar_eofill_stroke bStar_eofill_stroke = new GFOp_BStar_eofill_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(bStar_eofill_stroke, this.transparencyGraphicState);
                processedOperators.add(bStar_eofill_stroke);
                break;
            }
            case "f": {
                GFOp_f_fill f_fill = new GFOp_f_fill(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(f_fill, this.transparencyGraphicState);
                processedOperators.add(f_fill);
                break;
            }
            case "F": {
                GFOp_F_fill_obsolete f_fill_obsolete = new GFOp_F_fill_obsolete(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(f_fill_obsolete, this.transparencyGraphicState);
                processedOperators.add(f_fill_obsolete);
                break;
            }
            case "f*": {
                GFOp_FStar fStar = new GFOp_FStar(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(fStar, this.transparencyGraphicState);
                processedOperators.add(fStar);
                break;
            }
            case "n": {
                GFOp_n op_n = new GFOp_n(arguments);
                OperatorParser.addColorSpace(op_n, this.transparencyGraphicState);
                processedOperators.add(op_n);
                break;
            }
            case "s": {
                GFOp_s_close_stroke s_close_stroke = new GFOp_s_close_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(s_close_stroke, this.transparencyGraphicState);
                processedOperators.add(s_close_stroke);
                break;
            }
            case "S": {
                GFOp_S_stroke s_stroke = new GFOp_S_stroke(arguments, this.graphicState, resourcesHandler);
                OperatorParser.addColorSpace(s_stroke, this.transparencyGraphicState);
                processedOperators.add(s_stroke);
            }
            case "sh": {
                processedOperators.add(new GFOp_sh(arguments, resourcesHandler.getShading(OperatorParser.getLastCOSName(arguments))));
                break;
            }
            case "cm": {
                processedOperators.add(new GFOp_cm(arguments));
                break;
            }
            case "Q": {
                if (!this.graphicStateStack.isEmpty()) {
                    this.graphicState.copyProperties(this.graphicStateStack.pop());
                }
                if (!this.transparencyGraphicStateStack.isEmpty()) {
                    this.transparencyGraphicState.copyProperties(this.transparencyGraphicStateStack.pop());
                }
                processedOperators.add(new GFOp_Q_grestore(arguments));
                break;
            }
            case "q": {
                this.graphicStateStack.push(this.graphicState.clone());
                this.transparencyGraphicStateStack.push(this.transparencyGraphicState.clone());
                processedOperators.add(new GFOp_q_gsave(arguments, this.graphicStateStack.size()));
                break;
            }
            case "Do": {
                GFOp_Do op_do = new GFOp_Do(arguments, resourcesHandler.getXObject(OperatorParser.getLastCOSName(arguments)), resourcesHandler, this.graphicState.clone());
                List<PDXObject> pdxObjects = op_do.getXObject();
                if (!pdxObjects.isEmpty()) {
                    GFPDXObject xobj = (GFPDXObject)pdxObjects.get(0);
                    this.transparencyGraphicState.setVeraXObject(xobj);
                }
                processedOperators.add(op_do);
                break;
            }
            default: {
                processedOperators.add(new GFOp_Undefined(arguments));
            }
        }
    }

    private static GFOpColor getStrokeColorOperator(List<COSBase> arguments, PDResourcesHandler resourcesHandler, GraphicState graphicState) {
        org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(graphicState.getStrokeColorSpace(), resourcesHandler, graphicState.getOpm(), graphicState.isOverprintingFlagStroke(), graphicState);
        return new GFOpColor(arguments, colorSpace);
    }

    private static GFOpColor getFillColorOperator(List<COSBase> arguments, PDResourcesHandler resourcesHandler, GraphicState graphicState) {
        org.verapdf.model.pdlayer.PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace(graphicState.getFillColorSpace(), resourcesHandler, graphicState.getOpm(), graphicState.isOverprintingFlagNonStroke(), graphicState);
        return new GFOpColor(arguments, colorSpace);
    }

    private static void processExtGState(List<Operator> processedOperators, List<COSBase> arguments, PDResourcesHandler resourcesHandler, GraphicState graphicState, TransparencyGraphicsState transparencyGraphicsState) {
        PDExtGState extGState = resourcesHandler.getExtGState(OperatorParser.getLastCOSName(arguments));
        graphicState.copyPropertiesFormExtGState(extGState);
        transparencyGraphicsState.copyPropertiesFormExtGState(extGState);
        processedOperators.add(new GFOp_gs(arguments, extGState));
    }

    private static void processColorSpace(GraphicState graphicState, PDResourcesHandler resourcesHandler, PDColorSpace defaultCS, ASAtom name, boolean stroke) {
        PDColorSpace colorSpace = resourcesHandler.getColorSpace(name);
        if (colorSpace == null) {
            colorSpace = defaultCS;
        }
        if (stroke) {
            graphicState.setStrokeColorSpace(colorSpace);
        } else {
            graphicState.setFillColorSpace(colorSpace);
        }
    }

    private static void processPatternColorSpace(List<COSBase> arguments, GraphicState graphicState, PDResourcesHandler resourcesHandler, PDColorSpace colorSpace, boolean stroke) {
        if (colorSpace != null && ASAtom.PATTERN == colorSpace.getType()) {
            if (stroke) {
                graphicState.setStrokeColorSpace(resourcesHandler.getPattern(OperatorParser.getLastCOSName(arguments)));
            } else {
                graphicState.setFillColorSpace(resourcesHandler.getPattern(OperatorParser.getLastCOSName(arguments)));
            }
        }
    }

    private static void processInlineImage(List<Operator> processedOperators, InlineImageOperator rawOperator, PDResourcesHandler resourcesHandler, List<COSBase> arguments) {
        if (rawOperator.getImageParameters() != null) {
            arguments.add(rawOperator.getImageParameters());
            processedOperators.add(new GFOp_BI(new ArrayList<COSBase>()));
            processedOperators.add(new GFOp_ID(arguments));
            processedOperators.add(new GFOp_EI(arguments, resourcesHandler));
        }
    }

    private static RenderingMode getRenderingMode(List<COSBase> arguments) {
        COSBase renderingMode;
        if (!arguments.isEmpty() && (renderingMode = arguments.get(0)) instanceof COSInteger) {
            return RenderingMode.getRenderingMode(renderingMode.getInteger().intValue());
        }
        return RenderingMode.FILL;
    }

    private static COSName getFirstCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(0);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static COSName getLastCOSName(List<COSBase> arguments) {
        COSBase lastElement;
        COSBase cOSBase = lastElement = arguments.isEmpty() ? null : arguments.get(arguments.size() - 1);
        if (lastElement instanceof COSName) {
            return (COSName)lastElement;
        }
        return null;
    }

    private static void addFontAndColorSpace(GFOpTextShow op, TransparencyGraphicsState transparencyGraphicsState) {
        GFPDFont font = (GFPDFont)op.getVeraModelFont();
        transparencyGraphicsState.setVeraFont(font);
        byte[] charCodes = op.getCharCodes();
        transparencyGraphicsState.setCharCodes(charCodes);
        GFPDColorSpace fillCS = (GFPDColorSpace)op.getVeraModelFillColorSpace();
        transparencyGraphicsState.setVeraFillColorSpace(fillCS);
        GFPDColorSpace strokeCS = (GFPDColorSpace)op.getVeraModelStrokeColorSpace();
        transparencyGraphicsState.setVeraStrokeColorSpace(strokeCS);
    }

    private static void addColorSpace(GFOpPathPaint op, TransparencyGraphicsState transparencyGraphicsState) {
        GFPDColorSpace fillCS = (GFPDColorSpace)op.getVeraFillCS();
        transparencyGraphicsState.setVeraFillColorSpace(fillCS);
        GFPDColorSpace strokeCS = (GFPDColorSpace)op.getVeraStrokeCS();
        transparencyGraphicsState.setVeraStrokeColorSpace(strokeCS);
    }

    private static void checkAFKey(List<COSBase> arguments, PDResourcesHandler resourcesHandler) {
        COSObject cosProperties;
        PDResource properties;
        COSBase propKey;
        COSBase tag;
        int argumentsSize = arguments.size();
        if (argumentsSize > 1 && OperatorParser.isMarkedContentAFKeyAndValueTypeCorrect(tag = arguments.get(argumentsSize - 2), propKey = arguments.get(argumentsSize - 1)) && (properties = resourcesHandler.getProperties(propKey.getName())) != null && (cosProperties = properties.getObject()) != null && cosProperties.getType() == COSObjType.COS_ARRAY) {
            FileSpecificationKeysHelper.registerFileSpecificationKeys((COSArray)cosProperties.getDirectBase());
        }
    }

    private static boolean isMarkedContentAFKeyAndValueTypeCorrect(COSBase tag, COSBase propKey) {
        if (tag == null || propKey == null) {
            return false;
        }
        if (tag.getType() != COSObjType.COS_NAME || propKey.getType() != COSObjType.COS_NAME) {
            return false;
        }
        return ASAtom.AF == tag.getName();
    }

    private GFOpMarkedContent getCurrentMarkedContent() {
        if (this.markedContentStack.empty()) {
            return null;
        }
        return (GFOpMarkedContent)this.markedContentStack.firstElement();
    }
}

