/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosIndirect;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosIndirect;
import org.verapdf.model.coslayer.CosTrailer;

public class GFCosTrailer
extends GFCosDict
implements CosTrailer {
    private static final Logger LOGGER = Logger.getLogger(GFCosTrailer.class.getCanonicalName());
    public static final String COS_TRAILER_TYPE = "CosTrailer";
    public static final String CATALOG = "Catalog";
    private final boolean isEncrypted;

    public GFCosTrailer(COSDictionary dictionary) {
        super(dictionary, COS_TRAILER_TYPE);
        this.isEncrypted = dictionary.getKey(ASAtom.ENCRYPT).get() != null;
    }

    @Override
    public Boolean getisEncrypted() {
        return this.isEncrypted;
    }

    @Override
    public List<? extends Object> getLinkedObjects(String link) {
        if (CATALOG.equals(link)) {
            return this.getCatalog();
        }
        return super.getLinkedObjects(link);
    }

    private List<CosIndirect> getCatalog() {
        ArrayList<GFCosIndirect> result = new ArrayList<GFCosIndirect>(1);
        COSObject catalog = this.baseObject.getKey(ASAtom.ROOT);
        if (catalog.isIndirect().booleanValue()) {
            result.add(new GFCosIndirect((COSIndirect)catalog.get()));
        } else {
            LOGGER.log(Level.WARNING, "Catalog shall be an indirect reference");
        }
        return Collections.unmodifiableList(result);
    }
}

