/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.containers.StaticContainers;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDAppearanceEntry;
import org.verapdf.pd.PDAppearanceStream;
import org.verapdf.pd.PDCatalog;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDPage;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType3Font;
import org.verapdf.pd.images.PDXForm;
import org.verapdf.pd.images.PDXImage;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShadingPattern;
import org.verapdf.pd.patterns.PDTilingPattern;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.pd.structure.PDStructTreeNode;

public class FileSpecificationKeysHelper {
    private static final Logger LOGGER = Logger.getLogger(FileSpecificationKeysHelper.class.getCanonicalName());
    private static Set<COSKey> visitedKeys = new HashSet<COSKey>();

    public static void registerFileSpecificationKeys(COSDocument document) {
        PDDocument pdDocument = document.getPDDocument();
        if (pdDocument == null) {
            return;
        }
        PDCatalog catalog = pdDocument.getCatalog();
        if (catalog != null) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(catalog.getObject());
            FileSpecificationKeysHelper.processStructElements(catalog.getStructTreeRoot());
        }
        List<PDPage> pages = pdDocument.getPages();
        for (PDPage page : pages) {
            FileSpecificationKeysHelper.processPage(page);
        }
        visitedKeys.clear();
    }

    public static void registerFileSpecificationKeys(COSArray array) {
        for (COSObject element : array) {
            FileSpecificationKeysHelper.addElementKey(element);
        }
    }

    private static void processStructElements(PDStructTreeNode structureNode) {
        if (structureNode != null) {
            for (PDStructElem obj : structureNode.getChildren()) {
                FileSpecificationKeysHelper.registerDictionaryAFKeys(obj.getObject());
                FileSpecificationKeysHelper.processStructElements(obj);
            }
        }
    }

    private static void processPage(PDPage page) {
        if (page != null) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(page.getObject());
            for (PDAnnotation annotation : page.getAnnotations()) {
                if (annotation == null) continue;
                FileSpecificationKeysHelper.registerDictionaryAFKeys(annotation.getObject());
                for (PDAppearanceStream stream : FileSpecificationKeysHelper.getAllAppearances(annotation)) {
                    FileSpecificationKeysHelper.processXObject(stream);
                }
            }
            FileSpecificationKeysHelper.parseResources(page.getResources());
        }
    }

    private static void processXObject(PDXObject xObject) {
        if (xObject != null && !FileSpecificationKeysHelper.isKeyVisited(xObject.getObject().getKey())) {
            FileSpecificationKeysHelper.registerDictionaryAFKeys(xObject.getObject());
            if (ASAtom.FORM.equals(xObject.getType())) {
                FileSpecificationKeysHelper.parseResources(((PDXForm)xObject).getResources());
            } else if (ASAtom.FORM.equals(xObject.getType())) {
                PDXImage image = (PDXImage)xObject;
                FileSpecificationKeysHelper.processXObject(image.getMask());
                FileSpecificationKeysHelper.processXObject(image.getMask());
                for (PDXImage obj : image.getAlternates()) {
                    FileSpecificationKeysHelper.processXObject(obj);
                }
            }
        }
    }

    private static List<PDAppearanceStream> getAllAppearances(PDAnnotation annotation) {
        ArrayList<PDAppearanceStream> res = new ArrayList<PDAppearanceStream>();
        if (annotation != null) {
            FileSpecificationKeysHelper.addAllAppearances(annotation.getNormalAppearance(), res);
            FileSpecificationKeysHelper.addAllAppearances(annotation.getDownAppearance(), res);
            FileSpecificationKeysHelper.addAllAppearances(annotation.getRolloverAppearance(), res);
        }
        return res;
    }

    private static void addAllAppearances(PDAppearanceEntry appearance, List<PDAppearanceStream> list) {
        if (appearance == null) {
            return;
        }
        if (appearance.isSubDictionary()) {
            for (PDAppearanceStream appearanceStream : appearance.getSubDictionary().values()) {
                if (appearanceStream == null) continue;
                list.add(appearanceStream);
            }
        } else {
            PDAppearanceStream appearanceStream = appearance.getAppearanceStream();
            if (appearanceStream != null) {
                list.add(appearanceStream);
            }
        }
    }

    private static void registerDictionaryAFKeys(COSObject dictionary) {
        if (dictionary == null || !dictionary.getType().isDictionaryBased()) {
            return;
        }
        COSObject af = dictionary.getKey(ASAtom.AF);
        if (af != null && af.getType() == COSObjType.COS_ARRAY) {
            FileSpecificationKeysHelper.registerFileSpecificationKeys((COSArray)af.getDirectBase());
        }
    }

    private static void processExtGState(PDExtGState extGState) {
        if (extGState != null && !FileSpecificationKeysHelper.isKeyVisited(extGState.getObject().getKey())) {
            FileSpecificationKeysHelper.processFont(extGState.getFont());
        }
    }

    private static void processFont(PDFont font) {
        if (font != null && !FileSpecificationKeysHelper.isKeyVisited(font.getObject().getKey()) && ASAtom.TYPE3.equals(font.getSubtype())) {
            FileSpecificationKeysHelper.parseResources(((PDType3Font)font).getResources());
        }
    }

    private static void processPattern(PDPattern pattern) {
        if (pattern != null && !FileSpecificationKeysHelper.isKeyVisited(pattern.getObject().getKey())) {
            if (pattern.getPatternType() == 1) {
                FileSpecificationKeysHelper.parseResources(((PDTilingPattern)pattern).getResources());
            } else if (pattern.getPatternType() == 2) {
                FileSpecificationKeysHelper.processExtGState(((PDShadingPattern)pattern).getExtGState());
            }
        }
    }

    private static void parseResources(PDResources resources) {
        if (resources != null) {
            FileSpecificationKeysHelper.parseResourcesXObjects(resources);
            FileSpecificationKeysHelper.parseResourcesExtGState(resources);
            FileSpecificationKeysHelper.parseResourcesPatterns(resources);
            FileSpecificationKeysHelper.parseResourcesFonts(resources);
        }
    }

    private static void parseResourcesPatterns(PDResources resources) {
        for (ASAtom name : resources.getPatternNames()) {
            PDPattern pattern = resources.getPattern(name);
            FileSpecificationKeysHelper.processPattern(pattern);
        }
    }

    private static void parseResourcesExtGState(PDResources resources) {
        for (ASAtom name : resources.getExtGStateNames()) {
            PDExtGState extGState = resources.getExtGState(name);
            FileSpecificationKeysHelper.processExtGState(extGState);
        }
    }

    private static void parseResourcesXObjects(PDResources resources) {
        for (ASAtom name : resources.getXObjectNames()) {
            PDXObject xObject = resources.getXObject(name);
            FileSpecificationKeysHelper.processXObject(xObject);
        }
    }

    private static void parseResourcesFonts(PDResources resources) {
        for (ASAtom name : resources.getFontNames()) {
            PDFont font = resources.getFont(name);
            FileSpecificationKeysHelper.processFont(font);
        }
    }

    private static void addElementKey(COSObject element) {
        COSKey key;
        COSBase directBase;
        if (element != null && (directBase = element.getDirectBase()) != null && (key = directBase.getObjectKey()) != null) {
            StaticContainers.fileSpecificationKeys.add(key);
        }
    }

    private static boolean isKeyVisited(COSKey key) {
        if (visitedKeys.contains(key)) {
            return true;
        }
        visitedKeys.add(key);
        return false;
    }
}

