/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObject;
import org.verapdf.parser.BaseParser;
import org.verapdf.parser.Token;
import org.verapdf.pd.font.cmap.CIDInterval;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CodeSpace;
import org.verapdf.pd.font.cmap.NotDefInterval;
import org.verapdf.pd.font.cmap.PDCMap;
import org.verapdf.pd.font.cmap.SingleCIDMapping;
import org.verapdf.pd.font.cmap.ToUnicodeInterval;

public class CMapParser
extends BaseParser {
    private static final Logger LOGGER = Logger.getLogger(CMapParser.class.getCanonicalName());
    private COSObject lastCOSName;
    private CMap cMap = new CMap();

    public CMapParser(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public CMapParser(InputStream fileStream) throws IOException {
        super(fileStream);
    }

    public CMap getCMap() {
        return this.cMap;
    }

    public void parse() throws IOException {
        try {
            this.initializeToken();
            this.skipSpaces(true);
            while (this.getToken().type != Token.Type.TT_EOF) {
                this.nextToken();
                this.processToken();
            }
        }
        finally {
            this.source.close();
        }
    }

    private void processToken() throws IOException {
        block0 : switch (this.getToken().type) {
            case TT_NAME: {
                switch (this.getToken().getValue()) {
                    case "WMode": {
                        this.skipSpaces();
                        this.readNumber();
                        this.cMap.setwMode((int)this.getToken().integer);
                        break block0;
                    }
                    case "Registry": {
                        this.nextToken();
                        if (this.getToken().type.equals((Object)Token.Type.TT_LITSTRING)) {
                            this.cMap.setRegistry(this.getToken().getValue());
                            break block0;
                        }
                        throw new IOException("CMap contains invalid /Registry value");
                    }
                    case "Ordering": {
                        this.nextToken();
                        if (this.getToken().type.equals((Object)Token.Type.TT_LITSTRING)) {
                            this.cMap.setOrdering(this.getToken().getValue());
                            break block0;
                        }
                        throw new IOException("CMap contains invalid /Ordering value");
                    }
                    case "CMapName": {
                        this.nextToken();
                        if (this.getToken().type.equals((Object)Token.Type.TT_NAME)) {
                            this.cMap.setName(this.getToken().getValue());
                            break block0;
                        }
                        throw new IOException("CMap contains invalid /CMapName value");
                    }
                    case "Supplement": {
                        this.nextToken();
                        if (this.getToken().type == Token.Type.TT_INTEGER) {
                            this.cMap.setSupplement((int)this.getToken().integer);
                            break block0;
                        }
                        throw new IOException("CMap contains invalid /Supplement value");
                    }
                    case "CIDCount": {
                        this.nextToken();
                        this.checkTokenType(Token.Type.TT_INTEGER, "CIDCount");
                        this.nextToken();
                        this.checkTokenType(Token.Type.TT_KEYWORD, "CIDCount");
                        break block0;
                    }
                }
                this.lastCOSName = COSName.construct(this.getToken().getValue());
                break;
            }
            case TT_INTEGER: {
                int listLength = (int)this.getToken().integer;
                this.nextToken();
                if (this.getToken().type != Token.Type.TT_KEYWORD) break;
                this.processList(listLength, this.getToken().getValue());
                break;
            }
            case TT_KEYWORD: {
                switch (this.getToken().getValue()) {
                    case "usecmap": {
                        CMap usedCMap = new PDCMap(this.lastCOSName).getCMapFile();
                        if (usedCMap != null) {
                            this.cMap.useCMap(usedCMap);
                            break block0;
                        }
                        LOGGER.log(Level.FINE, "Can't load predefined CMap with name " + this.lastCOSName);
                        break block0;
                    }
                }
            }
        }
    }

    private void processList(int listLength, String type) throws IOException {
        if (!type.startsWith("begin")) {
            return;
        }
        String key = type.substring(5);
        block18: for (int i = 0; i < listLength; ++i) {
            switch (key) {
                case "codespacerange": {
                    this.readLineCodeSpaceRange();
                    continue block18;
                }
                case "cidrange": {
                    this.readLineCIDRange();
                    continue block18;
                }
                case "notdefrange": {
                    this.readLineNotDefRange();
                    continue block18;
                }
                case "cidchar": {
                    this.readSingleCharMapping();
                    continue block18;
                }
                case "notdefchar": {
                    this.readSingleNotDefMapping();
                    continue block18;
                }
                case "bfchar": {
                    this.readSingleToUnicodeMapping();
                    continue block18;
                }
                case "bfrange": {
                    this.readLineBFRange();
                    continue block18;
                }
            }
        }
        this.nextToken();
        if (!this.getToken().getValue().equals("end" + key)) {
            LOGGER.log(Level.FINE, "Unexpected end of " + key + " in CMap");
        }
    }

    private void readLineCodeSpaceRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "codespacerange list");
        byte[] begin = this.getToken().getByteValue();
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "codespacerange list");
        byte[] end = this.getToken().getByteValue();
        CodeSpace codeSpace = new CodeSpace(begin, end);
        boolean overlaps = false;
        for (CodeSpace cs : this.cMap.getCodeSpaces()) {
            if (!cs.overlaps(codeSpace)) continue;
            overlaps = true;
            break;
        }
        if (!overlaps) {
            this.cMap.getCodeSpaces().add(codeSpace);
            if (begin.length < this.cMap.shortestCodeSpaceLength) {
                this.cMap.shortestCodeSpaceLength = begin.length;
            }
        } else {
            LOGGER.log(Level.FINE, "CMap " + this.cMap.getName() + " has overlapping codespace ranges.");
        }
    }

    private void readLineCIDRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidrange list");
        long cidRangeStart = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidrange list");
        long cidRangeEnd = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "cidrange list");
        this.cMap.addCidInterval(new CIDInterval((int)cidRangeStart, (int)cidRangeEnd, (int)this.getToken().integer));
    }

    private void readLineNotDefRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdef list");
        long notDefRangeStart = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdef list");
        long notDefRangeEnd = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "notdef list");
        this.cMap.addNotDefInterval(new NotDefInterval((int)notDefRangeStart, (int)notDefRangeEnd, (int)this.getToken().integer));
    }

    private void readSingleCharMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "cidchar");
        long charCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "cidchar");
        this.cMap.addSingleCidMapping(new SingleCIDMapping((int)charCode, (int)this.getToken().integer));
    }

    private void readSingleNotDefMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "notdefchar");
        long notDefCharCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        this.nextToken();
        this.checkTokenType(Token.Type.TT_INTEGER, "notdefchar");
        this.cMap.addSingleNotDefMapping(new SingleCIDMapping((int)notDefCharCode, (int)this.getToken().integer));
    }

    private void readSingleToUnicodeMapping() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfchar");
        long bfCharCode = CMapParser.numberFromBytes(this.getToken().getByteValue());
        String unicodeName = this.readStringFromUnicodeSequenceToken();
        this.cMap.addUnicodeMapping((int)bfCharCode, unicodeName);
    }

    private void readLineBFRange() throws IOException {
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfrange");
        byte[] rangeBegin = this.getToken().getByteValue();
        long bfRangeBegin = CMapParser.numberFromBytes(rangeBegin);
        this.nextToken();
        this.checkTokenType(Token.Type.TT_HEXSTRING, "bfrange");
        long bfRangeEnd = CMapParser.getBfrangeEndFromBytes(this.getToken().getByteValue(), rangeBegin);
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_OPENARRAY) {
            for (long i = bfRangeBegin; i <= bfRangeEnd; ++i) {
                this.cMap.addUnicodeMapping((int)i, this.readStringFromUnicodeSequenceToken());
            }
            this.nextToken();
        } else {
            this.cMap.addUnicodeInterval(new ToUnicodeInterval(bfRangeBegin, bfRangeEnd, CMapParser.numberFromBytes(this.getToken().getByteValue())));
        }
    }

    static long numberFromBytes(byte[] num) {
        long res = 0L;
        for (int i = 0; i < num.length; ++i) {
            res += (long)((num[i] & 0xFF) << (num.length - i - 1) * 8);
        }
        return res;
    }

    private static long getBfrangeEndFromBytes(byte[] endRange, byte[] beginRange) {
        long res = 0L;
        for (int i = 0; i < endRange.length; ++i) {
            if (i < endRange.length - 1) {
                byte endRangeByte = endRange[i];
                byte beginRangeByte = beginRange[i];
                if (endRangeByte != beginRangeByte) {
                    LOGGER.log(Level.FINE, "Incorrect bfrange in toUnicode CMap: bfrange contains more than 256 code.");
                }
                res += (long)((beginRangeByte & 0xFF) << (endRange.length - i - 1) * 8);
                continue;
            }
            res += (long)((endRange[i] & 0xFF) << (endRange.length - i - 1) * 8);
        }
        return res;
    }

    private String readStringFromUnicodeSequenceToken() throws IOException {
        this.nextToken();
        if (this.getToken().type == Token.Type.TT_NAME) {
            return this.getToken().getValue();
        }
        if (this.getToken().type == Token.Type.TT_HEXSTRING) {
            byte[] token = this.getToken().getByteValue();
            if (token.length == 1) {
                return new String(token, "ISO-8859-1");
            }
            return new String(token, "UTF-16BE");
        }
        throw new IOException("CMap contains invalid entry in bfchar. Expected " + (Object)((Object)Token.Type.TT_NAME) + " or " + (Object)((Object)Token.Type.TT_HEXSTRING) + " but got " + (Object)((Object)this.getToken().type));
    }

    private void checkTokenType(Token.Type type, String where) throws IOException {
        if (this.getToken().type != type) {
            throw new IOException("CMap contains invalid entry in " + where + ". Expected " + (Object)((Object)type) + " but got " + (Object)((Object)this.getToken().type));
        }
    }
}

