/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.operator.textshow;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.gf.model.impl.operator.markedcontent.MarkedContentHelper;
import org.verapdf.gf.model.tools.GFIDGenerator;
import org.verapdf.model.GenericModelObject;
import org.verapdf.model.operator.Glyph;
import org.verapdf.pd.font.Encoding;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFGlyph
extends GenericModelObject
implements Glyph {
    private static final Logger LOGGER = Logger.getLogger(GFGlyph.class.getCanonicalName());
    public static final String GLYPH_TYPE = "Glyph";
    private static final int UNICODE_PRIVATE_USE_AREA_BEGINNING = 57344;
    private static final int UNICODE_PRIVATE_USE_AREA_ENDING = 63743;
    private final String id;
    private Boolean glyphPresent;
    private Boolean widthsConsistent;
    private String name;
    private String toUnicode;
    private Long renderingMode;
    private GFOpMarkedContent markedContent;
    private StructureElementAccessObject structureElementAccessObject;

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        this(glyphPresent, widthsConsistent, font, glyphCode, GLYPH_TYPE, renderingMode, markedContent, structureElementAccessObject);
    }

    public GFGlyph(Boolean glyphPresent, Boolean widthsConsistent, PDFont font, int glyphCode, String type, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        super(type);
        this.glyphPresent = glyphPresent;
        this.widthsConsistent = widthsConsistent;
        this.renderingMode = renderingMode;
        this.markedContent = markedContent;
        this.structureElementAccessObject = structureElementAccessObject;
        if (font instanceof PDSimpleFont) {
            Encoding encoding = font.getEncodingMapping();
            this.name = encoding == null ? null : encoding.getName(glyphCode);
        } else if (font instanceof PDType0Font) {
            try {
                FontProgram pr = font.getFontProgram();
                if (pr == null) {
                    this.name = null;
                } else {
                    pr.parseFont();
                    this.name = glyphCode == 0 || !font.glyphIsPresent(glyphCode) ? ".notdef" : null;
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Can't convert code to glyph", e);
                this.name = null;
            }
        }
        this.toUnicode = font.toUnicode(glyphCode);
        this.getactualTextPresent();
        this.id = GFIDGenerator.generateID(font.getDictionary().hashCode(), font.getName(), glyphCode, renderingMode);
    }

    @Override
    public String getname() {
        return this.name;
    }

    @Override
    public Boolean getisWidthConsistent() {
        return this.widthsConsistent;
    }

    @Override
    public Boolean getisGlyphPresent() {
        return this.glyphPresent;
    }

    @Override
    public String gettoUnicode() {
        return this.toUnicode;
    }

    @Override
    public Long getrenderingMode() {
        return this.renderingMode;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public Boolean getunicodePUA() {
        for (int i = 0; i < this.toUnicode.length(); ++i) {
            char unicode = this.toUnicode.charAt(0);
            if (unicode < '\ue000' || unicode > '\uf8ff') continue;
            return true;
        }
        return false;
    }

    @Override
    public Boolean getactualTextPresent() {
        return MarkedContentHelper.containsActualText(this.markedContent, this.structureElementAccessObject);
    }
}

