/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSStream;
import org.verapdf.gf.model.factory.operators.GraphicState;
import org.verapdf.gf.model.impl.cos.GFCosDict;
import org.verapdf.gf.model.impl.cos.GFCosStream;
import org.verapdf.gf.model.impl.pd.GFPDContentStream;
import org.verapdf.gf.model.impl.pd.GFPDGroup;
import org.verapdf.gf.model.impl.pd.images.GFPDXObject;
import org.verapdf.gf.model.impl.pd.util.PDResourcesHandler;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.pdlayer.PDContentStream;
import org.verapdf.model.pdlayer.PDXForm;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.structure.StructureElementAccessObject;

public class GFPDXForm
extends GFPDXObject
implements PDXForm {
    public static final String X_FORM_TYPE = "PDXForm";
    public static final String GROUP = "Group";
    public static final String PS = "PS";
    public static final String REF = "Ref";
    public static final String CONTENT_STREAM = "contentStream";
    private List<PDContentStream> contentStreams = null;
    private List<org.verapdf.model.pdlayer.PDGroup> groups = null;
    private boolean groupContainsTransparency = false;
    private boolean contentStreamContainsTransparency = false;
    private final GraphicState inheritedGraphicState;

    public GFPDXForm(org.verapdf.pd.images.PDXForm simplePDObject, PDResourcesHandler resourcesHandler, GraphicState inheritedGraphicState) {
        super(simplePDObject, resourcesHandler.getExtendedResources(simplePDObject.getResources()), X_FORM_TYPE);
        this.inheritedGraphicState = inheritedGraphicState;
    }

    @Override
    public String getSubtype2() {
        ASAtom subtype2 = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getSubtype2();
        return subtype2 == null ? null : subtype2.getValue();
    }

    @Override
    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Group": {
                return this.getGroup();
            }
            case "PS": {
                return this.getPS();
            }
            case "Ref": {
                return this.getREF();
            }
            case "contentStream": {
                return this.getContentStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDGroup> getGroup() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        return this.groups;
    }

    private List<CosStream> getPS() {
        COSStream ps = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getPS();
        if (ps != null) {
            ArrayList<GFCosStream> postScript = new ArrayList<GFCosStream>(1);
            postScript.add(new GFCosStream(ps));
            return Collections.unmodifiableList(postScript);
        }
        return Collections.emptyList();
    }

    private List<CosDict> getREF() {
        COSDictionary ref = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getRef();
        if (ref != null) {
            ArrayList<GFCosDict> postScript = new ArrayList<GFCosDict>(1);
            postScript.add(new GFCosDict(ref));
            return Collections.unmodifiableList(postScript);
        }
        return Collections.emptyList();
    }

    private List<PDContentStream> getContentStream() {
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.contentStreams;
    }

    private void initializeGroups() {
        PDGroup group = ((org.verapdf.pd.images.PDXForm)this.simplePDObject).getGroup();
        if (group != null) {
            this.groupContainsTransparency = ASAtom.TRANSPARENCY.equals(group.getSubtype());
            ArrayList<GFPDGroup> groups = new ArrayList<GFPDGroup>(1);
            groups.add(new GFPDGroup(group));
            this.groups = Collections.unmodifiableList(groups);
        } else {
            this.groups = Collections.emptyList();
        }
    }

    private void parseContentStream() {
        ArrayList<PDContentStream> streams = new ArrayList<PDContentStream>(1);
        GFPDContentStream gfContentStream = new GFPDContentStream((org.verapdf.pd.images.PDXForm)this.simplePDObject, this.resourcesHandler, this.inheritedGraphicState, new StructureElementAccessObject(this.simpleCOSObject));
        this.contentStreamContainsTransparency = gfContentStream.isContainsTransparency();
        streams.add(gfContentStream);
        this.contentStreams = streams;
    }

    public boolean containsTransparency() {
        if (this.groups == null) {
            this.initializeGroups();
        }
        if (this.contentStreams == null) {
            this.parseContentStream();
        }
        return this.groupContainsTransparency || this.contentStreamContainsTransparency;
    }
}

