/**
 * This file is part of VERA PDF UI, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VERA PDF UI is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VERA PDF UI as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VERA PDF UI as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.ui.contentassist.antlr.internal; 

import java.io.InputStream;
import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.AbstractInternalContentAssistParser;
import org.eclipse.xtext.ui.editor.contentassist.antlr.internal.DFA;
import org.verapdf.services.ModelGrammarAccess;



import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

@SuppressWarnings("all")
public class InternalModelParser extends AbstractInternalContentAssistParser {
    public static final String[] tokenNames = new String[] {
        "<invalid>", "<EOR>", "<DOWN>", "<UP>", "RULE_ID", "RULE_COMMENT", "RULE_INT", "RULE_STRING", "RULE_ML_COMMENT", "RULE_SL_COMMENT", "RULE_WS", "RULE_ANY_OTHER", "'String'", "'Integer'", "'Decimal'", "'Boolean'", "'package'", "';'", "'type'", "'{'", "'}'", "'extends'", "'property'", "':'", "'link'", "'import'", "'.'", "'.*'", "'*'", "'+'", "'?'"
    };
    public static final int RULE_STRING=7;
    public static final int RULE_SL_COMMENT=9;
    public static final int T__19=19;
    public static final int T__15=15;
    public static final int T__16=16;
    public static final int T__17=17;
    public static final int T__18=18;
    public static final int T__12=12;
    public static final int T__13=13;
    public static final int T__14=14;
    public static final int EOF=-1;
    public static final int T__30=30;
    public static final int RULE_ID=4;
    public static final int RULE_WS=10;
    public static final int RULE_COMMENT=5;
    public static final int RULE_ANY_OTHER=11;
    public static final int T__26=26;
    public static final int T__27=27;
    public static final int T__28=28;
    public static final int RULE_INT=6;
    public static final int T__29=29;
    public static final int T__22=22;
    public static final int RULE_ML_COMMENT=8;
    public static final int T__23=23;
    public static final int T__24=24;
    public static final int T__25=25;
    public static final int T__20=20;
    public static final int T__21=21;

    // delegates
    // delegators


        public InternalModelParser(TokenStream input) {
            this(input, new RecognizerSharedState());
        }
        public InternalModelParser(TokenStream input, RecognizerSharedState state) {
            super(input, state);
             
        }
        

    public String[] getTokenNames() { return InternalModelParser.tokenNames; }
    public String getGrammarFileName() { return "//var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g"; }


     
     	private ModelGrammarAccess grammarAccess;
     	
        public void setGrammarAccess(ModelGrammarAccess grammarAccess) {
        	this.grammarAccess = grammarAccess;
        }
        
        @Override
        protected Grammar getGrammar() {
        	return grammarAccess.getGrammar();
        }
        
        @Override
        protected String getValueForTokenName(String tokenName) {
        	return tokenName;
        }




    // $ANTLR start "entryRuleModel"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:60:1: entryRuleModel : ruleModel EOF ;
    public final void entryRuleModel() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:61:1: ( ruleModel EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:62:1: ruleModel EOF
            {
             before(grammarAccess.getModelRule()); 
            pushFollow(FOLLOW_ruleModel_in_entryRuleModel61);
            ruleModel();

            state._fsp--;

             after(grammarAccess.getModelRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleModel68); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleModel"


    // $ANTLR start "ruleModel"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:69:1: ruleModel : ( ( rule__Model__Group__0 ) ) ;
    public final void ruleModel() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:73:2: ( ( ( rule__Model__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:74:1: ( ( rule__Model__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:74:1: ( ( rule__Model__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:75:1: ( rule__Model__Group__0 )
            {
             before(grammarAccess.getModelAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:76:1: ( rule__Model__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:76:2: rule__Model__Group__0
            {
            pushFollow(FOLLOW_rule__Model__Group__0_in_ruleModel94);
            rule__Model__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getModelAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleModel"


    // $ANTLR start "entryRuleEntity"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:88:1: entryRuleEntity : ruleEntity EOF ;
    public final void entryRuleEntity() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:89:1: ( ruleEntity EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:90:1: ruleEntity EOF
            {
             before(grammarAccess.getEntityRule()); 
            pushFollow(FOLLOW_ruleEntity_in_entryRuleEntity121);
            ruleEntity();

            state._fsp--;

             after(grammarAccess.getEntityRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleEntity128); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleEntity"


    // $ANTLR start "ruleEntity"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:97:1: ruleEntity : ( ( rule__Entity__Group__0 ) ) ;
    public final void ruleEntity() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:101:2: ( ( ( rule__Entity__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:102:1: ( ( rule__Entity__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:102:1: ( ( rule__Entity__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:103:1: ( rule__Entity__Group__0 )
            {
             before(grammarAccess.getEntityAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:104:1: ( rule__Entity__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:104:2: rule__Entity__Group__0
            {
            pushFollow(FOLLOW_rule__Entity__Group__0_in_ruleEntity154);
            rule__Entity__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleEntity"


    // $ANTLR start "entryRuleAttribute"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:116:1: entryRuleAttribute : ruleAttribute EOF ;
    public final void entryRuleAttribute() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:117:1: ( ruleAttribute EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:118:1: ruleAttribute EOF
            {
             before(grammarAccess.getAttributeRule()); 
            pushFollow(FOLLOW_ruleAttribute_in_entryRuleAttribute181);
            ruleAttribute();

            state._fsp--;

             after(grammarAccess.getAttributeRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleAttribute188); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleAttribute"


    // $ANTLR start "ruleAttribute"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:125:1: ruleAttribute : ( ( rule__Attribute__Alternatives ) ) ;
    public final void ruleAttribute() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:129:2: ( ( ( rule__Attribute__Alternatives ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:130:1: ( ( rule__Attribute__Alternatives ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:130:1: ( ( rule__Attribute__Alternatives ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:131:1: ( rule__Attribute__Alternatives )
            {
             before(grammarAccess.getAttributeAccess().getAlternatives()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:132:1: ( rule__Attribute__Alternatives )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:132:2: rule__Attribute__Alternatives
            {
            pushFollow(FOLLOW_rule__Attribute__Alternatives_in_ruleAttribute214);
            rule__Attribute__Alternatives();

            state._fsp--;


            }

             after(grammarAccess.getAttributeAccess().getAlternatives()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleAttribute"


    // $ANTLR start "entryRuleProperty"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:144:1: entryRuleProperty : ruleProperty EOF ;
    public final void entryRuleProperty() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:145:1: ( ruleProperty EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:146:1: ruleProperty EOF
            {
             before(grammarAccess.getPropertyRule()); 
            pushFollow(FOLLOW_ruleProperty_in_entryRuleProperty241);
            ruleProperty();

            state._fsp--;

             after(grammarAccess.getPropertyRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleProperty248); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleProperty"


    // $ANTLR start "ruleProperty"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:153:1: ruleProperty : ( ( rule__Property__Group__0 ) ) ;
    public final void ruleProperty() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:157:2: ( ( ( rule__Property__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:158:1: ( ( rule__Property__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:158:1: ( ( rule__Property__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:159:1: ( rule__Property__Group__0 )
            {
             before(grammarAccess.getPropertyAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:160:1: ( rule__Property__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:160:2: rule__Property__Group__0
            {
            pushFollow(FOLLOW_rule__Property__Group__0_in_ruleProperty274);
            rule__Property__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleProperty"


    // $ANTLR start "entryRuleLink"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:172:1: entryRuleLink : ruleLink EOF ;
    public final void entryRuleLink() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:173:1: ( ruleLink EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:174:1: ruleLink EOF
            {
             before(grammarAccess.getLinkRule()); 
            pushFollow(FOLLOW_ruleLink_in_entryRuleLink301);
            ruleLink();

            state._fsp--;

             after(grammarAccess.getLinkRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleLink308); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleLink"


    // $ANTLR start "ruleLink"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:181:1: ruleLink : ( ( rule__Link__Group__0 ) ) ;
    public final void ruleLink() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:185:2: ( ( ( rule__Link__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:186:1: ( ( rule__Link__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:186:1: ( ( rule__Link__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:187:1: ( rule__Link__Group__0 )
            {
             before(grammarAccess.getLinkAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:188:1: ( rule__Link__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:188:2: rule__Link__Group__0
            {
            pushFollow(FOLLOW_rule__Link__Group__0_in_ruleLink334);
            rule__Link__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleLink"


    // $ANTLR start "entryRuleImport"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:200:1: entryRuleImport : ruleImport EOF ;
    public final void entryRuleImport() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:201:1: ( ruleImport EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:202:1: ruleImport EOF
            {
             before(grammarAccess.getImportRule()); 
            pushFollow(FOLLOW_ruleImport_in_entryRuleImport361);
            ruleImport();

            state._fsp--;

             after(grammarAccess.getImportRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleImport368); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleImport"


    // $ANTLR start "ruleImport"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:209:1: ruleImport : ( ( rule__Import__Group__0 ) ) ;
    public final void ruleImport() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:213:2: ( ( ( rule__Import__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:214:1: ( ( rule__Import__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:214:1: ( ( rule__Import__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:215:1: ( rule__Import__Group__0 )
            {
             before(grammarAccess.getImportAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:216:1: ( rule__Import__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:216:2: rule__Import__Group__0
            {
            pushFollow(FOLLOW_rule__Import__Group__0_in_ruleImport394);
            rule__Import__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getImportAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleImport"


    // $ANTLR start "entryRuleQualifiedName"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:228:1: entryRuleQualifiedName : ruleQualifiedName EOF ;
    public final void entryRuleQualifiedName() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:229:1: ( ruleQualifiedName EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:230:1: ruleQualifiedName EOF
            {
             before(grammarAccess.getQualifiedNameRule()); 
            pushFollow(FOLLOW_ruleQualifiedName_in_entryRuleQualifiedName421);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getQualifiedNameRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleQualifiedName428); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleQualifiedName"


    // $ANTLR start "ruleQualifiedName"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:237:1: ruleQualifiedName : ( ( rule__QualifiedName__Group__0 ) ) ;
    public final void ruleQualifiedName() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:241:2: ( ( ( rule__QualifiedName__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:242:1: ( ( rule__QualifiedName__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:242:1: ( ( rule__QualifiedName__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:243:1: ( rule__QualifiedName__Group__0 )
            {
             before(grammarAccess.getQualifiedNameAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:244:1: ( rule__QualifiedName__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:244:2: rule__QualifiedName__Group__0
            {
            pushFollow(FOLLOW_rule__QualifiedName__Group__0_in_ruleQualifiedName454);
            rule__QualifiedName__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getQualifiedNameAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleQualifiedName"


    // $ANTLR start "entryRuleQualifiedNameWithWildcard"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:256:1: entryRuleQualifiedNameWithWildcard : ruleQualifiedNameWithWildcard EOF ;
    public final void entryRuleQualifiedNameWithWildcard() throws RecognitionException {
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:257:1: ( ruleQualifiedNameWithWildcard EOF )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:258:1: ruleQualifiedNameWithWildcard EOF
            {
             before(grammarAccess.getQualifiedNameWithWildcardRule()); 
            pushFollow(FOLLOW_ruleQualifiedNameWithWildcard_in_entryRuleQualifiedNameWithWildcard481);
            ruleQualifiedNameWithWildcard();

            state._fsp--;

             after(grammarAccess.getQualifiedNameWithWildcardRule()); 
            match(input,EOF,FOLLOW_EOF_in_entryRuleQualifiedNameWithWildcard488); 

            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {
        }
        return ;
    }
    // $ANTLR end "entryRuleQualifiedNameWithWildcard"


    // $ANTLR start "ruleQualifiedNameWithWildcard"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:265:1: ruleQualifiedNameWithWildcard : ( ( rule__QualifiedNameWithWildcard__Group__0 ) ) ;
    public final void ruleQualifiedNameWithWildcard() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:269:2: ( ( ( rule__QualifiedNameWithWildcard__Group__0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:270:1: ( ( rule__QualifiedNameWithWildcard__Group__0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:270:1: ( ( rule__QualifiedNameWithWildcard__Group__0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:271:1: ( rule__QualifiedNameWithWildcard__Group__0 )
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getGroup()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:272:1: ( rule__QualifiedNameWithWildcard__Group__0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:272:2: rule__QualifiedNameWithWildcard__Group__0
            {
            pushFollow(FOLLOW_rule__QualifiedNameWithWildcard__Group__0_in_ruleQualifiedNameWithWildcard514);
            rule__QualifiedNameWithWildcard__Group__0();

            state._fsp--;


            }

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getGroup()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "ruleQualifiedNameWithWildcard"


    // $ANTLR start "rule__Attribute__Alternatives"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:284:1: rule__Attribute__Alternatives : ( ( ruleProperty ) | ( ruleLink ) );
    public final void rule__Attribute__Alternatives() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:288:1: ( ( ruleProperty ) | ( ruleLink ) )
            int alt1=2;
            alt1 = dfa1.predict(input);
            switch (alt1) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:289:1: ( ruleProperty )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:289:1: ( ruleProperty )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:290:1: ruleProperty
                    {
                     before(grammarAccess.getAttributeAccess().getPropertyParserRuleCall_0()); 
                    pushFollow(FOLLOW_ruleProperty_in_rule__Attribute__Alternatives550);
                    ruleProperty();

                    state._fsp--;

                     after(grammarAccess.getAttributeAccess().getPropertyParserRuleCall_0()); 

                    }


                    }
                    break;
                case 2 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:295:6: ( ruleLink )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:295:6: ( ruleLink )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:296:1: ruleLink
                    {
                     before(grammarAccess.getAttributeAccess().getLinkParserRuleCall_1()); 
                    pushFollow(FOLLOW_ruleLink_in_rule__Attribute__Alternatives567);
                    ruleLink();

                    state._fsp--;

                     after(grammarAccess.getAttributeAccess().getLinkParserRuleCall_1()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Attribute__Alternatives"


    // $ANTLR start "rule__Property__TypeAlternatives_4_0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:306:1: rule__Property__TypeAlternatives_4_0 : ( ( 'String' ) | ( 'Integer' ) | ( 'Decimal' ) | ( 'Boolean' ) );
    public final void rule__Property__TypeAlternatives_4_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:310:1: ( ( 'String' ) | ( 'Integer' ) | ( 'Decimal' ) | ( 'Boolean' ) )
            int alt2=4;
            switch ( input.LA(1) ) {
            case 12:
                {
                alt2=1;
                }
                break;
            case 13:
                {
                alt2=2;
                }
                break;
            case 14:
                {
                alt2=3;
                }
                break;
            case 15:
                {
                alt2=4;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 2, 0, input);

                throw nvae;
            }

            switch (alt2) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:311:1: ( 'String' )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:311:1: ( 'String' )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:312:1: 'String'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeStringKeyword_4_0_0()); 
                    match(input,12,FOLLOW_12_in_rule__Property__TypeAlternatives_4_0600); 
                     after(grammarAccess.getPropertyAccess().getTypeStringKeyword_4_0_0()); 

                    }


                    }
                    break;
                case 2 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:319:6: ( 'Integer' )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:319:6: ( 'Integer' )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:320:1: 'Integer'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeIntegerKeyword_4_0_1()); 
                    match(input,13,FOLLOW_13_in_rule__Property__TypeAlternatives_4_0620); 
                     after(grammarAccess.getPropertyAccess().getTypeIntegerKeyword_4_0_1()); 

                    }


                    }
                    break;
                case 3 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:327:6: ( 'Decimal' )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:327:6: ( 'Decimal' )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:328:1: 'Decimal'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeDecimalKeyword_4_0_2()); 
                    match(input,14,FOLLOW_14_in_rule__Property__TypeAlternatives_4_0640); 
                     after(grammarAccess.getPropertyAccess().getTypeDecimalKeyword_4_0_2()); 

                    }


                    }
                    break;
                case 4 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:335:6: ( 'Boolean' )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:335:6: ( 'Boolean' )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:336:1: 'Boolean'
                    {
                     before(grammarAccess.getPropertyAccess().getTypeBooleanKeyword_4_0_3()); 
                    match(input,15,FOLLOW_15_in_rule__Property__TypeAlternatives_4_0660); 
                     after(grammarAccess.getPropertyAccess().getTypeBooleanKeyword_4_0_3()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__TypeAlternatives_4_0"


    // $ANTLR start "rule__Link__Alternatives_5"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:348:1: rule__Link__Alternatives_5 : ( ( ( rule__Link__AnyAssignment_5_0 ) ) | ( ( rule__Link__OneOrMoreAssignment_5_1 ) ) | ( ( rule__Link__ZeroOrOneAssignment_5_2 ) ) );
    public final void rule__Link__Alternatives_5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:352:1: ( ( ( rule__Link__AnyAssignment_5_0 ) ) | ( ( rule__Link__OneOrMoreAssignment_5_1 ) ) | ( ( rule__Link__ZeroOrOneAssignment_5_2 ) ) )
            int alt3=3;
            switch ( input.LA(1) ) {
            case 28:
                {
                alt3=1;
                }
                break;
            case 29:
                {
                alt3=2;
                }
                break;
            case 30:
                {
                alt3=3;
                }
                break;
            default:
                NoViableAltException nvae =
                    new NoViableAltException("", 3, 0, input);

                throw nvae;
            }

            switch (alt3) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:353:1: ( ( rule__Link__AnyAssignment_5_0 ) )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:353:1: ( ( rule__Link__AnyAssignment_5_0 ) )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:354:1: ( rule__Link__AnyAssignment_5_0 )
                    {
                     before(grammarAccess.getLinkAccess().getAnyAssignment_5_0()); 
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:355:1: ( rule__Link__AnyAssignment_5_0 )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:355:2: rule__Link__AnyAssignment_5_0
                    {
                    pushFollow(FOLLOW_rule__Link__AnyAssignment_5_0_in_rule__Link__Alternatives_5694);
                    rule__Link__AnyAssignment_5_0();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getAnyAssignment_5_0()); 

                    }


                    }
                    break;
                case 2 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:359:6: ( ( rule__Link__OneOrMoreAssignment_5_1 ) )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:359:6: ( ( rule__Link__OneOrMoreAssignment_5_1 ) )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:360:1: ( rule__Link__OneOrMoreAssignment_5_1 )
                    {
                     before(grammarAccess.getLinkAccess().getOneOrMoreAssignment_5_1()); 
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:361:1: ( rule__Link__OneOrMoreAssignment_5_1 )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:361:2: rule__Link__OneOrMoreAssignment_5_1
                    {
                    pushFollow(FOLLOW_rule__Link__OneOrMoreAssignment_5_1_in_rule__Link__Alternatives_5712);
                    rule__Link__OneOrMoreAssignment_5_1();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getOneOrMoreAssignment_5_1()); 

                    }


                    }
                    break;
                case 3 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:365:6: ( ( rule__Link__ZeroOrOneAssignment_5_2 ) )
                    {
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:365:6: ( ( rule__Link__ZeroOrOneAssignment_5_2 ) )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:366:1: ( rule__Link__ZeroOrOneAssignment_5_2 )
                    {
                     before(grammarAccess.getLinkAccess().getZeroOrOneAssignment_5_2()); 
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:367:1: ( rule__Link__ZeroOrOneAssignment_5_2 )
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:367:2: rule__Link__ZeroOrOneAssignment_5_2
                    {
                    pushFollow(FOLLOW_rule__Link__ZeroOrOneAssignment_5_2_in_rule__Link__Alternatives_5730);
                    rule__Link__ZeroOrOneAssignment_5_2();

                    state._fsp--;


                    }

                     after(grammarAccess.getLinkAccess().getZeroOrOneAssignment_5_2()); 

                    }


                    }
                    break;

            }
        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Alternatives_5"


    // $ANTLR start "rule__Model__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:378:1: rule__Model__Group__0 : rule__Model__Group__0__Impl rule__Model__Group__1 ;
    public final void rule__Model__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:382:1: ( rule__Model__Group__0__Impl rule__Model__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:383:2: rule__Model__Group__0__Impl rule__Model__Group__1
            {
            pushFollow(FOLLOW_rule__Model__Group__0__Impl_in_rule__Model__Group__0761);
            rule__Model__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Model__Group__1_in_rule__Model__Group__0764);
            rule__Model__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__0"


    // $ANTLR start "rule__Model__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:390:1: rule__Model__Group__0__Impl : ( 'package' ) ;
    public final void rule__Model__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:394:1: ( ( 'package' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:395:1: ( 'package' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:395:1: ( 'package' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:396:1: 'package'
            {
             before(grammarAccess.getModelAccess().getPackageKeyword_0()); 
            match(input,16,FOLLOW_16_in_rule__Model__Group__0__Impl792); 
             after(grammarAccess.getModelAccess().getPackageKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__0__Impl"


    // $ANTLR start "rule__Model__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:409:1: rule__Model__Group__1 : rule__Model__Group__1__Impl rule__Model__Group__2 ;
    public final void rule__Model__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:413:1: ( rule__Model__Group__1__Impl rule__Model__Group__2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:414:2: rule__Model__Group__1__Impl rule__Model__Group__2
            {
            pushFollow(FOLLOW_rule__Model__Group__1__Impl_in_rule__Model__Group__1823);
            rule__Model__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Model__Group__2_in_rule__Model__Group__1826);
            rule__Model__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__1"


    // $ANTLR start "rule__Model__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:421:1: rule__Model__Group__1__Impl : ( ( rule__Model__NameAssignment_1 ) ) ;
    public final void rule__Model__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:425:1: ( ( ( rule__Model__NameAssignment_1 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:426:1: ( ( rule__Model__NameAssignment_1 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:426:1: ( ( rule__Model__NameAssignment_1 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:427:1: ( rule__Model__NameAssignment_1 )
            {
             before(grammarAccess.getModelAccess().getNameAssignment_1()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:428:1: ( rule__Model__NameAssignment_1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:428:2: rule__Model__NameAssignment_1
            {
            pushFollow(FOLLOW_rule__Model__NameAssignment_1_in_rule__Model__Group__1__Impl853);
            rule__Model__NameAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getModelAccess().getNameAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__1__Impl"


    // $ANTLR start "rule__Model__Group__2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:438:1: rule__Model__Group__2 : rule__Model__Group__2__Impl rule__Model__Group__3 ;
    public final void rule__Model__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:442:1: ( rule__Model__Group__2__Impl rule__Model__Group__3 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:443:2: rule__Model__Group__2__Impl rule__Model__Group__3
            {
            pushFollow(FOLLOW_rule__Model__Group__2__Impl_in_rule__Model__Group__2883);
            rule__Model__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Model__Group__3_in_rule__Model__Group__2886);
            rule__Model__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__2"


    // $ANTLR start "rule__Model__Group__2__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:450:1: rule__Model__Group__2__Impl : ( ';' ) ;
    public final void rule__Model__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:454:1: ( ( ';' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:455:1: ( ';' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:455:1: ( ';' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:456:1: ';'
            {
             before(grammarAccess.getModelAccess().getSemicolonKeyword_2()); 
            match(input,17,FOLLOW_17_in_rule__Model__Group__2__Impl914); 
             after(grammarAccess.getModelAccess().getSemicolonKeyword_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__2__Impl"


    // $ANTLR start "rule__Model__Group__3"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:469:1: rule__Model__Group__3 : rule__Model__Group__3__Impl rule__Model__Group__4 ;
    public final void rule__Model__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:473:1: ( rule__Model__Group__3__Impl rule__Model__Group__4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:474:2: rule__Model__Group__3__Impl rule__Model__Group__4
            {
            pushFollow(FOLLOW_rule__Model__Group__3__Impl_in_rule__Model__Group__3945);
            rule__Model__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Model__Group__4_in_rule__Model__Group__3948);
            rule__Model__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__3"


    // $ANTLR start "rule__Model__Group__3__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:481:1: rule__Model__Group__3__Impl : ( ( rule__Model__ImportsAssignment_3 )* ) ;
    public final void rule__Model__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:485:1: ( ( ( rule__Model__ImportsAssignment_3 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:486:1: ( ( rule__Model__ImportsAssignment_3 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:486:1: ( ( rule__Model__ImportsAssignment_3 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:487:1: ( rule__Model__ImportsAssignment_3 )*
            {
             before(grammarAccess.getModelAccess().getImportsAssignment_3()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:488:1: ( rule__Model__ImportsAssignment_3 )*
            loop4:
            do {
                int alt4=2;
                int LA4_0 = input.LA(1);

                if ( (LA4_0==25) ) {
                    alt4=1;
                }


                switch (alt4) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:488:2: rule__Model__ImportsAssignment_3
            	    {
            	    pushFollow(FOLLOW_rule__Model__ImportsAssignment_3_in_rule__Model__Group__3__Impl975);
            	    rule__Model__ImportsAssignment_3();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop4;
                }
            } while (true);

             after(grammarAccess.getModelAccess().getImportsAssignment_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__3__Impl"


    // $ANTLR start "rule__Model__Group__4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:498:1: rule__Model__Group__4 : rule__Model__Group__4__Impl ;
    public final void rule__Model__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:502:1: ( rule__Model__Group__4__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:503:2: rule__Model__Group__4__Impl
            {
            pushFollow(FOLLOW_rule__Model__Group__4__Impl_in_rule__Model__Group__41006);
            rule__Model__Group__4__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__4"


    // $ANTLR start "rule__Model__Group__4__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:509:1: rule__Model__Group__4__Impl : ( ( rule__Model__ElementsAssignment_4 )* ) ;
    public final void rule__Model__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:513:1: ( ( ( rule__Model__ElementsAssignment_4 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:514:1: ( ( rule__Model__ElementsAssignment_4 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:514:1: ( ( rule__Model__ElementsAssignment_4 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:515:1: ( rule__Model__ElementsAssignment_4 )*
            {
             before(grammarAccess.getModelAccess().getElementsAssignment_4()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:516:1: ( rule__Model__ElementsAssignment_4 )*
            loop5:
            do {
                int alt5=2;
                int LA5_0 = input.LA(1);

                if ( (LA5_0==RULE_COMMENT||LA5_0==18) ) {
                    alt5=1;
                }


                switch (alt5) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:516:2: rule__Model__ElementsAssignment_4
            	    {
            	    pushFollow(FOLLOW_rule__Model__ElementsAssignment_4_in_rule__Model__Group__4__Impl1033);
            	    rule__Model__ElementsAssignment_4();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop5;
                }
            } while (true);

             after(grammarAccess.getModelAccess().getElementsAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__Group__4__Impl"


    // $ANTLR start "rule__Entity__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:536:1: rule__Entity__Group__0 : rule__Entity__Group__0__Impl rule__Entity__Group__1 ;
    public final void rule__Entity__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:540:1: ( rule__Entity__Group__0__Impl rule__Entity__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:541:2: rule__Entity__Group__0__Impl rule__Entity__Group__1
            {
            pushFollow(FOLLOW_rule__Entity__Group__0__Impl_in_rule__Entity__Group__01074);
            rule__Entity__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__1_in_rule__Entity__Group__01077);
            rule__Entity__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__0"


    // $ANTLR start "rule__Entity__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:548:1: rule__Entity__Group__0__Impl : ( ( rule__Entity__CommentAssignment_0 )* ) ;
    public final void rule__Entity__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:552:1: ( ( ( rule__Entity__CommentAssignment_0 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:553:1: ( ( rule__Entity__CommentAssignment_0 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:553:1: ( ( rule__Entity__CommentAssignment_0 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:554:1: ( rule__Entity__CommentAssignment_0 )*
            {
             before(grammarAccess.getEntityAccess().getCommentAssignment_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:555:1: ( rule__Entity__CommentAssignment_0 )*
            loop6:
            do {
                int alt6=2;
                int LA6_0 = input.LA(1);

                if ( (LA6_0==RULE_COMMENT) ) {
                    alt6=1;
                }


                switch (alt6) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:555:2: rule__Entity__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_rule__Entity__CommentAssignment_0_in_rule__Entity__Group__0__Impl1104);
            	    rule__Entity__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop6;
                }
            } while (true);

             after(grammarAccess.getEntityAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__0__Impl"


    // $ANTLR start "rule__Entity__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:565:1: rule__Entity__Group__1 : rule__Entity__Group__1__Impl rule__Entity__Group__2 ;
    public final void rule__Entity__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:569:1: ( rule__Entity__Group__1__Impl rule__Entity__Group__2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:570:2: rule__Entity__Group__1__Impl rule__Entity__Group__2
            {
            pushFollow(FOLLOW_rule__Entity__Group__1__Impl_in_rule__Entity__Group__11135);
            rule__Entity__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__2_in_rule__Entity__Group__11138);
            rule__Entity__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__1"


    // $ANTLR start "rule__Entity__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:577:1: rule__Entity__Group__1__Impl : ( 'type' ) ;
    public final void rule__Entity__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:581:1: ( ( 'type' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:582:1: ( 'type' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:582:1: ( 'type' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:583:1: 'type'
            {
             before(grammarAccess.getEntityAccess().getTypeKeyword_1()); 
            match(input,18,FOLLOW_18_in_rule__Entity__Group__1__Impl1166); 
             after(grammarAccess.getEntityAccess().getTypeKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__1__Impl"


    // $ANTLR start "rule__Entity__Group__2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:596:1: rule__Entity__Group__2 : rule__Entity__Group__2__Impl rule__Entity__Group__3 ;
    public final void rule__Entity__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:600:1: ( rule__Entity__Group__2__Impl rule__Entity__Group__3 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:601:2: rule__Entity__Group__2__Impl rule__Entity__Group__3
            {
            pushFollow(FOLLOW_rule__Entity__Group__2__Impl_in_rule__Entity__Group__21197);
            rule__Entity__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__3_in_rule__Entity__Group__21200);
            rule__Entity__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__2"


    // $ANTLR start "rule__Entity__Group__2__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:608:1: rule__Entity__Group__2__Impl : ( ( rule__Entity__NameAssignment_2 ) ) ;
    public final void rule__Entity__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:612:1: ( ( ( rule__Entity__NameAssignment_2 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:613:1: ( ( rule__Entity__NameAssignment_2 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:613:1: ( ( rule__Entity__NameAssignment_2 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:614:1: ( rule__Entity__NameAssignment_2 )
            {
             before(grammarAccess.getEntityAccess().getNameAssignment_2()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:615:1: ( rule__Entity__NameAssignment_2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:615:2: rule__Entity__NameAssignment_2
            {
            pushFollow(FOLLOW_rule__Entity__NameAssignment_2_in_rule__Entity__Group__2__Impl1227);
            rule__Entity__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__2__Impl"


    // $ANTLR start "rule__Entity__Group__3"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:625:1: rule__Entity__Group__3 : rule__Entity__Group__3__Impl rule__Entity__Group__4 ;
    public final void rule__Entity__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:629:1: ( rule__Entity__Group__3__Impl rule__Entity__Group__4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:630:2: rule__Entity__Group__3__Impl rule__Entity__Group__4
            {
            pushFollow(FOLLOW_rule__Entity__Group__3__Impl_in_rule__Entity__Group__31257);
            rule__Entity__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__4_in_rule__Entity__Group__31260);
            rule__Entity__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__3"


    // $ANTLR start "rule__Entity__Group__3__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:637:1: rule__Entity__Group__3__Impl : ( ( rule__Entity__Group_3__0 )? ) ;
    public final void rule__Entity__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:641:1: ( ( ( rule__Entity__Group_3__0 )? ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:642:1: ( ( rule__Entity__Group_3__0 )? )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:642:1: ( ( rule__Entity__Group_3__0 )? )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:643:1: ( rule__Entity__Group_3__0 )?
            {
             before(grammarAccess.getEntityAccess().getGroup_3()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:644:1: ( rule__Entity__Group_3__0 )?
            int alt7=2;
            int LA7_0 = input.LA(1);

            if ( (LA7_0==21) ) {
                alt7=1;
            }
            switch (alt7) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:644:2: rule__Entity__Group_3__0
                    {
                    pushFollow(FOLLOW_rule__Entity__Group_3__0_in_rule__Entity__Group__3__Impl1287);
                    rule__Entity__Group_3__0();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getEntityAccess().getGroup_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__3__Impl"


    // $ANTLR start "rule__Entity__Group__4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:654:1: rule__Entity__Group__4 : rule__Entity__Group__4__Impl rule__Entity__Group__5 ;
    public final void rule__Entity__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:658:1: ( rule__Entity__Group__4__Impl rule__Entity__Group__5 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:659:2: rule__Entity__Group__4__Impl rule__Entity__Group__5
            {
            pushFollow(FOLLOW_rule__Entity__Group__4__Impl_in_rule__Entity__Group__41318);
            rule__Entity__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__5_in_rule__Entity__Group__41321);
            rule__Entity__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__4"


    // $ANTLR start "rule__Entity__Group__4__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:666:1: rule__Entity__Group__4__Impl : ( '{' ) ;
    public final void rule__Entity__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:670:1: ( ( '{' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:671:1: ( '{' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:671:1: ( '{' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:672:1: '{'
            {
             before(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_4()); 
            match(input,19,FOLLOW_19_in_rule__Entity__Group__4__Impl1349); 
             after(grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__4__Impl"


    // $ANTLR start "rule__Entity__Group__5"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:685:1: rule__Entity__Group__5 : rule__Entity__Group__5__Impl rule__Entity__Group__6 ;
    public final void rule__Entity__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:689:1: ( rule__Entity__Group__5__Impl rule__Entity__Group__6 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:690:2: rule__Entity__Group__5__Impl rule__Entity__Group__6
            {
            pushFollow(FOLLOW_rule__Entity__Group__5__Impl_in_rule__Entity__Group__51380);
            rule__Entity__Group__5__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group__6_in_rule__Entity__Group__51383);
            rule__Entity__Group__6();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__5"


    // $ANTLR start "rule__Entity__Group__5__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:697:1: rule__Entity__Group__5__Impl : ( ( rule__Entity__AttributesAssignment_5 )* ) ;
    public final void rule__Entity__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:701:1: ( ( ( rule__Entity__AttributesAssignment_5 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:702:1: ( ( rule__Entity__AttributesAssignment_5 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:702:1: ( ( rule__Entity__AttributesAssignment_5 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:703:1: ( rule__Entity__AttributesAssignment_5 )*
            {
             before(grammarAccess.getEntityAccess().getAttributesAssignment_5()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:704:1: ( rule__Entity__AttributesAssignment_5 )*
            loop8:
            do {
                int alt8=2;
                int LA8_0 = input.LA(1);

                if ( (LA8_0==RULE_COMMENT||LA8_0==22||LA8_0==24) ) {
                    alt8=1;
                }


                switch (alt8) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:704:2: rule__Entity__AttributesAssignment_5
            	    {
            	    pushFollow(FOLLOW_rule__Entity__AttributesAssignment_5_in_rule__Entity__Group__5__Impl1410);
            	    rule__Entity__AttributesAssignment_5();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop8;
                }
            } while (true);

             after(grammarAccess.getEntityAccess().getAttributesAssignment_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__5__Impl"


    // $ANTLR start "rule__Entity__Group__6"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:714:1: rule__Entity__Group__6 : rule__Entity__Group__6__Impl ;
    public final void rule__Entity__Group__6() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:718:1: ( rule__Entity__Group__6__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:719:2: rule__Entity__Group__6__Impl
            {
            pushFollow(FOLLOW_rule__Entity__Group__6__Impl_in_rule__Entity__Group__61441);
            rule__Entity__Group__6__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__6"


    // $ANTLR start "rule__Entity__Group__6__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:725:1: rule__Entity__Group__6__Impl : ( '}' ) ;
    public final void rule__Entity__Group__6__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:729:1: ( ( '}' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:730:1: ( '}' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:730:1: ( '}' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:731:1: '}'
            {
             before(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_6()); 
            match(input,20,FOLLOW_20_in_rule__Entity__Group__6__Impl1469); 
             after(grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_6()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group__6__Impl"


    // $ANTLR start "rule__Entity__Group_3__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:758:1: rule__Entity__Group_3__0 : rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1 ;
    public final void rule__Entity__Group_3__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:762:1: ( rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:763:2: rule__Entity__Group_3__0__Impl rule__Entity__Group_3__1
            {
            pushFollow(FOLLOW_rule__Entity__Group_3__0__Impl_in_rule__Entity__Group_3__01514);
            rule__Entity__Group_3__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Entity__Group_3__1_in_rule__Entity__Group_3__01517);
            rule__Entity__Group_3__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__0"


    // $ANTLR start "rule__Entity__Group_3__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:770:1: rule__Entity__Group_3__0__Impl : ( 'extends' ) ;
    public final void rule__Entity__Group_3__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:774:1: ( ( 'extends' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:775:1: ( 'extends' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:775:1: ( 'extends' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:776:1: 'extends'
            {
             before(grammarAccess.getEntityAccess().getExtendsKeyword_3_0()); 
            match(input,21,FOLLOW_21_in_rule__Entity__Group_3__0__Impl1545); 
             after(grammarAccess.getEntityAccess().getExtendsKeyword_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__0__Impl"


    // $ANTLR start "rule__Entity__Group_3__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:789:1: rule__Entity__Group_3__1 : rule__Entity__Group_3__1__Impl ;
    public final void rule__Entity__Group_3__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:793:1: ( rule__Entity__Group_3__1__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:794:2: rule__Entity__Group_3__1__Impl
            {
            pushFollow(FOLLOW_rule__Entity__Group_3__1__Impl_in_rule__Entity__Group_3__11576);
            rule__Entity__Group_3__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__1"


    // $ANTLR start "rule__Entity__Group_3__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:800:1: rule__Entity__Group_3__1__Impl : ( ( rule__Entity__SuperTypeAssignment_3_1 ) ) ;
    public final void rule__Entity__Group_3__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:804:1: ( ( ( rule__Entity__SuperTypeAssignment_3_1 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:805:1: ( ( rule__Entity__SuperTypeAssignment_3_1 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:805:1: ( ( rule__Entity__SuperTypeAssignment_3_1 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:806:1: ( rule__Entity__SuperTypeAssignment_3_1 )
            {
             before(grammarAccess.getEntityAccess().getSuperTypeAssignment_3_1()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:807:1: ( rule__Entity__SuperTypeAssignment_3_1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:807:2: rule__Entity__SuperTypeAssignment_3_1
            {
            pushFollow(FOLLOW_rule__Entity__SuperTypeAssignment_3_1_in_rule__Entity__Group_3__1__Impl1603);
            rule__Entity__SuperTypeAssignment_3_1();

            state._fsp--;


            }

             after(grammarAccess.getEntityAccess().getSuperTypeAssignment_3_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__Group_3__1__Impl"


    // $ANTLR start "rule__Property__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:821:1: rule__Property__Group__0 : rule__Property__Group__0__Impl rule__Property__Group__1 ;
    public final void rule__Property__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:825:1: ( rule__Property__Group__0__Impl rule__Property__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:826:2: rule__Property__Group__0__Impl rule__Property__Group__1
            {
            pushFollow(FOLLOW_rule__Property__Group__0__Impl_in_rule__Property__Group__01637);
            rule__Property__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Property__Group__1_in_rule__Property__Group__01640);
            rule__Property__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__0"


    // $ANTLR start "rule__Property__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:833:1: rule__Property__Group__0__Impl : ( ( rule__Property__CommentAssignment_0 )* ) ;
    public final void rule__Property__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:837:1: ( ( ( rule__Property__CommentAssignment_0 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:838:1: ( ( rule__Property__CommentAssignment_0 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:838:1: ( ( rule__Property__CommentAssignment_0 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:839:1: ( rule__Property__CommentAssignment_0 )*
            {
             before(grammarAccess.getPropertyAccess().getCommentAssignment_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:840:1: ( rule__Property__CommentAssignment_0 )*
            loop9:
            do {
                int alt9=2;
                int LA9_0 = input.LA(1);

                if ( (LA9_0==RULE_COMMENT) ) {
                    alt9=1;
                }


                switch (alt9) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:840:2: rule__Property__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_rule__Property__CommentAssignment_0_in_rule__Property__Group__0__Impl1667);
            	    rule__Property__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop9;
                }
            } while (true);

             after(grammarAccess.getPropertyAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__0__Impl"


    // $ANTLR start "rule__Property__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:850:1: rule__Property__Group__1 : rule__Property__Group__1__Impl rule__Property__Group__2 ;
    public final void rule__Property__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:854:1: ( rule__Property__Group__1__Impl rule__Property__Group__2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:855:2: rule__Property__Group__1__Impl rule__Property__Group__2
            {
            pushFollow(FOLLOW_rule__Property__Group__1__Impl_in_rule__Property__Group__11698);
            rule__Property__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Property__Group__2_in_rule__Property__Group__11701);
            rule__Property__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__1"


    // $ANTLR start "rule__Property__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:862:1: rule__Property__Group__1__Impl : ( 'property' ) ;
    public final void rule__Property__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:866:1: ( ( 'property' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:867:1: ( 'property' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:867:1: ( 'property' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:868:1: 'property'
            {
             before(grammarAccess.getPropertyAccess().getPropertyKeyword_1()); 
            match(input,22,FOLLOW_22_in_rule__Property__Group__1__Impl1729); 
             after(grammarAccess.getPropertyAccess().getPropertyKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__1__Impl"


    // $ANTLR start "rule__Property__Group__2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:881:1: rule__Property__Group__2 : rule__Property__Group__2__Impl rule__Property__Group__3 ;
    public final void rule__Property__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:885:1: ( rule__Property__Group__2__Impl rule__Property__Group__3 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:886:2: rule__Property__Group__2__Impl rule__Property__Group__3
            {
            pushFollow(FOLLOW_rule__Property__Group__2__Impl_in_rule__Property__Group__21760);
            rule__Property__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Property__Group__3_in_rule__Property__Group__21763);
            rule__Property__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__2"


    // $ANTLR start "rule__Property__Group__2__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:893:1: rule__Property__Group__2__Impl : ( ( rule__Property__NameAssignment_2 ) ) ;
    public final void rule__Property__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:897:1: ( ( ( rule__Property__NameAssignment_2 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:898:1: ( ( rule__Property__NameAssignment_2 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:898:1: ( ( rule__Property__NameAssignment_2 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:899:1: ( rule__Property__NameAssignment_2 )
            {
             before(grammarAccess.getPropertyAccess().getNameAssignment_2()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:900:1: ( rule__Property__NameAssignment_2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:900:2: rule__Property__NameAssignment_2
            {
            pushFollow(FOLLOW_rule__Property__NameAssignment_2_in_rule__Property__Group__2__Impl1790);
            rule__Property__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__2__Impl"


    // $ANTLR start "rule__Property__Group__3"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:910:1: rule__Property__Group__3 : rule__Property__Group__3__Impl rule__Property__Group__4 ;
    public final void rule__Property__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:914:1: ( rule__Property__Group__3__Impl rule__Property__Group__4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:915:2: rule__Property__Group__3__Impl rule__Property__Group__4
            {
            pushFollow(FOLLOW_rule__Property__Group__3__Impl_in_rule__Property__Group__31820);
            rule__Property__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Property__Group__4_in_rule__Property__Group__31823);
            rule__Property__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__3"


    // $ANTLR start "rule__Property__Group__3__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:922:1: rule__Property__Group__3__Impl : ( ':' ) ;
    public final void rule__Property__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:926:1: ( ( ':' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:927:1: ( ':' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:927:1: ( ':' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:928:1: ':'
            {
             before(grammarAccess.getPropertyAccess().getColonKeyword_3()); 
            match(input,23,FOLLOW_23_in_rule__Property__Group__3__Impl1851); 
             after(grammarAccess.getPropertyAccess().getColonKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__3__Impl"


    // $ANTLR start "rule__Property__Group__4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:941:1: rule__Property__Group__4 : rule__Property__Group__4__Impl rule__Property__Group__5 ;
    public final void rule__Property__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:945:1: ( rule__Property__Group__4__Impl rule__Property__Group__5 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:946:2: rule__Property__Group__4__Impl rule__Property__Group__5
            {
            pushFollow(FOLLOW_rule__Property__Group__4__Impl_in_rule__Property__Group__41882);
            rule__Property__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Property__Group__5_in_rule__Property__Group__41885);
            rule__Property__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__4"


    // $ANTLR start "rule__Property__Group__4__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:953:1: rule__Property__Group__4__Impl : ( ( rule__Property__TypeAssignment_4 ) ) ;
    public final void rule__Property__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:957:1: ( ( ( rule__Property__TypeAssignment_4 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:958:1: ( ( rule__Property__TypeAssignment_4 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:958:1: ( ( rule__Property__TypeAssignment_4 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:959:1: ( rule__Property__TypeAssignment_4 )
            {
             before(grammarAccess.getPropertyAccess().getTypeAssignment_4()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:960:1: ( rule__Property__TypeAssignment_4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:960:2: rule__Property__TypeAssignment_4
            {
            pushFollow(FOLLOW_rule__Property__TypeAssignment_4_in_rule__Property__Group__4__Impl1912);
            rule__Property__TypeAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getTypeAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__4__Impl"


    // $ANTLR start "rule__Property__Group__5"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:970:1: rule__Property__Group__5 : rule__Property__Group__5__Impl ;
    public final void rule__Property__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:974:1: ( rule__Property__Group__5__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:975:2: rule__Property__Group__5__Impl
            {
            pushFollow(FOLLOW_rule__Property__Group__5__Impl_in_rule__Property__Group__51942);
            rule__Property__Group__5__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__5"


    // $ANTLR start "rule__Property__Group__5__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:981:1: rule__Property__Group__5__Impl : ( ';' ) ;
    public final void rule__Property__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:985:1: ( ( ';' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:986:1: ( ';' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:986:1: ( ';' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:987:1: ';'
            {
             before(grammarAccess.getPropertyAccess().getSemicolonKeyword_5()); 
            match(input,17,FOLLOW_17_in_rule__Property__Group__5__Impl1970); 
             after(grammarAccess.getPropertyAccess().getSemicolonKeyword_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__Group__5__Impl"


    // $ANTLR start "rule__Link__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1012:1: rule__Link__Group__0 : rule__Link__Group__0__Impl rule__Link__Group__1 ;
    public final void rule__Link__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1016:1: ( rule__Link__Group__0__Impl rule__Link__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1017:2: rule__Link__Group__0__Impl rule__Link__Group__1
            {
            pushFollow(FOLLOW_rule__Link__Group__0__Impl_in_rule__Link__Group__02013);
            rule__Link__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__1_in_rule__Link__Group__02016);
            rule__Link__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__0"


    // $ANTLR start "rule__Link__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1024:1: rule__Link__Group__0__Impl : ( ( rule__Link__CommentAssignment_0 )* ) ;
    public final void rule__Link__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1028:1: ( ( ( rule__Link__CommentAssignment_0 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1029:1: ( ( rule__Link__CommentAssignment_0 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1029:1: ( ( rule__Link__CommentAssignment_0 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1030:1: ( rule__Link__CommentAssignment_0 )*
            {
             before(grammarAccess.getLinkAccess().getCommentAssignment_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1031:1: ( rule__Link__CommentAssignment_0 )*
            loop10:
            do {
                int alt10=2;
                int LA10_0 = input.LA(1);

                if ( (LA10_0==RULE_COMMENT) ) {
                    alt10=1;
                }


                switch (alt10) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1031:2: rule__Link__CommentAssignment_0
            	    {
            	    pushFollow(FOLLOW_rule__Link__CommentAssignment_0_in_rule__Link__Group__0__Impl2043);
            	    rule__Link__CommentAssignment_0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop10;
                }
            } while (true);

             after(grammarAccess.getLinkAccess().getCommentAssignment_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__0__Impl"


    // $ANTLR start "rule__Link__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1041:1: rule__Link__Group__1 : rule__Link__Group__1__Impl rule__Link__Group__2 ;
    public final void rule__Link__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1045:1: ( rule__Link__Group__1__Impl rule__Link__Group__2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1046:2: rule__Link__Group__1__Impl rule__Link__Group__2
            {
            pushFollow(FOLLOW_rule__Link__Group__1__Impl_in_rule__Link__Group__12074);
            rule__Link__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__2_in_rule__Link__Group__12077);
            rule__Link__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__1"


    // $ANTLR start "rule__Link__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1053:1: rule__Link__Group__1__Impl : ( 'link' ) ;
    public final void rule__Link__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1057:1: ( ( 'link' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1058:1: ( 'link' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1058:1: ( 'link' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1059:1: 'link'
            {
             before(grammarAccess.getLinkAccess().getLinkKeyword_1()); 
            match(input,24,FOLLOW_24_in_rule__Link__Group__1__Impl2105); 
             after(grammarAccess.getLinkAccess().getLinkKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__1__Impl"


    // $ANTLR start "rule__Link__Group__2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1072:1: rule__Link__Group__2 : rule__Link__Group__2__Impl rule__Link__Group__3 ;
    public final void rule__Link__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1076:1: ( rule__Link__Group__2__Impl rule__Link__Group__3 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1077:2: rule__Link__Group__2__Impl rule__Link__Group__3
            {
            pushFollow(FOLLOW_rule__Link__Group__2__Impl_in_rule__Link__Group__22136);
            rule__Link__Group__2__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__3_in_rule__Link__Group__22139);
            rule__Link__Group__3();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__2"


    // $ANTLR start "rule__Link__Group__2__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1084:1: rule__Link__Group__2__Impl : ( ( rule__Link__NameAssignment_2 ) ) ;
    public final void rule__Link__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1088:1: ( ( ( rule__Link__NameAssignment_2 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1089:1: ( ( rule__Link__NameAssignment_2 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1089:1: ( ( rule__Link__NameAssignment_2 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1090:1: ( rule__Link__NameAssignment_2 )
            {
             before(grammarAccess.getLinkAccess().getNameAssignment_2()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1091:1: ( rule__Link__NameAssignment_2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1091:2: rule__Link__NameAssignment_2
            {
            pushFollow(FOLLOW_rule__Link__NameAssignment_2_in_rule__Link__Group__2__Impl2166);
            rule__Link__NameAssignment_2();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getNameAssignment_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__2__Impl"


    // $ANTLR start "rule__Link__Group__3"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1101:1: rule__Link__Group__3 : rule__Link__Group__3__Impl rule__Link__Group__4 ;
    public final void rule__Link__Group__3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1105:1: ( rule__Link__Group__3__Impl rule__Link__Group__4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1106:2: rule__Link__Group__3__Impl rule__Link__Group__4
            {
            pushFollow(FOLLOW_rule__Link__Group__3__Impl_in_rule__Link__Group__32196);
            rule__Link__Group__3__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__4_in_rule__Link__Group__32199);
            rule__Link__Group__4();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__3"


    // $ANTLR start "rule__Link__Group__3__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1113:1: rule__Link__Group__3__Impl : ( ':' ) ;
    public final void rule__Link__Group__3__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1117:1: ( ( ':' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1118:1: ( ':' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1118:1: ( ':' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1119:1: ':'
            {
             before(grammarAccess.getLinkAccess().getColonKeyword_3()); 
            match(input,23,FOLLOW_23_in_rule__Link__Group__3__Impl2227); 
             after(grammarAccess.getLinkAccess().getColonKeyword_3()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__3__Impl"


    // $ANTLR start "rule__Link__Group__4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1132:1: rule__Link__Group__4 : rule__Link__Group__4__Impl rule__Link__Group__5 ;
    public final void rule__Link__Group__4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1136:1: ( rule__Link__Group__4__Impl rule__Link__Group__5 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1137:2: rule__Link__Group__4__Impl rule__Link__Group__5
            {
            pushFollow(FOLLOW_rule__Link__Group__4__Impl_in_rule__Link__Group__42258);
            rule__Link__Group__4__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__5_in_rule__Link__Group__42261);
            rule__Link__Group__5();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__4"


    // $ANTLR start "rule__Link__Group__4__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1144:1: rule__Link__Group__4__Impl : ( ( rule__Link__TypeAssignment_4 ) ) ;
    public final void rule__Link__Group__4__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1148:1: ( ( ( rule__Link__TypeAssignment_4 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1149:1: ( ( rule__Link__TypeAssignment_4 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1149:1: ( ( rule__Link__TypeAssignment_4 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1150:1: ( rule__Link__TypeAssignment_4 )
            {
             before(grammarAccess.getLinkAccess().getTypeAssignment_4()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1151:1: ( rule__Link__TypeAssignment_4 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1151:2: rule__Link__TypeAssignment_4
            {
            pushFollow(FOLLOW_rule__Link__TypeAssignment_4_in_rule__Link__Group__4__Impl2288);
            rule__Link__TypeAssignment_4();

            state._fsp--;


            }

             after(grammarAccess.getLinkAccess().getTypeAssignment_4()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__4__Impl"


    // $ANTLR start "rule__Link__Group__5"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1161:1: rule__Link__Group__5 : rule__Link__Group__5__Impl rule__Link__Group__6 ;
    public final void rule__Link__Group__5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1165:1: ( rule__Link__Group__5__Impl rule__Link__Group__6 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1166:2: rule__Link__Group__5__Impl rule__Link__Group__6
            {
            pushFollow(FOLLOW_rule__Link__Group__5__Impl_in_rule__Link__Group__52318);
            rule__Link__Group__5__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Link__Group__6_in_rule__Link__Group__52321);
            rule__Link__Group__6();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__5"


    // $ANTLR start "rule__Link__Group__5__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1173:1: rule__Link__Group__5__Impl : ( ( rule__Link__Alternatives_5 )? ) ;
    public final void rule__Link__Group__5__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1177:1: ( ( ( rule__Link__Alternatives_5 )? ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1178:1: ( ( rule__Link__Alternatives_5 )? )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1178:1: ( ( rule__Link__Alternatives_5 )? )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1179:1: ( rule__Link__Alternatives_5 )?
            {
             before(grammarAccess.getLinkAccess().getAlternatives_5()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1180:1: ( rule__Link__Alternatives_5 )?
            int alt11=2;
            int LA11_0 = input.LA(1);

            if ( ((LA11_0>=28 && LA11_0<=30)) ) {
                alt11=1;
            }
            switch (alt11) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1180:2: rule__Link__Alternatives_5
                    {
                    pushFollow(FOLLOW_rule__Link__Alternatives_5_in_rule__Link__Group__5__Impl2348);
                    rule__Link__Alternatives_5();

                    state._fsp--;


                    }
                    break;

            }

             after(grammarAccess.getLinkAccess().getAlternatives_5()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__5__Impl"


    // $ANTLR start "rule__Link__Group__6"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1190:1: rule__Link__Group__6 : rule__Link__Group__6__Impl ;
    public final void rule__Link__Group__6() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1194:1: ( rule__Link__Group__6__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1195:2: rule__Link__Group__6__Impl
            {
            pushFollow(FOLLOW_rule__Link__Group__6__Impl_in_rule__Link__Group__62379);
            rule__Link__Group__6__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__6"


    // $ANTLR start "rule__Link__Group__6__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1201:1: rule__Link__Group__6__Impl : ( ';' ) ;
    public final void rule__Link__Group__6__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1205:1: ( ( ';' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1206:1: ( ';' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1206:1: ( ';' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1207:1: ';'
            {
             before(grammarAccess.getLinkAccess().getSemicolonKeyword_6()); 
            match(input,17,FOLLOW_17_in_rule__Link__Group__6__Impl2407); 
             after(grammarAccess.getLinkAccess().getSemicolonKeyword_6()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__Group__6__Impl"


    // $ANTLR start "rule__Import__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1234:1: rule__Import__Group__0 : rule__Import__Group__0__Impl rule__Import__Group__1 ;
    public final void rule__Import__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1238:1: ( rule__Import__Group__0__Impl rule__Import__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1239:2: rule__Import__Group__0__Impl rule__Import__Group__1
            {
            pushFollow(FOLLOW_rule__Import__Group__0__Impl_in_rule__Import__Group__02452);
            rule__Import__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Import__Group__1_in_rule__Import__Group__02455);
            rule__Import__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__0"


    // $ANTLR start "rule__Import__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1246:1: rule__Import__Group__0__Impl : ( 'import' ) ;
    public final void rule__Import__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1250:1: ( ( 'import' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1251:1: ( 'import' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1251:1: ( 'import' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1252:1: 'import'
            {
             before(grammarAccess.getImportAccess().getImportKeyword_0()); 
            match(input,25,FOLLOW_25_in_rule__Import__Group__0__Impl2483); 
             after(grammarAccess.getImportAccess().getImportKeyword_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__0__Impl"


    // $ANTLR start "rule__Import__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1265:1: rule__Import__Group__1 : rule__Import__Group__1__Impl rule__Import__Group__2 ;
    public final void rule__Import__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1269:1: ( rule__Import__Group__1__Impl rule__Import__Group__2 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1270:2: rule__Import__Group__1__Impl rule__Import__Group__2
            {
            pushFollow(FOLLOW_rule__Import__Group__1__Impl_in_rule__Import__Group__12514);
            rule__Import__Group__1__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__Import__Group__2_in_rule__Import__Group__12517);
            rule__Import__Group__2();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__1"


    // $ANTLR start "rule__Import__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1277:1: rule__Import__Group__1__Impl : ( ( rule__Import__ImportedNamespaceAssignment_1 ) ) ;
    public final void rule__Import__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1281:1: ( ( ( rule__Import__ImportedNamespaceAssignment_1 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1282:1: ( ( rule__Import__ImportedNamespaceAssignment_1 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1282:1: ( ( rule__Import__ImportedNamespaceAssignment_1 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1283:1: ( rule__Import__ImportedNamespaceAssignment_1 )
            {
             before(grammarAccess.getImportAccess().getImportedNamespaceAssignment_1()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1284:1: ( rule__Import__ImportedNamespaceAssignment_1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1284:2: rule__Import__ImportedNamespaceAssignment_1
            {
            pushFollow(FOLLOW_rule__Import__ImportedNamespaceAssignment_1_in_rule__Import__Group__1__Impl2544);
            rule__Import__ImportedNamespaceAssignment_1();

            state._fsp--;


            }

             after(grammarAccess.getImportAccess().getImportedNamespaceAssignment_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__1__Impl"


    // $ANTLR start "rule__Import__Group__2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1294:1: rule__Import__Group__2 : rule__Import__Group__2__Impl ;
    public final void rule__Import__Group__2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1298:1: ( rule__Import__Group__2__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1299:2: rule__Import__Group__2__Impl
            {
            pushFollow(FOLLOW_rule__Import__Group__2__Impl_in_rule__Import__Group__22574);
            rule__Import__Group__2__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__2"


    // $ANTLR start "rule__Import__Group__2__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1305:1: rule__Import__Group__2__Impl : ( ';' ) ;
    public final void rule__Import__Group__2__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1309:1: ( ( ';' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1310:1: ( ';' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1310:1: ( ';' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1311:1: ';'
            {
             before(grammarAccess.getImportAccess().getSemicolonKeyword_2()); 
            match(input,17,FOLLOW_17_in_rule__Import__Group__2__Impl2602); 
             after(grammarAccess.getImportAccess().getSemicolonKeyword_2()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__Group__2__Impl"


    // $ANTLR start "rule__QualifiedName__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1330:1: rule__QualifiedName__Group__0 : rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1 ;
    public final void rule__QualifiedName__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1334:1: ( rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1335:2: rule__QualifiedName__Group__0__Impl rule__QualifiedName__Group__1
            {
            pushFollow(FOLLOW_rule__QualifiedName__Group__0__Impl_in_rule__QualifiedName__Group__02639);
            rule__QualifiedName__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__QualifiedName__Group__1_in_rule__QualifiedName__Group__02642);
            rule__QualifiedName__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__0"


    // $ANTLR start "rule__QualifiedName__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1342:1: rule__QualifiedName__Group__0__Impl : ( RULE_ID ) ;
    public final void rule__QualifiedName__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1346:1: ( ( RULE_ID ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1347:1: ( RULE_ID )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1347:1: ( RULE_ID )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1348:1: RULE_ID
            {
             before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); 
            match(input,RULE_ID,FOLLOW_RULE_ID_in_rule__QualifiedName__Group__0__Impl2669); 
             after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__0__Impl"


    // $ANTLR start "rule__QualifiedName__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1359:1: rule__QualifiedName__Group__1 : rule__QualifiedName__Group__1__Impl ;
    public final void rule__QualifiedName__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1363:1: ( rule__QualifiedName__Group__1__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1364:2: rule__QualifiedName__Group__1__Impl
            {
            pushFollow(FOLLOW_rule__QualifiedName__Group__1__Impl_in_rule__QualifiedName__Group__12698);
            rule__QualifiedName__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__1"


    // $ANTLR start "rule__QualifiedName__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1370:1: rule__QualifiedName__Group__1__Impl : ( ( rule__QualifiedName__Group_1__0 )* ) ;
    public final void rule__QualifiedName__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1374:1: ( ( ( rule__QualifiedName__Group_1__0 )* ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1375:1: ( ( rule__QualifiedName__Group_1__0 )* )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1375:1: ( ( rule__QualifiedName__Group_1__0 )* )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1376:1: ( rule__QualifiedName__Group_1__0 )*
            {
             before(grammarAccess.getQualifiedNameAccess().getGroup_1()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1377:1: ( rule__QualifiedName__Group_1__0 )*
            loop12:
            do {
                int alt12=2;
                int LA12_0 = input.LA(1);

                if ( (LA12_0==26) ) {
                    alt12=1;
                }


                switch (alt12) {
            	case 1 :
            	    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1377:2: rule__QualifiedName__Group_1__0
            	    {
            	    pushFollow(FOLLOW_rule__QualifiedName__Group_1__0_in_rule__QualifiedName__Group__1__Impl2725);
            	    rule__QualifiedName__Group_1__0();

            	    state._fsp--;


            	    }
            	    break;

            	default :
            	    break loop12;
                }
            } while (true);

             after(grammarAccess.getQualifiedNameAccess().getGroup_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group__1__Impl"


    // $ANTLR start "rule__QualifiedName__Group_1__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1391:1: rule__QualifiedName__Group_1__0 : rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1 ;
    public final void rule__QualifiedName__Group_1__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1395:1: ( rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1396:2: rule__QualifiedName__Group_1__0__Impl rule__QualifiedName__Group_1__1
            {
            pushFollow(FOLLOW_rule__QualifiedName__Group_1__0__Impl_in_rule__QualifiedName__Group_1__02760);
            rule__QualifiedName__Group_1__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__QualifiedName__Group_1__1_in_rule__QualifiedName__Group_1__02763);
            rule__QualifiedName__Group_1__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__0"


    // $ANTLR start "rule__QualifiedName__Group_1__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1403:1: rule__QualifiedName__Group_1__0__Impl : ( '.' ) ;
    public final void rule__QualifiedName__Group_1__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1407:1: ( ( '.' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1408:1: ( '.' )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1408:1: ( '.' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1409:1: '.'
            {
             before(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); 
            match(input,26,FOLLOW_26_in_rule__QualifiedName__Group_1__0__Impl2791); 
             after(grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__0__Impl"


    // $ANTLR start "rule__QualifiedName__Group_1__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1422:1: rule__QualifiedName__Group_1__1 : rule__QualifiedName__Group_1__1__Impl ;
    public final void rule__QualifiedName__Group_1__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1426:1: ( rule__QualifiedName__Group_1__1__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1427:2: rule__QualifiedName__Group_1__1__Impl
            {
            pushFollow(FOLLOW_rule__QualifiedName__Group_1__1__Impl_in_rule__QualifiedName__Group_1__12822);
            rule__QualifiedName__Group_1__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__1"


    // $ANTLR start "rule__QualifiedName__Group_1__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1433:1: rule__QualifiedName__Group_1__1__Impl : ( RULE_ID ) ;
    public final void rule__QualifiedName__Group_1__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1437:1: ( ( RULE_ID ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1438:1: ( RULE_ID )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1438:1: ( RULE_ID )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1439:1: RULE_ID
            {
             before(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); 
            match(input,RULE_ID,FOLLOW_RULE_ID_in_rule__QualifiedName__Group_1__1__Impl2849); 
             after(grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedName__Group_1__1__Impl"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1454:1: rule__QualifiedNameWithWildcard__Group__0 : rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1 ;
    public final void rule__QualifiedNameWithWildcard__Group__0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1458:1: ( rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1459:2: rule__QualifiedNameWithWildcard__Group__0__Impl rule__QualifiedNameWithWildcard__Group__1
            {
            pushFollow(FOLLOW_rule__QualifiedNameWithWildcard__Group__0__Impl_in_rule__QualifiedNameWithWildcard__Group__02882);
            rule__QualifiedNameWithWildcard__Group__0__Impl();

            state._fsp--;

            pushFollow(FOLLOW_rule__QualifiedNameWithWildcard__Group__1_in_rule__QualifiedNameWithWildcard__Group__02885);
            rule__QualifiedNameWithWildcard__Group__1();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__0"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__0__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1466:1: rule__QualifiedNameWithWildcard__Group__0__Impl : ( ruleQualifiedName ) ;
    public final void rule__QualifiedNameWithWildcard__Group__0__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1470:1: ( ( ruleQualifiedName ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1471:1: ( ruleQualifiedName )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1471:1: ( ruleQualifiedName )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1472:1: ruleQualifiedName
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getQualifiedNameParserRuleCall_0()); 
            pushFollow(FOLLOW_ruleQualifiedName_in_rule__QualifiedNameWithWildcard__Group__0__Impl2912);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getQualifiedNameParserRuleCall_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__0__Impl"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1483:1: rule__QualifiedNameWithWildcard__Group__1 : rule__QualifiedNameWithWildcard__Group__1__Impl ;
    public final void rule__QualifiedNameWithWildcard__Group__1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1487:1: ( rule__QualifiedNameWithWildcard__Group__1__Impl )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1488:2: rule__QualifiedNameWithWildcard__Group__1__Impl
            {
            pushFollow(FOLLOW_rule__QualifiedNameWithWildcard__Group__1__Impl_in_rule__QualifiedNameWithWildcard__Group__12941);
            rule__QualifiedNameWithWildcard__Group__1__Impl();

            state._fsp--;


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__1"


    // $ANTLR start "rule__QualifiedNameWithWildcard__Group__1__Impl"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1494:1: rule__QualifiedNameWithWildcard__Group__1__Impl : ( ( '.*' )? ) ;
    public final void rule__QualifiedNameWithWildcard__Group__1__Impl() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1498:1: ( ( ( '.*' )? ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1499:1: ( ( '.*' )? )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1499:1: ( ( '.*' )? )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1500:1: ( '.*' )?
            {
             before(grammarAccess.getQualifiedNameWithWildcardAccess().getFullStopAsteriskKeyword_1()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1501:1: ( '.*' )?
            int alt13=2;
            int LA13_0 = input.LA(1);

            if ( (LA13_0==27) ) {
                alt13=1;
            }
            switch (alt13) {
                case 1 :
                    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1502:2: '.*'
                    {
                    match(input,27,FOLLOW_27_in_rule__QualifiedNameWithWildcard__Group__1__Impl2970); 

                    }
                    break;

            }

             after(grammarAccess.getQualifiedNameWithWildcardAccess().getFullStopAsteriskKeyword_1()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__QualifiedNameWithWildcard__Group__1__Impl"


    // $ANTLR start "rule__Model__NameAssignment_1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1518:1: rule__Model__NameAssignment_1 : ( ruleQualifiedName ) ;
    public final void rule__Model__NameAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1522:1: ( ( ruleQualifiedName ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1523:1: ( ruleQualifiedName )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1523:1: ( ruleQualifiedName )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1524:1: ruleQualifiedName
            {
             before(grammarAccess.getModelAccess().getNameQualifiedNameParserRuleCall_1_0()); 
            pushFollow(FOLLOW_ruleQualifiedName_in_rule__Model__NameAssignment_13012);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getModelAccess().getNameQualifiedNameParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__NameAssignment_1"


    // $ANTLR start "rule__Model__ImportsAssignment_3"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1533:1: rule__Model__ImportsAssignment_3 : ( ruleImport ) ;
    public final void rule__Model__ImportsAssignment_3() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1537:1: ( ( ruleImport ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1538:1: ( ruleImport )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1538:1: ( ruleImport )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1539:1: ruleImport
            {
             before(grammarAccess.getModelAccess().getImportsImportParserRuleCall_3_0()); 
            pushFollow(FOLLOW_ruleImport_in_rule__Model__ImportsAssignment_33043);
            ruleImport();

            state._fsp--;

             after(grammarAccess.getModelAccess().getImportsImportParserRuleCall_3_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__ImportsAssignment_3"


    // $ANTLR start "rule__Model__ElementsAssignment_4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1548:1: rule__Model__ElementsAssignment_4 : ( ruleEntity ) ;
    public final void rule__Model__ElementsAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1552:1: ( ( ruleEntity ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1553:1: ( ruleEntity )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1553:1: ( ruleEntity )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1554:1: ruleEntity
            {
             before(grammarAccess.getModelAccess().getElementsEntityParserRuleCall_4_0()); 
            pushFollow(FOLLOW_ruleEntity_in_rule__Model__ElementsAssignment_43074);
            ruleEntity();

            state._fsp--;

             after(grammarAccess.getModelAccess().getElementsEntityParserRuleCall_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Model__ElementsAssignment_4"


    // $ANTLR start "rule__Entity__CommentAssignment_0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1563:1: rule__Entity__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Entity__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1567:1: ( ( RULE_COMMENT ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1568:1: ( RULE_COMMENT )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1568:1: ( RULE_COMMENT )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1569:1: RULE_COMMENT
            {
             before(grammarAccess.getEntityAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_RULE_COMMENT_in_rule__Entity__CommentAssignment_03105); 
             after(grammarAccess.getEntityAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__CommentAssignment_0"


    // $ANTLR start "rule__Entity__NameAssignment_2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1578:1: rule__Entity__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Entity__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1582:1: ( ( RULE_ID ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1583:1: ( RULE_ID )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1583:1: ( RULE_ID )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1584:1: RULE_ID
            {
             before(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_RULE_ID_in_rule__Entity__NameAssignment_23136); 
             after(grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__NameAssignment_2"


    // $ANTLR start "rule__Entity__SuperTypeAssignment_3_1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1593:1: rule__Entity__SuperTypeAssignment_3_1 : ( ( ruleQualifiedName ) ) ;
    public final void rule__Entity__SuperTypeAssignment_3_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1597:1: ( ( ( ruleQualifiedName ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1598:1: ( ( ruleQualifiedName ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1598:1: ( ( ruleQualifiedName ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1599:1: ( ruleQualifiedName )
            {
             before(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_3_1_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1600:1: ( ruleQualifiedName )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1601:1: ruleQualifiedName
            {
             before(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_3_1_0_1()); 
            pushFollow(FOLLOW_ruleQualifiedName_in_rule__Entity__SuperTypeAssignment_3_13171);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getEntityAccess().getSuperTypeEntityQualifiedNameParserRuleCall_3_1_0_1()); 

            }

             after(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_3_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__SuperTypeAssignment_3_1"


    // $ANTLR start "rule__Entity__AttributesAssignment_5"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1612:1: rule__Entity__AttributesAssignment_5 : ( ruleAttribute ) ;
    public final void rule__Entity__AttributesAssignment_5() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1616:1: ( ( ruleAttribute ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1617:1: ( ruleAttribute )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1617:1: ( ruleAttribute )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1618:1: ruleAttribute
            {
             before(grammarAccess.getEntityAccess().getAttributesAttributeParserRuleCall_5_0()); 
            pushFollow(FOLLOW_ruleAttribute_in_rule__Entity__AttributesAssignment_53206);
            ruleAttribute();

            state._fsp--;

             after(grammarAccess.getEntityAccess().getAttributesAttributeParserRuleCall_5_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Entity__AttributesAssignment_5"


    // $ANTLR start "rule__Property__CommentAssignment_0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1627:1: rule__Property__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Property__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1631:1: ( ( RULE_COMMENT ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1632:1: ( RULE_COMMENT )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1632:1: ( RULE_COMMENT )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1633:1: RULE_COMMENT
            {
             before(grammarAccess.getPropertyAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_RULE_COMMENT_in_rule__Property__CommentAssignment_03237); 
             after(grammarAccess.getPropertyAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__CommentAssignment_0"


    // $ANTLR start "rule__Property__NameAssignment_2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1642:1: rule__Property__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Property__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1646:1: ( ( RULE_ID ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1647:1: ( RULE_ID )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1647:1: ( RULE_ID )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1648:1: RULE_ID
            {
             before(grammarAccess.getPropertyAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_RULE_ID_in_rule__Property__NameAssignment_23268); 
             after(grammarAccess.getPropertyAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__NameAssignment_2"


    // $ANTLR start "rule__Property__TypeAssignment_4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1657:1: rule__Property__TypeAssignment_4 : ( ( rule__Property__TypeAlternatives_4_0 ) ) ;
    public final void rule__Property__TypeAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1661:1: ( ( ( rule__Property__TypeAlternatives_4_0 ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1662:1: ( ( rule__Property__TypeAlternatives_4_0 ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1662:1: ( ( rule__Property__TypeAlternatives_4_0 ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1663:1: ( rule__Property__TypeAlternatives_4_0 )
            {
             before(grammarAccess.getPropertyAccess().getTypeAlternatives_4_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1664:1: ( rule__Property__TypeAlternatives_4_0 )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1664:2: rule__Property__TypeAlternatives_4_0
            {
            pushFollow(FOLLOW_rule__Property__TypeAlternatives_4_0_in_rule__Property__TypeAssignment_43299);
            rule__Property__TypeAlternatives_4_0();

            state._fsp--;


            }

             after(grammarAccess.getPropertyAccess().getTypeAlternatives_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Property__TypeAssignment_4"


    // $ANTLR start "rule__Link__CommentAssignment_0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1673:1: rule__Link__CommentAssignment_0 : ( RULE_COMMENT ) ;
    public final void rule__Link__CommentAssignment_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1677:1: ( ( RULE_COMMENT ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1678:1: ( RULE_COMMENT )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1678:1: ( RULE_COMMENT )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1679:1: RULE_COMMENT
            {
             before(grammarAccess.getLinkAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 
            match(input,RULE_COMMENT,FOLLOW_RULE_COMMENT_in_rule__Link__CommentAssignment_03332); 
             after(grammarAccess.getLinkAccess().getCommentCOMMENTTerminalRuleCall_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__CommentAssignment_0"


    // $ANTLR start "rule__Link__NameAssignment_2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1688:1: rule__Link__NameAssignment_2 : ( RULE_ID ) ;
    public final void rule__Link__NameAssignment_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1692:1: ( ( RULE_ID ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1693:1: ( RULE_ID )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1693:1: ( RULE_ID )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1694:1: RULE_ID
            {
             before(grammarAccess.getLinkAccess().getNameIDTerminalRuleCall_2_0()); 
            match(input,RULE_ID,FOLLOW_RULE_ID_in_rule__Link__NameAssignment_23363); 
             after(grammarAccess.getLinkAccess().getNameIDTerminalRuleCall_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__NameAssignment_2"


    // $ANTLR start "rule__Link__TypeAssignment_4"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1703:1: rule__Link__TypeAssignment_4 : ( ( ruleQualifiedName ) ) ;
    public final void rule__Link__TypeAssignment_4() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1707:1: ( ( ( ruleQualifiedName ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1708:1: ( ( ruleQualifiedName ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1708:1: ( ( ruleQualifiedName ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1709:1: ( ruleQualifiedName )
            {
             before(grammarAccess.getLinkAccess().getTypeEntityCrossReference_4_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1710:1: ( ruleQualifiedName )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1711:1: ruleQualifiedName
            {
             before(grammarAccess.getLinkAccess().getTypeEntityQualifiedNameParserRuleCall_4_0_1()); 
            pushFollow(FOLLOW_ruleQualifiedName_in_rule__Link__TypeAssignment_43398);
            ruleQualifiedName();

            state._fsp--;

             after(grammarAccess.getLinkAccess().getTypeEntityQualifiedNameParserRuleCall_4_0_1()); 

            }

             after(grammarAccess.getLinkAccess().getTypeEntityCrossReference_4_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__TypeAssignment_4"


    // $ANTLR start "rule__Link__AnyAssignment_5_0"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1722:1: rule__Link__AnyAssignment_5_0 : ( ( '*' ) ) ;
    public final void rule__Link__AnyAssignment_5_0() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1726:1: ( ( ( '*' ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1727:1: ( ( '*' ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1727:1: ( ( '*' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1728:1: ( '*' )
            {
             before(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1729:1: ( '*' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1730:1: '*'
            {
             before(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 
            match(input,28,FOLLOW_28_in_rule__Link__AnyAssignment_5_03438); 
             after(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 

            }

             after(grammarAccess.getLinkAccess().getAnyAsteriskKeyword_5_0_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__AnyAssignment_5_0"


    // $ANTLR start "rule__Link__OneOrMoreAssignment_5_1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1745:1: rule__Link__OneOrMoreAssignment_5_1 : ( ( '+' ) ) ;
    public final void rule__Link__OneOrMoreAssignment_5_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1749:1: ( ( ( '+' ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1750:1: ( ( '+' ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1750:1: ( ( '+' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1751:1: ( '+' )
            {
             before(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1752:1: ( '+' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1753:1: '+'
            {
             before(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 
            match(input,29,FOLLOW_29_in_rule__Link__OneOrMoreAssignment_5_13482); 
             after(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 

            }

             after(grammarAccess.getLinkAccess().getOneOrMorePlusSignKeyword_5_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__OneOrMoreAssignment_5_1"


    // $ANTLR start "rule__Link__ZeroOrOneAssignment_5_2"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1768:1: rule__Link__ZeroOrOneAssignment_5_2 : ( ( '?' ) ) ;
    public final void rule__Link__ZeroOrOneAssignment_5_2() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1772:1: ( ( ( '?' ) ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1773:1: ( ( '?' ) )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1773:1: ( ( '?' ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1774:1: ( '?' )
            {
             before(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1775:1: ( '?' )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1776:1: '?'
            {
             before(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 
            match(input,30,FOLLOW_30_in_rule__Link__ZeroOrOneAssignment_5_23526); 
             after(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 

            }

             after(grammarAccess.getLinkAccess().getZeroOrOneQuestionMarkKeyword_5_2_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Link__ZeroOrOneAssignment_5_2"


    // $ANTLR start "rule__Import__ImportedNamespaceAssignment_1"
    // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1791:1: rule__Import__ImportedNamespaceAssignment_1 : ( ruleQualifiedNameWithWildcard ) ;
    public final void rule__Import__ImportedNamespaceAssignment_1() throws RecognitionException {

        		int stackSize = keepStackSize();
            
        try {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1795:1: ( ( ruleQualifiedNameWithWildcard ) )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1796:1: ( ruleQualifiedNameWithWildcard )
            {
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1796:1: ( ruleQualifiedNameWithWildcard )
            // //var/jenkins_home/workspace/veraPDF/1.19/model-syntax/org.verapdf.ui/src-gen/org/verapdf/ui/contentassist/antlr/internal/InternalModel.g:1797:1: ruleQualifiedNameWithWildcard
            {
             before(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0()); 
            pushFollow(FOLLOW_ruleQualifiedNameWithWildcard_in_rule__Import__ImportedNamespaceAssignment_13565);
            ruleQualifiedNameWithWildcard();

            state._fsp--;

             after(grammarAccess.getImportAccess().getImportedNamespaceQualifiedNameWithWildcardParserRuleCall_1_0()); 

            }


            }

        }
        catch (RecognitionException re) {
            reportError(re);
            recover(input,re);
        }
        finally {

            	restoreStackSize(stackSize);

        }
        return ;
    }
    // $ANTLR end "rule__Import__ImportedNamespaceAssignment_1"

    // Delegated rules


    protected DFA1 dfa1 = new DFA1(this);
    static final String DFA1_eotS =
        "\4\uffff";
    static final String DFA1_eofS =
        "\4\uffff";
    static final String DFA1_minS =
        "\2\5\2\uffff";
    static final String DFA1_maxS =
        "\2\30\2\uffff";
    static final String DFA1_acceptS =
        "\2\uffff\1\1\1\2";
    static final String DFA1_specialS =
        "\4\uffff}>";
    static final String[] DFA1_transitionS = {
            "\1\1\20\uffff\1\2\1\uffff\1\3",
            "\1\1\20\uffff\1\2\1\uffff\1\3",
            "",
            ""
    };

    static final short[] DFA1_eot = DFA.unpackEncodedString(DFA1_eotS);
    static final short[] DFA1_eof = DFA.unpackEncodedString(DFA1_eofS);
    static final char[] DFA1_min = DFA.unpackEncodedStringToUnsignedChars(DFA1_minS);
    static final char[] DFA1_max = DFA.unpackEncodedStringToUnsignedChars(DFA1_maxS);
    static final short[] DFA1_accept = DFA.unpackEncodedString(DFA1_acceptS);
    static final short[] DFA1_special = DFA.unpackEncodedString(DFA1_specialS);
    static final short[][] DFA1_transition;

    static {
        int numStates = DFA1_transitionS.length;
        DFA1_transition = new short[numStates][];
        for (int i=0; i<numStates; i++) {
            DFA1_transition[i] = DFA.unpackEncodedString(DFA1_transitionS[i]);
        }
    }

    class DFA1 extends DFA {

        public DFA1(BaseRecognizer recognizer) {
            this.recognizer = recognizer;
            this.decisionNumber = 1;
            this.eot = DFA1_eot;
            this.eof = DFA1_eof;
            this.min = DFA1_min;
            this.max = DFA1_max;
            this.accept = DFA1_accept;
            this.special = DFA1_special;
            this.transition = DFA1_transition;
        }
        public String getDescription() {
            return "284:1: rule__Attribute__Alternatives : ( ( ruleProperty ) | ( ruleLink ) );";
        }
    }
 

    public static final BitSet FOLLOW_ruleModel_in_entryRuleModel61 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleModel68 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__Group__0_in_ruleModel94 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleEntity_in_entryRuleEntity121 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleEntity128 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group__0_in_ruleEntity154 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleAttribute_in_entryRuleAttribute181 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleAttribute188 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Attribute__Alternatives_in_ruleAttribute214 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleProperty_in_entryRuleProperty241 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleProperty248 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__0_in_ruleProperty274 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleLink_in_entryRuleLink301 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleLink308 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__0_in_ruleLink334 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleImport_in_entryRuleImport361 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleImport368 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Import__Group__0_in_ruleImport394 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedName_in_entryRuleQualifiedName421 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleQualifiedName428 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group__0_in_ruleQualifiedName454 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedNameWithWildcard_in_entryRuleQualifiedNameWithWildcard481 = new BitSet(new long[]{0x0000000000000000L});
    public static final BitSet FOLLOW_EOF_in_entryRuleQualifiedNameWithWildcard488 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedNameWithWildcard__Group__0_in_ruleQualifiedNameWithWildcard514 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleProperty_in_rule__Attribute__Alternatives550 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleLink_in_rule__Attribute__Alternatives567 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_12_in_rule__Property__TypeAlternatives_4_0600 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_13_in_rule__Property__TypeAlternatives_4_0620 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_14_in_rule__Property__TypeAlternatives_4_0640 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_15_in_rule__Property__TypeAlternatives_4_0660 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__AnyAssignment_5_0_in_rule__Link__Alternatives_5694 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__OneOrMoreAssignment_5_1_in_rule__Link__Alternatives_5712 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__ZeroOrOneAssignment_5_2_in_rule__Link__Alternatives_5730 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__Group__0__Impl_in_rule__Model__Group__0761 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Model__Group__1_in_rule__Model__Group__0764 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_16_in_rule__Model__Group__0__Impl792 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__Group__1__Impl_in_rule__Model__Group__1823 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_rule__Model__Group__2_in_rule__Model__Group__1826 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__NameAssignment_1_in_rule__Model__Group__1__Impl853 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__Group__2__Impl_in_rule__Model__Group__2883 = new BitSet(new long[]{0x0000000002040020L});
    public static final BitSet FOLLOW_rule__Model__Group__3_in_rule__Model__Group__2886 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_rule__Model__Group__2__Impl914 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__Group__3__Impl_in_rule__Model__Group__3945 = new BitSet(new long[]{0x0000000002040020L});
    public static final BitSet FOLLOW_rule__Model__Group__4_in_rule__Model__Group__3948 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__ImportsAssignment_3_in_rule__Model__Group__3__Impl975 = new BitSet(new long[]{0x0000000002000002L});
    public static final BitSet FOLLOW_rule__Model__Group__4__Impl_in_rule__Model__Group__41006 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Model__ElementsAssignment_4_in_rule__Model__Group__4__Impl1033 = new BitSet(new long[]{0x0000000000040022L});
    public static final BitSet FOLLOW_rule__Entity__Group__0__Impl_in_rule__Entity__Group__01074 = new BitSet(new long[]{0x0000000000040020L});
    public static final BitSet FOLLOW_rule__Entity__Group__1_in_rule__Entity__Group__01077 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__CommentAssignment_0_in_rule__Entity__Group__0__Impl1104 = new BitSet(new long[]{0x0000000000000022L});
    public static final BitSet FOLLOW_rule__Entity__Group__1__Impl_in_rule__Entity__Group__11135 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Entity__Group__2_in_rule__Entity__Group__11138 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_18_in_rule__Entity__Group__1__Impl1166 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group__2__Impl_in_rule__Entity__Group__21197 = new BitSet(new long[]{0x0000000000280000L});
    public static final BitSet FOLLOW_rule__Entity__Group__3_in_rule__Entity__Group__21200 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__NameAssignment_2_in_rule__Entity__Group__2__Impl1227 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group__3__Impl_in_rule__Entity__Group__31257 = new BitSet(new long[]{0x0000000000280000L});
    public static final BitSet FOLLOW_rule__Entity__Group__4_in_rule__Entity__Group__31260 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group_3__0_in_rule__Entity__Group__3__Impl1287 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group__4__Impl_in_rule__Entity__Group__41318 = new BitSet(new long[]{0x0000000001500020L});
    public static final BitSet FOLLOW_rule__Entity__Group__5_in_rule__Entity__Group__41321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_19_in_rule__Entity__Group__4__Impl1349 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group__5__Impl_in_rule__Entity__Group__51380 = new BitSet(new long[]{0x0000000001500020L});
    public static final BitSet FOLLOW_rule__Entity__Group__6_in_rule__Entity__Group__51383 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__AttributesAssignment_5_in_rule__Entity__Group__5__Impl1410 = new BitSet(new long[]{0x0000000001400022L});
    public static final BitSet FOLLOW_rule__Entity__Group__6__Impl_in_rule__Entity__Group__61441 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_20_in_rule__Entity__Group__6__Impl1469 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group_3__0__Impl_in_rule__Entity__Group_3__01514 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Entity__Group_3__1_in_rule__Entity__Group_3__01517 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_21_in_rule__Entity__Group_3__0__Impl1545 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__Group_3__1__Impl_in_rule__Entity__Group_3__11576 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Entity__SuperTypeAssignment_3_1_in_rule__Entity__Group_3__1__Impl1603 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__0__Impl_in_rule__Property__Group__01637 = new BitSet(new long[]{0x0000000000400020L});
    public static final BitSet FOLLOW_rule__Property__Group__1_in_rule__Property__Group__01640 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__CommentAssignment_0_in_rule__Property__Group__0__Impl1667 = new BitSet(new long[]{0x0000000000000022L});
    public static final BitSet FOLLOW_rule__Property__Group__1__Impl_in_rule__Property__Group__11698 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Property__Group__2_in_rule__Property__Group__11701 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_22_in_rule__Property__Group__1__Impl1729 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__2__Impl_in_rule__Property__Group__21760 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_rule__Property__Group__3_in_rule__Property__Group__21763 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__NameAssignment_2_in_rule__Property__Group__2__Impl1790 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__3__Impl_in_rule__Property__Group__31820 = new BitSet(new long[]{0x000000000000F000L});
    public static final BitSet FOLLOW_rule__Property__Group__4_in_rule__Property__Group__31823 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_23_in_rule__Property__Group__3__Impl1851 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__4__Impl_in_rule__Property__Group__41882 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_rule__Property__Group__5_in_rule__Property__Group__41885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__TypeAssignment_4_in_rule__Property__Group__4__Impl1912 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__Group__5__Impl_in_rule__Property__Group__51942 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_rule__Property__Group__5__Impl1970 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__0__Impl_in_rule__Link__Group__02013 = new BitSet(new long[]{0x0000000001400020L});
    public static final BitSet FOLLOW_rule__Link__Group__1_in_rule__Link__Group__02016 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__CommentAssignment_0_in_rule__Link__Group__0__Impl2043 = new BitSet(new long[]{0x0000000000000022L});
    public static final BitSet FOLLOW_rule__Link__Group__1__Impl_in_rule__Link__Group__12074 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Link__Group__2_in_rule__Link__Group__12077 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_24_in_rule__Link__Group__1__Impl2105 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__2__Impl_in_rule__Link__Group__22136 = new BitSet(new long[]{0x0000000000800000L});
    public static final BitSet FOLLOW_rule__Link__Group__3_in_rule__Link__Group__22139 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__NameAssignment_2_in_rule__Link__Group__2__Impl2166 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__3__Impl_in_rule__Link__Group__32196 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Link__Group__4_in_rule__Link__Group__32199 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_23_in_rule__Link__Group__3__Impl2227 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__4__Impl_in_rule__Link__Group__42258 = new BitSet(new long[]{0x0000000070020000L});
    public static final BitSet FOLLOW_rule__Link__Group__5_in_rule__Link__Group__42261 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__TypeAssignment_4_in_rule__Link__Group__4__Impl2288 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__5__Impl_in_rule__Link__Group__52318 = new BitSet(new long[]{0x0000000070020000L});
    public static final BitSet FOLLOW_rule__Link__Group__6_in_rule__Link__Group__52321 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Alternatives_5_in_rule__Link__Group__5__Impl2348 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Link__Group__6__Impl_in_rule__Link__Group__62379 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_rule__Link__Group__6__Impl2407 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Import__Group__0__Impl_in_rule__Import__Group__02452 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__Import__Group__1_in_rule__Import__Group__02455 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_25_in_rule__Import__Group__0__Impl2483 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Import__Group__1__Impl_in_rule__Import__Group__12514 = new BitSet(new long[]{0x0000000000020000L});
    public static final BitSet FOLLOW_rule__Import__Group__2_in_rule__Import__Group__12517 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Import__ImportedNamespaceAssignment_1_in_rule__Import__Group__1__Impl2544 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Import__Group__2__Impl_in_rule__Import__Group__22574 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_17_in_rule__Import__Group__2__Impl2602 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group__0__Impl_in_rule__QualifiedName__Group__02639 = new BitSet(new long[]{0x0000000004000000L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group__1_in_rule__QualifiedName__Group__02642 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_ID_in_rule__QualifiedName__Group__0__Impl2669 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group__1__Impl_in_rule__QualifiedName__Group__12698 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group_1__0_in_rule__QualifiedName__Group__1__Impl2725 = new BitSet(new long[]{0x0000000004000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group_1__0__Impl_in_rule__QualifiedName__Group_1__02760 = new BitSet(new long[]{0x0000000000000010L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group_1__1_in_rule__QualifiedName__Group_1__02763 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_26_in_rule__QualifiedName__Group_1__0__Impl2791 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedName__Group_1__1__Impl_in_rule__QualifiedName__Group_1__12822 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_ID_in_rule__QualifiedName__Group_1__1__Impl2849 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedNameWithWildcard__Group__0__Impl_in_rule__QualifiedNameWithWildcard__Group__02882 = new BitSet(new long[]{0x0000000008000000L});
    public static final BitSet FOLLOW_rule__QualifiedNameWithWildcard__Group__1_in_rule__QualifiedNameWithWildcard__Group__02885 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedName_in_rule__QualifiedNameWithWildcard__Group__0__Impl2912 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__QualifiedNameWithWildcard__Group__1__Impl_in_rule__QualifiedNameWithWildcard__Group__12941 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_27_in_rule__QualifiedNameWithWildcard__Group__1__Impl2970 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedName_in_rule__Model__NameAssignment_13012 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleImport_in_rule__Model__ImportsAssignment_33043 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleEntity_in_rule__Model__ElementsAssignment_43074 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_COMMENT_in_rule__Entity__CommentAssignment_03105 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_ID_in_rule__Entity__NameAssignment_23136 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedName_in_rule__Entity__SuperTypeAssignment_3_13171 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleAttribute_in_rule__Entity__AttributesAssignment_53206 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_COMMENT_in_rule__Property__CommentAssignment_03237 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_ID_in_rule__Property__NameAssignment_23268 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_rule__Property__TypeAlternatives_4_0_in_rule__Property__TypeAssignment_43299 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_COMMENT_in_rule__Link__CommentAssignment_03332 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_RULE_ID_in_rule__Link__NameAssignment_23363 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedName_in_rule__Link__TypeAssignment_43398 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_28_in_rule__Link__AnyAssignment_5_03438 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_29_in_rule__Link__OneOrMoreAssignment_5_13482 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_30_in_rule__Link__ZeroOrOneAssignment_5_23526 = new BitSet(new long[]{0x0000000000000002L});
    public static final BitSet FOLLOW_ruleQualifiedNameWithWildcard_in_rule__Import__ImportedNamespaceAssignment_13565 = new BitSet(new long[]{0x0000000000000002L});

}