/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.verapdf.model.Attribute;
import org.verapdf.model.Entity;
import org.verapdf.model.Import;
import org.verapdf.model.Link;
import org.verapdf.model.Property;

public class ModelGenerator
implements IGenerator {
    private final String HELP_CLASSES_PASS = "org/verapdf/model/";
    private final String HELP_CLASSES_PACKAGE = "org.verapdf.model";
    private final String MODEL_HELPER_NAME = "ModelHelper";
    private final String GENERICMODELOBJECT_NAME = "GenericModelObject";
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;

    public void doGenerate(Resource resource, IFileSystemAccess fsa) {
        TreeIterator _allContents = resource.getAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_allContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, Entity.class);
        for (Entity e : _filter) {
            TreeIterator _allContents_1 = resource.getAllContents();
            Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)_allContents_1);
            Iterable _filter_1 = Iterables.filter((Iterable)_iterable_1, Import.class);
            List imports = IterableExtensions.toList((Iterable)_filter_1);
            QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)e);
            String _string = _fullyQualifiedName.toString("/");
            String _plus = String.valueOf(_string) + ".java";
            CharSequence _compile = this.compile(e, imports);
            fsa.generateFile(_plus, _compile);
            String _name = e.getName();
            boolean _equals = _name.equals("Object");
            if (!_equals) continue;
            CharSequence _generateGenericModelObject = this.generateGenericModelObject(e);
            fsa.generateFile(String.valueOf("org/verapdf/model/") + "GenericModelObject" + ".java", _generateGenericModelObject);
        }
        JavaIoFileSystemAccess fsa1 = (JavaIoFileSystemAccess)fsa;
        try {
            int _lastIndexOf;
            CharSequence is = fsa1.readTextFile(String.valueOf("org/verapdf/model/") + "ModelHelper" + ".java");
            String _string = is.toString();
            int index = _string.lastIndexOf("}");
            String _string_1 = is.toString();
            String _substring = _string_1.substring(0, index);
            index = _lastIndexOf = _substring.lastIndexOf("}");
            String _string_2 = is.toString();
            String _substring_1 = _string_2.substring(0, index);
            CharSequence _appendDependenceClass = this.appendDependenceClass(resource);
            String _plus = String.valueOf(_substring_1) + _appendDependenceClass;
            fsa.generateFile(String.valueOf("org/verapdf/model/") + "ModelHelper" + ".java", (CharSequence)_plus);
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception cfr_ignored_0 = (Exception)_t;
                CharSequence _dependenceClass = this.getDependenceClass(resource);
                fsa.generateFile(String.valueOf("org/verapdf/model/") + "ModelHelper" + ".java", _dependenceClass);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public CharSequence compile(Entity entity, List<Import> imports) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        EObject _eContainer = entity.eContainer();
        QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer);
        boolean bl = _notEquals = !Objects.equal((Object)_fullyQualifiedName, null);
        if (_notEquals) {
            _builder.append((Object)"package ");
            EObject _eContainer_1 = entity.eContainer();
            QualifiedName _fullyQualifiedName_1 = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer_1);
            _builder.append((Object)_fullyQualifiedName_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.newLine();
        }
        for (Import imp : imports) {
            _builder.append((Object)"import ");
            String _importedNamespace = imp.getImportedNamespace();
            _builder.append((Object)_importedNamespace, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        Entity _superType = entity.getSuperType();
        boolean _equals = Objects.equal((Object)_superType, null);
        if (_equals) {
            _builder.append((Object)"import java.util.List;");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        String _comment = entity.getComment();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_comment, null);
        if (_notEquals_1) {
            String _comment_1 = entity.getComment();
            CharSequence _javaDocComment = this.toJavaDocComment(_comment_1);
            _builder.append((Object)_javaDocComment, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"public interface ");
        String _name = entity.getName();
        _builder.append((Object)_name, "");
        Entity _superType_1 = entity.getSuperType();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_superType_1, null);
        if (_notEquals_2) {
            _builder.append((Object)" extends ");
            Entity _superType_2 = entity.getSuperType();
            String _name_1 = _superType_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        Entity _superType_3 = entity.getSuperType();
        boolean _equals_1 = Objects.equal((Object)_superType_3, null);
        if (_equals_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<String> getLinks();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<? extends ");
            String _name_2 = entity.getName();
            _builder.append((Object)_name_2, "\t");
            _builder.append((Object)"> getLinkedObjects(String linkName);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<String> getSuperTypes();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public List<String> getProperties();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String getObjectType();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String getID();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public Boolean isContextDependent();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String getExtraContext();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public String getContext();");
            _builder.newLine();
        }
        EList<Attribute> _attributes = entity.getAttributes();
        for (Attribute attribute : _attributes) {
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateGetter = this.generateGetter(attribute);
            _builder.append((Object)_generateGetter, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetter(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        if (attribute instanceof Property) {
            boolean _notEquals;
            String _comment = ((Property)attribute).getComment();
            boolean bl = _notEquals = !Objects.equal((Object)_comment, null);
            if (_notEquals) {
                String _comment_1 = ((Property)attribute).getComment();
                CharSequence _javaDocComment = this.toJavaDocComment(_comment_1);
                _builder.append((Object)_javaDocComment, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"public ");
            String _type = ((Property)attribute).getType();
            String _javaType = this.toJavaType(_type);
            _builder.append((Object)_javaType, "");
            _builder.append((Object)" get");
            String _name = ((Property)attribute).getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String toJavaType(String type) {
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)type, (Object)"Integer")) {
            _matched = true;
            return "Long";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"Decimal")) {
            _matched = true;
            return "Double";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"String")) {
            _matched = true;
            return "String";
        }
        if (!_matched && Objects.equal((Object)type, (Object)"Boolean")) {
            _matched = true;
            return "Boolean";
        }
        return null;
    }

    public CharSequence toJavaDocComment(String comment) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/** ");
        String _substring = comment.substring(1);
        _builder.append((Object)_substring, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence toInterfaceName(String name) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"I");
        _builder.append((Object)name, "");
        return _builder;
    }

    public CharSequence getDependenceClass(Resource resource) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)"org.verapdf.model", "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"* This class represents names of superinterfaces and names of all properties for all generated interfaces.");
        _builder.newLine();
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"public final class ");
        _builder.append((Object)"ModelHelper", "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static Map<String, String> mapOfSuperNames = new HashMap<String, String>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static Map<String, List<String>> mapOfProperties = new HashMap<String, List<String>>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final static Map<String, List<String>> mapOfLinks = new HashMap<String, List<String>>();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static List<String> properties;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private static List<String> links;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private ModelHelper(){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @param objectName - the name of the object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of supernames for the given object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static List<String> getListOfSuperNames(String objectName){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<String> res = new ArrayList<String>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String currentObject = mapOfSuperNames.get(objectName);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while(currentObject != null){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"res.add(currentObject);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"currentObject = mapOfSuperNames.get(currentObject);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return res;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return Set of all type names");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static Set<String> getTypes(){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return mapOfSuperNames.keySet();");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @param objectName - the name of the object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of names of properties for the given object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static List<String> getListOfProperties(String objectName){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<String> res = new ArrayList<String>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String currentObject = objectName;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while(currentObject != null){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"for(String prop : mapOfProperties.get(currentObject)){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"res.add(prop);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"currentObject = mapOfSuperNames.get(currentObject);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return res;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @param objectName - the name of the object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of names of links for the given object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public static List<String> getListOfLinks(String objectName){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"List<String> res = new ArrayList<String>();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"String currentObject = objectName;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while(currentObject != null){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"for(String link : mapOfLinks.get(currentObject)){");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"res.add(link);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"currentObject = mapOfSuperNames.get(currentObject);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return res;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"static {");
        _builder.newLine();
        CharSequence _appendDependenceClass = this.appendDependenceClass(resource);
        _builder.append((Object)_appendDependenceClass, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence appendDependenceClass(Resource resource) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.newLine();
        TreeIterator _allContents = resource.getAllContents();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)_allContents);
        Iterable _filter = Iterables.filter((Iterable)_iterable, Entity.class);
        for (Entity e : _filter) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"mapOfSuperNames.put(\"");
            String _name = e.getName();
            _builder.append((Object)_name, "\t\t");
            _builder.append((Object)"\",");
            Entity _superType = e.getSuperType();
            boolean _equals = Objects.equal((Object)_superType, null);
            if (_equals) {
                _builder.append((Object)"null");
            } else {
                _builder.append((Object)"\"");
                Entity _superType_1 = e.getSuperType();
                String _name_1 = _superType_1.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)"\"");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        TreeIterator _allContents_1 = resource.getAllContents();
        Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)_allContents_1);
        Iterable _filter_1 = Iterables.filter((Iterable)_iterable_1, Entity.class);
        for (Entity e_1 : _filter_1) {
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"properties = new ArrayList<String>();");
            _builder.newLine();
            EList<Attribute> _attributes = e_1.getAttributes();
            for (Attribute prop : _attributes) {
                if (!(prop instanceof Property)) continue;
                _builder.append((Object)"\t\t");
                _builder.append((Object)"properties.add(\"");
                String _name_2 = ((Property)prop).getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"mapOfProperties.put(\"");
            String _name_3 = e_1.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)"\",properties);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        TreeIterator _allContents_2 = resource.getAllContents();
        Iterable _iterable_2 = IteratorExtensions.toIterable((Iterator)_allContents_2);
        Iterable _filter_2 = Iterables.filter((Iterable)_iterable_2, Entity.class);
        for (Entity e_2 : _filter_2) {
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"links = new ArrayList<String>();");
            _builder.newLine();
            EList<Attribute> _attributes_1 = e_2.getAttributes();
            for (Attribute link : _attributes_1) {
                if (!(link instanceof Link)) continue;
                _builder.append((Object)"\t\t");
                _builder.append((Object)"links.add(\"");
                String _name_4 = ((Link)link).getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"mapOfLinks.put(\"");
            String _name_5 = e_2.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)"\",links);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGenericModelObject(Entity e) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        _builder.append((Object)"org.verapdf.model", "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import ");
        EObject _eContainer = e.eContainer();
        QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName(_eContainer);
        _builder.append((Object)_fullyQualifiedName, "");
        _builder.append((Object)".");
        String _name = e.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import java.util.*;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public abstract class ");
        _builder.append((Object)"GenericModelObject", "");
        _builder.append((Object)" implements ");
        String _name_1 = e.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected Boolean contextDependent = false;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private final String objectType;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected ");
        _builder.append((Object)"GenericModelObject", "\t");
        _builder.append((Object)"(String objectType) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.objectType = objectType;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return type of the current object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public final String getObjectType() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return this.objectType;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return id of the current object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getID() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return extra context of the current object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getExtraContext() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return context of the current object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public String getContext() {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @param link - the name of a link");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of objects with the given link");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<? extends Object> getLinkedObjects(String link) {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"throw new IllegalAccessError(this.getObjectType() + \" has not access to this method or has not \" + link + \" link.\");");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of names of links for {@code this} object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public List<String> getLinks() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return ModelHelper.getListOfLinks(this.getObjectType());");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of names of properties for {@code this} object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public List<String> getProperties() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return ModelHelper.getListOfProperties(this.getObjectType());");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return null, if we have not know yet is this object context dependet of not. true, if this object is context dependent. false, if this object is not context dependent.");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public Boolean isContextDependent() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return contextDependent;");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"* @return List of supernames for {@code this} object");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"public List<String> getSuperTypes() {");
        _builder.newLine();
        _builder.append((Object)"        ");
        _builder.append((Object)"return ModelHelper.getListOfSuperNames(this.getObjectType());");
        _builder.newLine();
        _builder.append((Object)"    ");
        _builder.append((Object)"}");
        _builder.newLine();
        EList<Attribute> _attributes = e.getAttributes();
        for (Attribute attribute : _attributes) {
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateGetterForCenericModelObject = this.generateGetterForCenericModelObject(attribute);
            _builder.append((Object)_generateGetterForCenericModelObject, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateGetterForCenericModelObject(Attribute attribute) {
        StringConcatenation _builder = new StringConcatenation();
        if (attribute instanceof Property) {
            boolean _notEquals;
            String _comment = ((Property)attribute).getComment();
            boolean bl = _notEquals = !Objects.equal((Object)_comment, null);
            if (_notEquals) {
                String _comment_1 = ((Property)attribute).getComment();
                CharSequence _javaDocComment = this.toJavaDocComment(_comment_1);
                _builder.append((Object)_javaDocComment, "");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"public abstract ");
            String _type = ((Property)attribute).getType();
            _builder.append((Object)_type, "");
            _builder.append((Object)" get");
            String _name = ((Property)attribute).getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

