/*
 * This file is part of veraPDF Parser, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Parser is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Parser as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Parser as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.pd.font.truetype;

import java.util.HashMap;
import java.util.Map;

/**
 * This class contains predefined encodings for True Type.
 *
 * @author Sergey Shemyakov
 */
public class TrueTypePredefined {

    public static final String MAC_EXPERT_ENCODING_STRING = "MacExpertEncoding";
    public static final String NOTDEF_STRING = ".notdef";

    public static final String[] MAC_ROMAN_ENCODING = {
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quotesingle",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "grave",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            ".notdef",
            "Adieresis",
            "Aring",
            "Ccedilla",
            "Eacute",
            "Ntilde",
            "Odieresis",
            "Udieresis",
            "aacute",
            "agrave",
            "acircumflex",
            "adieresis",
            "atilde",
            "aring",
            "ccedilla",
            "eacute",
            "egrave",
            "ecircumflex",
            "edieresis",
            "iacute",
            "igrave",
            "icircumflex",
            "idieresis",
            "ntilde",
            "oacute",
            "ograve",
            "ocircumflex",
            "odieresis",
            "otilde",
            "uacute",
            "ugrave",
            "ucircumflex",
            "udieresis",
            "dagger",
            "degree",
            "cent",
            "sterling",
            "section",
            "bullet",
            "paragraph",
            "germandbls",
            "registered",
            "copyright",
            "trademark",
            "acute",
            "dieresis",
            ".notdef",
            "AE",
            "Oslash",
            ".notdef",
            "plusminus",
            ".notdef",
            ".notdef",
            "yen",
            "mu",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "ordfeminine",
            "ordmasculine",
            ".notdef",
            "ae",
            "oslash",
            "questiondown",
            "exclamdown",
            "logicalnot",
            ".notdef",
            "florin",
            ".notdef",
            ".notdef",
            "guillemotleft",
            "guillemotright",
            "ellipsis",
            "space",
            "Agrave",
            "Atilde",
            "Otilde",
            "OE",
            "oe",
            "endash",
            "emdash",
            "quotedblleft",
            "quotedblright",
            "quoteleft",
            "quoteright",
            "divide",
            ".notdef",
            "ydieresis",
            "Ydieresis",
            "fraction",
            "currency",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            "daggerdbl",
            "periodcentered",
            "quotesinglbase",
            "quotedblbase",
            "perthousand",
            "Acircumflex",
            "Ecircumflex",
            "Aacute",
            "Edieresis",
            "Egrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Igrave",
            "Oacute",
            "Ocircumflex",
            ".notdef",
            "Ograve",
            "Uacute",
            "Ucircumflex",
            "Ugrave",
            "dotlessi",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "ring",
            "cedilla",
            "hungarumlaut",
            "ogonek",
            "caron"
    };

    public static final String[] WIN_ANSI_ENCODING = {
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quotesingle",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "grave",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "bullet",
            "Euro",
            "bullet",
            "quotesinglbase",
            "florin",
            "quotedblbase",
            "ellipsis",
            "dagger",
            "daggerdbl",
            "circumflex",
            "perthousand",
            "Scaron",
            "guilsinglleft",
            "OE",
            "bullet",
            "Zcaron",
            "bullet",
            "bullet",
            "quoteleft",
            "quoteright",
            "quotedblleft",
            "quotedblright",
            "bullet",
            "endash",
            "emdash",
            "tilde",
            "trademark",
            "scaron",
            "guilsinglright",
            "oe",
            "bullet",
            "zcaron",
            "Ydieresis",
            "space",
            "exclamdown",
            "cent",
            "sterling",
            "currency",
            "yen",
            "brokenbar",
            "section",
            "dieresis",
            "copyright",
            "ordfeminine",
            "guillemotleft",
            "logicalnot",
            "hyphen",
            "registered",
            "macron",
            "degree",
            "plusminus",
            "twosuperior",
            "threesuperior",
            "acute",
            "mu",
            "paragraph",
            "periodcentered",
            "cedilla",
            "onesuperior",
            "ordmasculine",
            "guillemotright",
            "onequarter",
            "onehalf",
            "threequarters",
            "questiondown",
            "Agrave",
            "Aacute",
            "Acircumflex",
            "Atilde",
            "Adieresis",
            "Aring",
            "AE",
            "Ccedilla",
            "Egrave",
            "Eacute",
            "Ecircumflex",
            "Edieresis",
            "Igrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Eth",
            "Ntilde",
            "Ograve",
            "Oacute",
            "Ocircumflex",
            "Otilde",
            "Odieresis",
            "multiply",
            "Oslash",
            "Ugrave",
            "Uacute",
            "Ucircumflex",
            "Udieresis",
            "Yacute",
            "Thorn",
            "germandbls",
            "agrave",
            "aacute",
            "acircumflex",
            "atilde",
            "adieresis",
            "aring",
            "ae",
            "ccedilla",
            "egrave",
            "eacute",
            "ecircumflex",
            "edieresis",
            "igrave",
            "iacute",
            "icircumflex",
            "idieresis",
            "eth",
            "ntilde",
            "ograve",
            "oacute",
            "ocircumflex",
            "otilde",
            "odieresis",
            "divide",
            "oslash",
            "ugrave",
            "uacute",
            "ucircumflex",
            "udieresis",
            "yacute",
            "thorn",
            "ydieresis"
    };

    public static final String[] STANDARD_ENCODING = {
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quoteright",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "quoteleft",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "exclamdown",
            "cent",
            "sterling",
            "fraction",
            "yen",
            "florin",
            "section",
            "currency",
            "quotesingle",
            "quotedblleft",
            "guillemotleft",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fl",
            ".notdef",
            "endash",
            "dagger",
            "daggerdbl",
            "periodcentered",
            ".notdef",
            "paragraph",
            "bullet",
            "quotesinglbase",
            "quotedblbase",
            "quotedblright",
            "guillemotright",
            "ellipsis",
            "perthousand",
            ".notdef",
            "questiondown",
            ".notdef",
            "grave",
            "acute",
            "circumflex",
            "tilde",
            "macron",
            "breve",
            "dotaccent",
            "dieresis",
            ".notdef",
            "ring",
            "cedilla",
            ".notdef",
            "hungarumlaut",
            "ogonek",
            "caron",
            "emdash",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "AE",
            ".notdef",
            "ordfeminine",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "Lslash",
            "Oslash",
            "OE",
            "ordmasculine",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "ae",
            ".notdef",
            ".notdef",
            ".notdef",
            "dotlessi",
            ".notdef",
            ".notdef",
            "lslash",
            "oslash",
            "oe",
            "germandbls",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef"
    };

    public static final String[] MAC_EXPERT_ENCODING = {
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "space",
            "exclamsmall",
            "Hungarumlautsmall",
            "centoldstyle",
            "dollaroldstyle",
            "dollarsuperior",
            "ampersandsmall",
            "Acutesmall",
            "parenleftsuperior",
            "parenrightsuperior",
            "twodotenleader",
            "onedotenleader",
            "comma",
            "hyphen",
            "period",
            "fraction",
            "zerooldstyle",
            "oneoldstyle",
            "twooldstyle",
            "threeoldstyle",
            "fouroldstyle",
            "fiveoldstyle",
            "sixoldstyle",
            "sevenoldstyle",
            "eightoldstyle",
            "nineoldstyle",
            "colon",
            "semicolon",
            ".notdef",
            "threequartersemdash",
            ".notdef",
            "questionsmall",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "Ethsmall",
            ".notdef",
            ".notdef",
            "onequarter",
            "onehalf",
            "threequarters",
            "oneeighth",
            "threeeighths",
            "fiveeighths",
            "seveneighths",
            "onethird",
            "twothirds",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "ff",
            "fi",
            "fl",
            "ffi",
            "ffl",
            "parenleftinferior",
            ".notdef",
            "parenrightinferior",
            "Circumflexsmall",
            "hypheninferior",
            "Gravesmall",
            "Asmall",
            "Bsmall",
            "Csmall",
            "Dsmall",
            "Esmall",
            "Fsmall",
            "Gsmall",
            "Hsmall",
            "Ismall",
            "Jsmall",
            "Ksmall",
            "Lsmall",
            "Msmall",
            "Nsmall",
            "Osmall",
            "Psmall",
            "Qsmall",
            "Rsmall",
            "Ssmall",
            "Tsmall",
            "Usmall",
            "Vsmall",
            "Wsmall",
            "Xsmall",
            "Ysmall",
            "Zsmall",
            "colonmonetary",
            "onefitted",
            "rupiah",
            "Tildesmall",
            ".notdef",
            ".notdef",
            "asuperior",
            "centsuperior",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "Aacutesmall",
            "Agravesmall",
            "Acircumflexsmall",
            "Adieresissmall",
            "Atildesmall",
            "Aringsmall",
            "Ccedillasmall",
            "Eacutesmall",
            "Egravesmall",
            "Ecircumflexsmall",
            "Edieresissmall",
            "Iacutesmall",
            "Igravesmall",
            "Icircumflexsmall",
            "Idieresissmall",
            "Ntildesmall",
            "Oacutesmall",
            "Ogravesmall",
            "Ocircumflexsmall",
            "Odieresissmall",
            "Otildesmall",
            "Uacutesmall",
            "Ugravesmall",
            "Ucircumflexsmall",
            "Udieresissmall",
            ".notdef",
            "eightsuperior",
            "fourinferior",
            "threeinferior",
            "sixinferior",
            "eightinferior",
            "seveninferior",
            "Scaronsmall",
            ".notdef",
            "centinferior",
            "twoinferior",
            ".notdef",
            "Dieresissmall",
            ".notdef",
            "Caronsmall",
            "osuperior",
            "fiveinferior",
            ".notdef",
            "commainferior",
            "periodinferior",
            "Yacutesmall",
            ".notdef",
            "dollarinferior",
            ".notdef",
            ".notdef",
            "Thornsmall",
            ".notdef",
            "nineinferior",
            "zeroinferior",
            "Zcaronsmall",
            "AEsmall",
            "Oslashsmall",
            "questiondownsmall",
            "oneinferior",
            "Lslashsmall",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "Cedillasmall",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "OEsmall",
            "figuredash",
            "hyphensuperior",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "exclamdownsmall",
            ".notdef",
            "Ydieresissmall",
            ".notdef",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "foursuperior",
            "fivesuperior",
            "sixsuperior",
            "sevensuperior",
            "ninesuperior",
            "zerosuperior",
            ".notdef",
            "esuperior",
            "rsuperior",
            "tsuperior",
            ".notdef",
            ".notdef",
            "isuperior",
            "ssuperior",
            "dsuperior",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef",
            "lsuperior",
            "Ogoneksmall",
            "Brevesmall",
            "Macronsmall",
            "bsuperior",
            "nsuperior",
            "msuperior",
            "commasuperior",
            "periodsuperior",
            "Dotaccentsmall",
            "Ringsmall",
            ".notdef",
            ".notdef",
            ".notdef",
            ".notdef"
    };

    public static final Map<String, Integer> MAC_OS_ROMAN_ENCODING_MAP =
            new HashMap<>();

    static {
        MAC_OS_ROMAN_ENCODING_MAP.put("A", 65);
        MAC_OS_ROMAN_ENCODING_MAP.put("AE", 174);
        MAC_OS_ROMAN_ENCODING_MAP.put("Aacute", 231);
        MAC_OS_ROMAN_ENCODING_MAP.put("Acircumflex", 229);
        MAC_OS_ROMAN_ENCODING_MAP.put("Adieresis", 128);
        MAC_OS_ROMAN_ENCODING_MAP.put("Agrave", 203);
        MAC_OS_ROMAN_ENCODING_MAP.put("Aring", 129);
        MAC_OS_ROMAN_ENCODING_MAP.put("Atilde", 204);
        MAC_OS_ROMAN_ENCODING_MAP.put("B", 66);
        MAC_OS_ROMAN_ENCODING_MAP.put("C", 67);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ccedilla", 130);
        MAC_OS_ROMAN_ENCODING_MAP.put("D", 68);
        MAC_OS_ROMAN_ENCODING_MAP.put("E", 69);
        MAC_OS_ROMAN_ENCODING_MAP.put("Eacute", 131);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ecircumflex", 230);
        MAC_OS_ROMAN_ENCODING_MAP.put("Edieresis", 232);
        MAC_OS_ROMAN_ENCODING_MAP.put("Egrave", 233);
        MAC_OS_ROMAN_ENCODING_MAP.put("F", 70);
        MAC_OS_ROMAN_ENCODING_MAP.put("G", 71);
        MAC_OS_ROMAN_ENCODING_MAP.put("H", 72);
        MAC_OS_ROMAN_ENCODING_MAP.put("I", 73);
        MAC_OS_ROMAN_ENCODING_MAP.put("Iacute", 234);
        MAC_OS_ROMAN_ENCODING_MAP.put("Icircumflex", 235);
        MAC_OS_ROMAN_ENCODING_MAP.put("Idieresis", 236);
        MAC_OS_ROMAN_ENCODING_MAP.put("Igrave", 237);
        MAC_OS_ROMAN_ENCODING_MAP.put("J", 74);
        MAC_OS_ROMAN_ENCODING_MAP.put("K", 75);
        MAC_OS_ROMAN_ENCODING_MAP.put("L", 76);
        MAC_OS_ROMAN_ENCODING_MAP.put("M", 77);
        MAC_OS_ROMAN_ENCODING_MAP.put("N", 78);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ntilde", 132);
        MAC_OS_ROMAN_ENCODING_MAP.put("O", 79);
        MAC_OS_ROMAN_ENCODING_MAP.put("OE", 206);
        MAC_OS_ROMAN_ENCODING_MAP.put("Oacute", 238);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ocircumflex", 239);
        MAC_OS_ROMAN_ENCODING_MAP.put("Odieresis", 133);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ograve", 241);
        MAC_OS_ROMAN_ENCODING_MAP.put("Oslash", 175);
        MAC_OS_ROMAN_ENCODING_MAP.put("Otilde", 205);
        MAC_OS_ROMAN_ENCODING_MAP.put("P", 80);
        MAC_OS_ROMAN_ENCODING_MAP.put("Q", 81);
        MAC_OS_ROMAN_ENCODING_MAP.put("R", 82);
        MAC_OS_ROMAN_ENCODING_MAP.put("S", 83);
        MAC_OS_ROMAN_ENCODING_MAP.put("T", 84);
        MAC_OS_ROMAN_ENCODING_MAP.put("U", 85);
        MAC_OS_ROMAN_ENCODING_MAP.put("Uacute", 242);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ucircumflex", 243);
        MAC_OS_ROMAN_ENCODING_MAP.put("Udieresis", 134);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ugrave", 244);
        MAC_OS_ROMAN_ENCODING_MAP.put("V", 86);
        MAC_OS_ROMAN_ENCODING_MAP.put("W", 87);
        MAC_OS_ROMAN_ENCODING_MAP.put("X", 88);
        MAC_OS_ROMAN_ENCODING_MAP.put("Y", 89);
        MAC_OS_ROMAN_ENCODING_MAP.put("Ydieresis", 217);
        MAC_OS_ROMAN_ENCODING_MAP.put("Z", 90);
        MAC_OS_ROMAN_ENCODING_MAP.put("a", 97);
        MAC_OS_ROMAN_ENCODING_MAP.put("aacute", 135);
        MAC_OS_ROMAN_ENCODING_MAP.put("acircumflex", 137);
        MAC_OS_ROMAN_ENCODING_MAP.put("acute", 171);
        MAC_OS_ROMAN_ENCODING_MAP.put("adieresis", 138);
        MAC_OS_ROMAN_ENCODING_MAP.put("ae", 190);
        MAC_OS_ROMAN_ENCODING_MAP.put("agrave", 136);
        MAC_OS_ROMAN_ENCODING_MAP.put("ampersand", 38);
        MAC_OS_ROMAN_ENCODING_MAP.put("aring", 140);
        MAC_OS_ROMAN_ENCODING_MAP.put("asciicircum", 94);
        MAC_OS_ROMAN_ENCODING_MAP.put("asciitilde", 126);
        MAC_OS_ROMAN_ENCODING_MAP.put("asterisk", 42);
        MAC_OS_ROMAN_ENCODING_MAP.put("at", 64);
        MAC_OS_ROMAN_ENCODING_MAP.put("atilde", 139);
        MAC_OS_ROMAN_ENCODING_MAP.put("b", 98);
        MAC_OS_ROMAN_ENCODING_MAP.put("backslash", 92);
        MAC_OS_ROMAN_ENCODING_MAP.put("bar", 124);
        MAC_OS_ROMAN_ENCODING_MAP.put("braceleft", 123);
        MAC_OS_ROMAN_ENCODING_MAP.put("braceright", 125);
        MAC_OS_ROMAN_ENCODING_MAP.put("bracketleft", 91);
        MAC_OS_ROMAN_ENCODING_MAP.put("bracketright", 93);
        MAC_OS_ROMAN_ENCODING_MAP.put("breve", 249);
        MAC_OS_ROMAN_ENCODING_MAP.put("bullet", 165);
        MAC_OS_ROMAN_ENCODING_MAP.put("c", 99);
        MAC_OS_ROMAN_ENCODING_MAP.put("caron", 255);
        MAC_OS_ROMAN_ENCODING_MAP.put("ccedilla", 141);
        MAC_OS_ROMAN_ENCODING_MAP.put("cedilla", 252);
        MAC_OS_ROMAN_ENCODING_MAP.put("cent", 162);
        MAC_OS_ROMAN_ENCODING_MAP.put("circumflex", 246);
        MAC_OS_ROMAN_ENCODING_MAP.put("colon", 58);
        MAC_OS_ROMAN_ENCODING_MAP.put("comma", 44);
        MAC_OS_ROMAN_ENCODING_MAP.put("copyright", 169);
        MAC_OS_ROMAN_ENCODING_MAP.put("currency", 219);
        MAC_OS_ROMAN_ENCODING_MAP.put("d", 100);
        MAC_OS_ROMAN_ENCODING_MAP.put("dagger", 160);
        MAC_OS_ROMAN_ENCODING_MAP.put("daggerdbl", 224);
        MAC_OS_ROMAN_ENCODING_MAP.put("degree", 161);
        MAC_OS_ROMAN_ENCODING_MAP.put("dieresis", 172);
        MAC_OS_ROMAN_ENCODING_MAP.put("divide", 214);
        MAC_OS_ROMAN_ENCODING_MAP.put("dollar", 36);
        MAC_OS_ROMAN_ENCODING_MAP.put("dotaccent", 250);
        MAC_OS_ROMAN_ENCODING_MAP.put("dotlessi", 245);
        MAC_OS_ROMAN_ENCODING_MAP.put("e", 101);
        MAC_OS_ROMAN_ENCODING_MAP.put("eacute", 142);
        MAC_OS_ROMAN_ENCODING_MAP.put("ecircumflex", 144);
        MAC_OS_ROMAN_ENCODING_MAP.put("edieresis", 145);
        MAC_OS_ROMAN_ENCODING_MAP.put("egrave", 143);
        MAC_OS_ROMAN_ENCODING_MAP.put("eight", 56);
        MAC_OS_ROMAN_ENCODING_MAP.put("ellipsis", 201);
        MAC_OS_ROMAN_ENCODING_MAP.put("emdash", 209);
        MAC_OS_ROMAN_ENCODING_MAP.put("endash", 208);
        MAC_OS_ROMAN_ENCODING_MAP.put("equal", 61);
        MAC_OS_ROMAN_ENCODING_MAP.put("exclam", 33);
        MAC_OS_ROMAN_ENCODING_MAP.put("exclamdown", 193);
        MAC_OS_ROMAN_ENCODING_MAP.put("f", 102);
        MAC_OS_ROMAN_ENCODING_MAP.put("fi", 222);
        MAC_OS_ROMAN_ENCODING_MAP.put("five", 53);
        MAC_OS_ROMAN_ENCODING_MAP.put("fl", 223);
        MAC_OS_ROMAN_ENCODING_MAP.put("florin", 196);
        MAC_OS_ROMAN_ENCODING_MAP.put("four", 52);
        MAC_OS_ROMAN_ENCODING_MAP.put("fraction", 218);
        MAC_OS_ROMAN_ENCODING_MAP.put("g", 103);
        MAC_OS_ROMAN_ENCODING_MAP.put("germandbls", 167);
        MAC_OS_ROMAN_ENCODING_MAP.put("grave", 96);
        MAC_OS_ROMAN_ENCODING_MAP.put("greater", 62);
        MAC_OS_ROMAN_ENCODING_MAP.put("guillemotleft", 199);
        MAC_OS_ROMAN_ENCODING_MAP.put("guillemotright", 200);
        MAC_OS_ROMAN_ENCODING_MAP.put("guilsinglleft", 220);
        MAC_OS_ROMAN_ENCODING_MAP.put("guilsinglright", 221);
        MAC_OS_ROMAN_ENCODING_MAP.put("h", 104);
        MAC_OS_ROMAN_ENCODING_MAP.put("hungarumlaut", 253);
        MAC_OS_ROMAN_ENCODING_MAP.put("hyphen", 45);
        MAC_OS_ROMAN_ENCODING_MAP.put("i", 105);
        MAC_OS_ROMAN_ENCODING_MAP.put("iacute", 146);
        MAC_OS_ROMAN_ENCODING_MAP.put("icircumflex", 148);
        MAC_OS_ROMAN_ENCODING_MAP.put("idieresis", 149);
        MAC_OS_ROMAN_ENCODING_MAP.put("igrave", 147);
        MAC_OS_ROMAN_ENCODING_MAP.put("j", 106);
        MAC_OS_ROMAN_ENCODING_MAP.put("k", 107);
        MAC_OS_ROMAN_ENCODING_MAP.put("l", 108);
        MAC_OS_ROMAN_ENCODING_MAP.put("less", 60);
        MAC_OS_ROMAN_ENCODING_MAP.put("logicalnot", 194);
        MAC_OS_ROMAN_ENCODING_MAP.put("m", 109);
        MAC_OS_ROMAN_ENCODING_MAP.put("macron", 248);
        MAC_OS_ROMAN_ENCODING_MAP.put("mu", 181);
        MAC_OS_ROMAN_ENCODING_MAP.put("n", 110);
        MAC_OS_ROMAN_ENCODING_MAP.put("nine", 57);
        MAC_OS_ROMAN_ENCODING_MAP.put("ntilde", 150);
        MAC_OS_ROMAN_ENCODING_MAP.put("numbersign", 35);
        MAC_OS_ROMAN_ENCODING_MAP.put("o", 111);
        MAC_OS_ROMAN_ENCODING_MAP.put("oacute", 151);
        MAC_OS_ROMAN_ENCODING_MAP.put("ocircumflex", 153);
        MAC_OS_ROMAN_ENCODING_MAP.put("odieresis", 154);
        MAC_OS_ROMAN_ENCODING_MAP.put("oe", 207);
        MAC_OS_ROMAN_ENCODING_MAP.put("ogonek", 254);
        MAC_OS_ROMAN_ENCODING_MAP.put("ograve", 152);
        MAC_OS_ROMAN_ENCODING_MAP.put("one", 49);
        MAC_OS_ROMAN_ENCODING_MAP.put("ordfeminine", 187);
        MAC_OS_ROMAN_ENCODING_MAP.put("ordmasculine", 188);
        MAC_OS_ROMAN_ENCODING_MAP.put("oslash", 191);
        MAC_OS_ROMAN_ENCODING_MAP.put("otilde", 155);
        MAC_OS_ROMAN_ENCODING_MAP.put("p", 112);
        MAC_OS_ROMAN_ENCODING_MAP.put("paragraph", 166);
        MAC_OS_ROMAN_ENCODING_MAP.put("parenleft", 40);
        MAC_OS_ROMAN_ENCODING_MAP.put("parenright", 41);
        MAC_OS_ROMAN_ENCODING_MAP.put("percent", 37);
        MAC_OS_ROMAN_ENCODING_MAP.put("period", 46);
        MAC_OS_ROMAN_ENCODING_MAP.put("periodcentered", 225);
        MAC_OS_ROMAN_ENCODING_MAP.put("perthousand", 228);
        MAC_OS_ROMAN_ENCODING_MAP.put("plus", 43);
        MAC_OS_ROMAN_ENCODING_MAP.put("plusminus", 177);
        MAC_OS_ROMAN_ENCODING_MAP.put("q", 113);
        MAC_OS_ROMAN_ENCODING_MAP.put("question", 63);
        MAC_OS_ROMAN_ENCODING_MAP.put("questiondown", 192);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotedbl", 34);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotedblbase", 227);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotedblleft", 210);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotedblright", 211);
        MAC_OS_ROMAN_ENCODING_MAP.put("quoteleft", 212);
        MAC_OS_ROMAN_ENCODING_MAP.put("quoteright", 213);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotesinglbase", 226);
        MAC_OS_ROMAN_ENCODING_MAP.put("quotesingle", 39);
        MAC_OS_ROMAN_ENCODING_MAP.put("r", 114);
        MAC_OS_ROMAN_ENCODING_MAP.put("registered", 168);
        MAC_OS_ROMAN_ENCODING_MAP.put("ring", 251);
        MAC_OS_ROMAN_ENCODING_MAP.put("s", 115);
        MAC_OS_ROMAN_ENCODING_MAP.put("section", 164);
        MAC_OS_ROMAN_ENCODING_MAP.put("semicolon", 59);
        MAC_OS_ROMAN_ENCODING_MAP.put("seven", 55);
        MAC_OS_ROMAN_ENCODING_MAP.put("six", 54);
        MAC_OS_ROMAN_ENCODING_MAP.put("slash", 47);
        MAC_OS_ROMAN_ENCODING_MAP.put("space", 32);
        MAC_OS_ROMAN_ENCODING_MAP.put("sterling", 163);
        MAC_OS_ROMAN_ENCODING_MAP.put("t", 116);
        MAC_OS_ROMAN_ENCODING_MAP.put("three", 51);
        MAC_OS_ROMAN_ENCODING_MAP.put("tilde", 247);
        MAC_OS_ROMAN_ENCODING_MAP.put("trademark", 170);
        MAC_OS_ROMAN_ENCODING_MAP.put("two", 50);
        MAC_OS_ROMAN_ENCODING_MAP.put("u", 117);
        MAC_OS_ROMAN_ENCODING_MAP.put("uacute", 156);
        MAC_OS_ROMAN_ENCODING_MAP.put("ucircumflex", 158);
        MAC_OS_ROMAN_ENCODING_MAP.put("udieresis", 159);
        MAC_OS_ROMAN_ENCODING_MAP.put("ugrave", 157);
        MAC_OS_ROMAN_ENCODING_MAP.put("underscore", 95);
        MAC_OS_ROMAN_ENCODING_MAP.put("v", 118);
        MAC_OS_ROMAN_ENCODING_MAP.put("w", 119);
        MAC_OS_ROMAN_ENCODING_MAP.put("x", 120);
        MAC_OS_ROMAN_ENCODING_MAP.put("y", 121);
        MAC_OS_ROMAN_ENCODING_MAP.put("ydieresis", 216);
        MAC_OS_ROMAN_ENCODING_MAP.put("yen", 180);
        MAC_OS_ROMAN_ENCODING_MAP.put("z", 122);
        MAC_OS_ROMAN_ENCODING_MAP.put("zero", 48);
        MAC_OS_ROMAN_ENCODING_MAP.put("notequal", 173);
        MAC_OS_ROMAN_ENCODING_MAP.put("infinity", 176);
        MAC_OS_ROMAN_ENCODING_MAP.put("lessequal", 178);
        MAC_OS_ROMAN_ENCODING_MAP.put("greaterequal", 179);
        MAC_OS_ROMAN_ENCODING_MAP.put("partialdiff", 182);
        MAC_OS_ROMAN_ENCODING_MAP.put("summation", 183);
        MAC_OS_ROMAN_ENCODING_MAP.put("product", 184);
        MAC_OS_ROMAN_ENCODING_MAP.put("pi", 185);
        MAC_OS_ROMAN_ENCODING_MAP.put("integral", 186);
        MAC_OS_ROMAN_ENCODING_MAP.put("Omega", 189);
        MAC_OS_ROMAN_ENCODING_MAP.put("radical", 195);
        MAC_OS_ROMAN_ENCODING_MAP.put("approxequal", 197);
        MAC_OS_ROMAN_ENCODING_MAP.put("Delta", 198);
        MAC_OS_ROMAN_ENCODING_MAP.put("lozenge", 215);
        MAC_OS_ROMAN_ENCODING_MAP.put("apple", 240);
    }

    public static final String[] MAC_INDEX_TO_GLYPH_NAME = {
            "notdef",
            ".null",
            "CR",
            "space",
            "exclam",
            "quotedbl",
            "numbersign",
            "dollar",
            "percent",
            "ampersand",
            "quotesingle",
            "parenleft",
            "parenright",
            "asterisk",
            "plus",
            "comma",
            "hyphen",
            "period",
            "slash",
            "zero",
            "one",
            "two",
            "three",
            "four",
            "five",
            "six",
            "seven",
            "eight",
            "nine",
            "colon",
            "semicolon",
            "less",
            "equal",
            "greater",
            "question",
            "at",
            "A",
            "B",
            "C",
            "D",
            "E",
            "F",
            "G",
            "H",
            "I",
            "J",
            "K",
            "L",
            "M",
            "N",
            "O",
            "P",
            "Q",
            "R",
            "S",
            "T",
            "U",
            "V",
            "W",
            "X",
            "Y",
            "Z",
            "bracketleft",
            "backslash",
            "bracketright",
            "asciicircum",
            "underscore",
            "grave",
            "a",
            "b",
            "c",
            "d",
            "e",
            "f",
            "g",
            "h",
            "i",
            "j",
            "k",
            "l",
            "m",
            "n",
            "o",
            "p",
            "q",
            "r",
            "s",
            "t",
            "u",
            "v",
            "w",
            "x",
            "y",
            "z",
            "braceleft",
            "bar",
            "braceright",
            "asciitilde",
            "Adieresis",
            "Aring",
            "Ccedilla",
            "Eacute",
            "Ntilde",
            "Odieresis",
            "Udieresis",
            "aacute",
            "agrave",
            "acircumflex",
            "adieresis",
            "atilde",
            "aring",
            "ccedilla",
            "eacute",
            "egrave",
            "ecircumflex",
            "edieresis",
            "iacute",
            "igrave",
            "icircumflex",
            "idieresis",
            "ntilde",
            "oacute",
            "ograve",
            "ocircumflex",
            "odieresis",
            "otilde",
            "uacute",
            "ugrave",
            "ucircumflex",
            "udieresis",
            "dagger",
            "degree",
            "cent",
            "sterling",
            "section",
            "bullet",
            "paragraph",
            "germandbls",
            "registered",
            "copyright",
            "trademark",
            "acute",
            "dieresis",
            "notequal",
            "AE",
            "Oslash",
            "infinity",
            "plusminus",
            "lessequal",
            "greaterequal",
            "yen",
            "mu1",
            "partialdiff",
            "summation",
            "product",
            "pi",
            "integral",
            "ordfeminine",
            "ordmasculine",
            "Ohm",
            "ae",
            "oslash",
            "questiondown",
            "exclamdown",
            "logicalnot",
            "radical",
            "florin",
            "approxequal",
            "increment",
            "guillemotleft",
            "guillemotright",
            "ellipsis",
            "nbspace",
            "Agrave",
            "Atilde",
            "Otilde",
            "OE",
            "oe",
            "endash",
            "emdash",
            "quotedblleft",
            "quotedblright",
            "quoteleft",
            "quoteright",
            "divide",
            "lozenge",
            "ydieresis",
            "Ydieresis",
            "fraction",
            "currency",
            "guilsinglleft",
            "guilsinglright",
            "fi",
            "fi",
            "daggerdbl",
            "periodcentered",
            "quotesinglbase",
            "quotedblbase",
            "perthousand",
            "Acircumflex",
            "Ecircumflex",
            "Aacute",
            "Edieresis",
            "Egrave",
            "Iacute",
            "Icircumflex",
            "Idieresis",
            "Igrave",
            "Oacute",
            "Ocircumflex",
            "applelogo",
            "Ograve",
            "Uacute",
            "Ucircumflex",
            "Ugrave",
            "dotlessi",
            "circumflex",
            "tilde",
            "overscore",
            "breve",
            "dotaccent",
            "ring",
            "cedilla",
            "hungarumlaut",
            "ogonek",
            "caron",
            "Lslash",
            "lslash",
            "Scaron",
            "scaron",
            "Zcaron",
            "zcaron",
            "brokenbar",
            "Eth",
            "eth",
            "Yacute",
            "yacute",
            "Thorn",
            "thorn",
            "minus",
            "multiply",
            "onesuperior",
            "twosuperior",
            "threesuperior",
            "onehalf",
            "onequarter",
            "threequarters",
            "franc",
            "Gbreve",
            "gbreve",
            "Idot",
            "Scedilla",
            "scedilla",
            "Cacute",
            "cacute",
            "Ccaron",
            "ccaron",
            "dmacron"
    };
}
