/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface ACatalog extends AObject {
	




























	/**
	*/
	public Boolean getcontainsAA();

	/**
	*/
	public String getAAType();

	/**
	*/
	public Boolean getAAHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsAF();

	/**
	*/
	public String getAFType();

	/**
	*/
	public Boolean getAFHasTypeArray();

	/**
	*/
	public Boolean getcontainsAcroForm();

	/**
	*/
	public String getAcroFormType();

	/**
	*/
	public Boolean getAcroFormHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsCollection();

	/**
	*/
	public String getCollectionType();

	/**
	*/
	public Boolean getCollectionHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsDPartRoot();

	/**
	*/
	public String getDPartRootType();

	/**
	*/
	public Boolean getDPartRootHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsDSS();

	/**
	*/
	public String getDSSType();

	/**
	*/
	public Boolean getDSSHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsDests();

	/**
	*/
	public Boolean getisDestsIndirect();

	/**
	*/
	public String getDestsType();

	/**
	*/
	public Boolean getDestsHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsExtensions();

	/**
	*/
	public Boolean getisExtensionsIndirect();

	/**
	*/
	public String getExtensionsType();

	/**
	*/
	public Boolean getExtensionsHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsLang();

	/**
	*/
	public String getLangType();

	/**
	*/
	public Boolean getLangHasTypeStringText();

	/**
	*/
	public Boolean getcontainsLegal();

	/**
	*/
	public String getLegalType();

	/**
	*/
	public Boolean getLegalHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsMarkInfo();

	/**
	*/
	public String getMarkInfoType();

	/**
	*/
	public Boolean getMarkInfoHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsMetadata();

	/**
	*/
	public Boolean getisMetadataIndirect();

	/**
	*/
	public String getMetadataType();

	/**
	*/
	public Boolean getMetadataHasTypeStream();

	/**
	*/
	public Boolean getcontainsNames();

	/**
	*/
	public String getNamesType();

	/**
	*/
	public Boolean getNamesHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsNeedsRendering();

	/**
	*/
	public String getNeedsRenderingType();

	/**
	*/
	public Boolean getNeedsRenderingHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsOCProperties();

	/**
	*/
	public String getOCPropertiesType();

	/**
	*/
	public Boolean getOCPropertiesHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsOpenAction();

	/**
	*/
	public String getOpenActionType();

	/**
	*/
	public Boolean getOpenActionHasTypeArray();

	/**
	*/
	public Boolean getOpenActionHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsOutlines();

	/**
	*/
	public Boolean getisOutlinesIndirect();

	/**
	*/
	public String getOutlinesType();

	/**
	*/
	public Boolean getOutlinesHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsOutputIntents();

	/**
	*/
	public String getOutputIntentsType();

	/**
	*/
	public Boolean getOutputIntentsHasTypeArray();

	/**
	*/
	public Boolean getcontainsPageLabels();

	/**
	*/
	public String getPageLabelsType();

	/**
	*/
	public Boolean getPageLabelsHasTypeNumberTree();

	/**
	*/
	public Boolean getcontainsPageLabelsTreeNode();

	/**
	*/
	public String getPageLabelsTreeNodeType();

	/**
	*/
	public Boolean getPageLabelsTreeNodeHasTypeNumberTree();

	/**
	*/
	public Boolean getcontainsPageLayout();

	/**
	*/
	public String getPageLayoutType();

	/**
	*/
	public Boolean getPageLayoutHasTypeName();

	/**
	*/
	public String getPageLayoutNameValue();

	/**
	*/
	public Boolean getcontainsPageMode();

	/**
	*/
	public String getPageModeType();

	/**
	*/
	public Boolean getPageModeHasTypeName();

	/**
	*/
	public String getPageModeNameValue();

	/**
	*/
	public Boolean getcontainsPages();

	/**
	*/
	public Boolean getisPagesIndirect();

	/**
	*/
	public String getPagesType();

	/**
	*/
	public Boolean getPagesHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsPerms();

	/**
	*/
	public String getPermsType();

	/**
	*/
	public Boolean getPermsHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsPieceInfo();

	/**
	*/
	public String getPieceInfoType();

	/**
	*/
	public Boolean getPieceInfoHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsRequirements();

	/**
	*/
	public String getRequirementsType();

	/**
	*/
	public Boolean getRequirementsHasTypeArray();

	/**
	*/
	public Boolean getcontainsSpiderInfo();

	/**
	*/
	public String getSpiderInfoType();

	/**
	*/
	public Boolean getSpiderInfoHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsStructTreeRoot();

	/**
	*/
	public Boolean getisStructTreeRootIndirect();

	/**
	*/
	public String getStructTreeRootType();

	/**
	*/
	public Boolean getStructTreeRootHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsThreads();

	/**
	*/
	public Boolean getisThreadsIndirect();

	/**
	*/
	public String getThreadsType();

	/**
	*/
	public Boolean getThreadsHasTypeArray();

	/**
	*/
	public Boolean getcontainsType();

	/**
	*/
	public String getTypeType();

	/**
	*/
	public Boolean getTypeHasTypeName();

	/**
	*/
	public String getTypeNameValue();

	/**
	*/
	public Boolean getcontainsURI();

	/**
	*/
	public String getURIType();

	/**
	*/
	public Boolean getURIHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsVersion();

	/**
	*/
	public String getVersionType();

	/**
	*/
	public Boolean getVersionHasTypeName();

	/**
	*/
	public String getVersionNameValue();

	/**
	*/
	public Boolean getcontainsViewerPreferences();

	/**
	*/
	public String getViewerPreferencesType();

	/**
	*/
	public Boolean getViewerPreferencesHasTypeDictionary();

	/**
	*/
	public Boolean getnumber0IsNumberTreePageLabelsIndex();
}
