/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AInteractiveForm extends AObject {
	





	/**
	*/
	public Boolean getcontainsCO();

	/**
	*/
	public String getCOType();

	/**
	*/
	public Boolean getCOHasTypeArray();

	/**
	*/
	public Boolean getcontainsDA();

	/**
	*/
	public String getDAType();

	/**
	*/
	public Boolean getDAHasTypeStringByte();

	/**
	*/
	public Boolean getcontainsDR();

	/**
	*/
	public String getDRType();

	/**
	*/
	public Boolean getDRHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsFields();

	/**
	*/
	public String getFieldsType();

	/**
	*/
	public Boolean getFieldsHasTypeArray();

	/**
	*/
	public Boolean getcontainsNeedAppearances();

	/**
	*/
	public String getNeedAppearancesType();

	/**
	*/
	public Boolean getNeedAppearancesHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsQ();

	/**
	*/
	public String getQType();

	/**
	*/
	public Boolean getQHasTypeInteger();

	/**
	*/
	public Long getQIntegerValue();

	/**
	*/
	public Boolean getcontainsSigFlags();

	/**
	*/
	public String getSigFlagsType();

	/**
	*/
	public Boolean getSigFlagsHasTypeBitmask();

	/**
	*/
	public Long getSigFlagsBitmaskValue();

	/**
	*/
	public Boolean getcontainsXFA();

	/**
	*/
	public Boolean getisXFAIndirect();

	/**
	*/
	public String getXFAType();

	/**
	*/
	public Boolean getXFAHasTypeArray();

	/**
	*/
	public Boolean getXFAHasTypeStream();

	/**
	*/
	public Boolean getcontainsDRFontAny();
}
