/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface ACMapStream extends AObject {
	








	/**
	*/
	public Boolean getcontainsCIDSystemInfo();

	/**
	*/
	public String getCIDSystemInfoType();

	/**
	*/
	public Boolean getCIDSystemInfoHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsCMapName();

	/**
	*/
	public String getCMapNameType();

	/**
	*/
	public Boolean getCMapNameHasTypeName();

	/**
	*/
	public Boolean getcontainsDL();

	/**
	*/
	public String getDLType();

	/**
	*/
	public Boolean getDLHasTypeInteger();

	/**
	*/
	public Long getDLIntegerValue();

	/**
	*/
	public Boolean getcontainsDecodeParms();

	/**
	*/
	public String getDecodeParmsType();

	/**
	*/
	public Boolean getDecodeParmsHasTypeArray();

	/**
	*/
	public Boolean getDecodeParmsHasTypeDictionary();

	/**
	*/
	public Long getDecodeParmsArraySize();

	/**
	*/
	public Boolean getcontainsF();

	/**
	*/
	public String getFType();

	/**
	*/
	public Boolean getFHasTypeDictionary();

	/**
	*/
	public Boolean getFHasTypeString();

	/**
	*/
	public Boolean getcontainsFDecodeParms();

	/**
	*/
	public String getFDecodeParmsType();

	/**
	*/
	public Boolean getFDecodeParmsHasTypeArray();

	/**
	*/
	public Boolean getFDecodeParmsHasTypeDictionary();

	/**
	*/
	public Long getFDecodeParmsArraySize();

	/**
	*/
	public Boolean getcontainsFFilter();

	/**
	*/
	public String getFFilterType();

	/**
	*/
	public Boolean getFFilterHasTypeArray();

	/**
	*/
	public Boolean getFFilterHasTypeName();

	/**
	*/
	public String getFFilterNameValue();

	/**
	*/
	public Long getFFilterArraySize();

	/**
	*/
	public Boolean getcontainsFilter();

	/**
	*/
	public String getFilterType();

	/**
	*/
	public Boolean getFilterHasTypeArray();

	/**
	*/
	public Boolean getFilterHasTypeName();

	/**
	*/
	public String getFilterNameValue();

	/**
	*/
	public Long getFilterArraySize();

	/**
	*/
	public Boolean getcontainsLength();

	/**
	*/
	public String getLengthType();

	/**
	*/
	public Boolean getLengthHasTypeInteger();

	/**
	*/
	public Boolean getcontainsType();

	/**
	*/
	public String getTypeType();

	/**
	*/
	public Boolean getTypeHasTypeName();

	/**
	*/
	public String getTypeNameValue();

	/**
	*/
	public Boolean getcontainsUseCMap();

	/**
	*/
	public Boolean getisUseCMapIndirect();

	/**
	*/
	public String getUseCMapType();

	/**
	*/
	public Boolean getUseCMapHasTypeName();

	/**
	*/
	public Boolean getUseCMapHasTypeStream();

	/**
	*/
	public String getUseCMapNameValue();

	/**
	*/
	public Boolean getcontainsWMode();

	/**
	*/
	public String getWModeType();

	/**
	*/
	public Boolean getWModeHasTypeInteger();

	/**
	*/
	public Long getWModeIntegerValue();
}
