/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015-2024, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface ACertSeedValue extends AObject {
	







	/**
	*/
	public Boolean getcontainsFf();

	/**
	*/
	public String getFfType();

	/**
	*/
	public Boolean getFfHasTypeBitmask();

	/**
	*/
	public Long getFfBitmaskValue();

	/**
	*/
	public Boolean getcontainsIssuer();

	/**
	*/
	public String getIssuerType();

	/**
	*/
	public Boolean getIssuerHasTypeArray();

	/**
	*/
	public Boolean getcontainsKeyUsage();

	/**
	*/
	public String getKeyUsageType();

	/**
	*/
	public Boolean getKeyUsageHasTypeArray();

	/**
	*/
	public Boolean getcontainsOID();

	/**
	*/
	public String getOIDType();

	/**
	*/
	public Boolean getOIDHasTypeArray();

	/**
	*/
	public Boolean getcontainsSignaturePolicyCommitmentType();

	/**
	*/
	public String getSignaturePolicyCommitmentTypeType();

	/**
	*/
	public Boolean getSignaturePolicyCommitmentTypeHasTypeArray();

	/**
	*/
	public Boolean getcontainsSignaturePolicyHashAlgorithm();

	/**
	*/
	public String getSignaturePolicyHashAlgorithmType();

	/**
	*/
	public Boolean getSignaturePolicyHashAlgorithmHasTypeName();

	/**
	*/
	public String getSignaturePolicyHashAlgorithmNameValue();

	/**
	*/
	public Boolean getcontainsSignaturePolicyHashValue();

	/**
	*/
	public String getSignaturePolicyHashValueType();

	/**
	*/
	public Boolean getSignaturePolicyHashValueHasTypeString();

	/**
	*/
	public Boolean getcontainsSignaturePolicyOID();

	/**
	*/
	public String getSignaturePolicyOIDType();

	/**
	*/
	public Boolean getSignaturePolicyOIDHasTypeStringAscii();

	/**
	*/
	public Boolean getcontainsSubject();

	/**
	*/
	public String getSubjectType();

	/**
	*/
	public Boolean getSubjectHasTypeArray();

	/**
	*/
	public Boolean getcontainsSubjectDN();

	/**
	*/
	public String getSubjectDNType();

	/**
	*/
	public Boolean getSubjectDNHasTypeArray();

	/**
	*/
	public Boolean getcontainsType();

	/**
	*/
	public String getTypeType();

	/**
	*/
	public Boolean getTypeHasTypeName();

	/**
	*/
	public String getTypeNameValue();

	/**
	*/
	public Boolean getcontainsURL();

	/**
	*/
	public String getURLType();

	/**
	*/
	public Boolean getURLHasTypeStringAscii();

	/**
	*/
	public Boolean getcontainsURLType();

	/**
	*/
	public String getURLTypeType();

	/**
	*/
	public Boolean getURLTypeHasTypeName();

	/**
	*/
	public String getURLTypeNameValue();
}
