/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.selayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.coslayer.CosLang;
import java.util.List;

		
/**
* a content item such as text, image, lineart, shading or a form
*/
public interface SEContentItem extends Object {
	

	/**
	* list of tags, associated with parents marked content sequences (first operand of the BMC/BDC operators)
	*/
	public List<String> getparentsTags();

	/**
	* type of the parent structure element for parent marked content sequence
	*/
	public String getparentStructureTag();

	/**
	* true, if parent struct element is a part of the structure tree
	*/
	public Boolean getisTaggedContent();

	/**
	* object key of parent struct element
	*/
	public String getparentStructureElementObjectKey();

	/**
	* standard type of the parent structure element for parent marked content sequence
	* (if it is a part of the structure tree), null, if it is not a part of the structure tree
	*/
	public String getparentStandardTag();

	/**
	* value of the ActualText entry
	*/
	public String getActualText();

	/**
	* value of the Alt entry
	*/
	public String getAlt();

	/**
	* true if this content item is contained in appearance stream of the widget annotation associated with a interactive field of type 'Signature'
	*/
	public Boolean getisSignature();

	/**
	* true if this content item is contained in an Artifact structure element (directly or indirectly)
	*/
	public Boolean getisArtifact();
}
