/*
 * This file is part of VeraPDF Validation Model API for Arlington PDF Model, a module of the veraPDF project.
 * Copyright (c) 2015-2025, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * VeraPDF Validation Model API for Arlington PDF Model is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * VeraPDF Validation Model API for Arlington PDF Model as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AViewerPreferences extends AObject {
	



	/**
	*/
	public Boolean getcontainsCenterWindow();

	/**
	*/
	public String getCenterWindowType();

	/**
	*/
	public Boolean getCenterWindowHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsDirection();

	/**
	*/
	public String getDirectionType();

	/**
	*/
	public Boolean getDirectionHasTypeName();

	/**
	*/
	public String getDirectionNameValue();

	/**
	*/
	public Boolean getcontainsDisplayDocTitle();

	/**
	*/
	public String getDisplayDocTitleType();

	/**
	*/
	public Boolean getDisplayDocTitleHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsDuplex();

	/**
	*/
	public String getDuplexType();

	/**
	*/
	public Boolean getDuplexHasTypeName();

	/**
	*/
	public String getDuplexNameValue();

	/**
	*/
	public Boolean getcontainsEnforce();

	/**
	*/
	public String getEnforceType();

	/**
	*/
	public Boolean getEnforceHasTypeArray();

	/**
	*/
	public Boolean getcontainsFitWindow();

	/**
	*/
	public String getFitWindowType();

	/**
	*/
	public Boolean getFitWindowHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsHideMenubar();

	/**
	*/
	public String getHideMenubarType();

	/**
	*/
	public Boolean getHideMenubarHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsHideToolbar();

	/**
	*/
	public String getHideToolbarType();

	/**
	*/
	public Boolean getHideToolbarHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsHideWindowUI();

	/**
	*/
	public String getHideWindowUIType();

	/**
	*/
	public Boolean getHideWindowUIHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsNonFullScreenPageMode();

	/**
	*/
	public String getNonFullScreenPageModeType();

	/**
	*/
	public Boolean getNonFullScreenPageModeHasTypeName();

	/**
	*/
	public String getNonFullScreenPageModeNameValue();

	/**
	*/
	public Boolean getcontainsNumCopies();

	/**
	*/
	public String getNumCopiesType();

	/**
	*/
	public Boolean getNumCopiesHasTypeInteger();

	/**
	*/
	public Long getNumCopiesIntegerValue();

	/**
	*/
	public Boolean getcontainsPickTrayByPDFSize();

	/**
	*/
	public String getPickTrayByPDFSizeType();

	/**
	*/
	public Boolean getPickTrayByPDFSizeHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsPrintArea();

	/**
	*/
	public String getPrintAreaType();

	/**
	*/
	public Boolean getPrintAreaHasTypeName();

	/**
	*/
	public String getPrintAreaNameValue();

	/**
	*/
	public Boolean getcontainsPrintClip();

	/**
	*/
	public String getPrintClipType();

	/**
	*/
	public Boolean getPrintClipHasTypeName();

	/**
	*/
	public String getPrintClipNameValue();

	/**
	*/
	public Boolean getcontainsPrintPageRange();

	/**
	*/
	public String getPrintPageRangeType();

	/**
	*/
	public Boolean getPrintPageRangeHasTypeArray();

	/**
	*/
	public Boolean getcontainsPrintScaling();

	/**
	*/
	public String getPrintScalingType();

	/**
	*/
	public Boolean getPrintScalingHasTypeName();

	/**
	*/
	public String getPrintScalingNameValue();

	/**
	*/
	public Boolean getcontainsViewArea();

	/**
	*/
	public String getViewAreaType();

	/**
	*/
	public Boolean getViewAreaHasTypeName();

	/**
	*/
	public String getViewAreaNameValue();

	/**
	*/
	public Boolean getcontainsViewClip();

	/**
	*/
	public String getViewClipType();

	/**
	*/
	public Boolean getViewClipHasTypeName();

	/**
	*/
	public String getViewClipNameValue();

	/**
	*/
	public String gettrailerCatalogPageModeNameValue();
}
