/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.salayer.SAPDFDocument;
import org.verapdf.model.pdlayer.PDEncryption;
import org.verapdf.model.external.EmbeddedFile;

		
/**  PDF Stream type
 */
public interface CosStream extends CosDict {
	

	/**  value of the Length key in the Stream dictionary
	 */
	public Long getLength();

	/**  real length of stream
	 */
	public Long getrealLength();

	/**  represents value of F key or null if stream does not contain this key
	 */
	public String getF();

	/**  represents value of FFilter key or null if stream does not contain this key
	 */
	public String getFFilter();

	/**  represents value of FDecodeParms key or null if stream does not contain this key
	 */
	public String getFDecodeParms();

	/**  true if spacings around keywords 'stream' comply to the PDF/A standard
	 */
	public Boolean getstreamKeywordCRLFCompliant();

	/**  true if spacings around keywords 'endstream' comply to the PDF/A standard
	 */
	public Boolean getendstreamKeywordEOLCompliant();

}
