/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.external.EmbeddedFile;

		
/**  File specification dictionary
 */
public interface CosFileSpecification extends CosDict {
	


	/**  a file specification string (F key)
	 */
	public String getF();

	/**  a unicode file specification (UF key)
	 */
	public String getUF();

	/**  the relationship between the component of the PDF document that refers to this file specification and the associated file (/AFRelationship key)
	 */
	public String getAFRelationship();

	/**  true if the file specification dictionary is associated (=referenced by the /AF key) with at least one of the following objects: catalog, page, XObject, annotation or structure element
	 */
	public Boolean getisAssociatedFile();
}
