package org.verapdf.model.operator;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosInteger;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosString;
import org.verapdf.model.coslayer.CosArray;
import org.verapdf.model.coslayer.CosName;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.pdlayer.PDColorSpace;
import org.verapdf.model.pdlayer.PDExtGState;
import org.verapdf.model.pdlayer.PDXObject;
import org.verapdf.model.pdlayer.PDInlineImage;
import org.verapdf.model.pdlayer.PDShading;
import org.verapdf.model.pdlayer.PDFont;

		
/**  glyph used in text
 */
public interface Glyph extends Object {
	

	/**  glyph name, or empty string if the glyph is not identified by the name (as in case of CID fonts)
	 */
	public String getname();

	/**  true if the width of the glyph in the embedded font program is consistent with the width specified in the Font dictionary
	 */
	public Boolean getisWidthConsistent();

	/**  true if glyph is present in the font program
	 */
	public Boolean getisGlyphPresent();

	/**  unicode value of the glyph
	 */
	public String gettoUnicode();

	/**  value of the rendering mode at the moment the glyph is shown
	 */
	public Long getrenderingMode();

	/**  true if toUnicode value contains codes from Unicode Private Use Area
	 */
	public Boolean getunicodePUA();

	/**  true if an ActualText entry is present for this glyph
	 */
	public Boolean getactualTextPresent();
}
