package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;

		
/**  annotation object	
 */
public interface PDAnnot extends PDObject {
	

	/**  annotation subtype
	 */
	public String getSubtype();

	/**  annotation opacity (CA key)
	 */
	public Double getCA();

	/**  annotation flags
	 */
	public Long getF();

	/**  SPACE-separated list of all keys in the annotation's appearance dictionary (AP key)
	 */
	public String getAP();

	/**  the value of the /FT entry (Field type), in case this is the widget annotation representing the form field, or null,  if this entry is not present
	 */
	public String getFT();

	/**  the type of the normal appearance entry (/N key) in the annotation appearance dictionary (/AP key) or null, if the normal appearance is not present
	 */
	public String getN_type();






	/**  the width of the annotation computed as an absolute value of the difference of value 1 and value 3 of the Rect entry
	 */
	public Double getwidth();

	/**  the height of the annotation computed as an absolute value of the difference of value 2 and value 4 of the Rect entry
	 */
	public Double getheight();

	/**  true if the annotation dictionary contains the AA entry
	 */
	public Boolean getcontainsAA();
}
