/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDCIEDictionaryBasedColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDCalRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDGamma;
import org.apache.pdfbox.pdmodel.graphics.color.PDICCBased;
import org.apache.pdfbox.pdmodel.graphics.color.PDIndexed;
import org.apache.pdfbox.pdmodel.graphics.color.PDLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBColorSpaceFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private static final Logger LOGGER = Logger.getLogger(PBColorSpaceFeaturesObject.class);
    private PDColorSpace colorSpace;
    private String id;
    private String iccProfileChild;
    private String colorSpaceChild;

    public PBColorSpaceFeaturesObject(PDColorSpace colorSpace, String id, String iccProfileChild, String colorSpaceChild) {
        this.colorSpace = colorSpace;
        this.id = id;
        this.iccProfileChild = iccProfileChild;
        this.colorSpaceChild = colorSpaceChild;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.COLORSPACE;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.colorSpace != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"colorSpace");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.setAttribute("family", this.colorSpace.getName());
            if (this.colorSpace instanceof PDCIEDictionaryBasedColorSpace) {
                this.parseCIEDictionaryBased(root);
            } else if (this.colorSpace instanceof PDICCBased) {
                PDICCBased icc = (PDICCBased)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.createChildNode((String)"alternate", (FeatureTreeNode)root);
                    alt.setAttribute(ID, this.colorSpaceChild);
                }
                FeatureTreeNode.createChildNode((String)"components", (FeatureTreeNode)root).setValue(String.valueOf(icc.getNumberOfComponents()));
                if (this.iccProfileChild != null) {
                    FeatureTreeNode prof = FeatureTreeNode.createChildNode((String)"iccProfile", (FeatureTreeNode)root);
                    prof.setAttribute(ID, this.iccProfileChild);
                }
            } else if (this.colorSpace instanceof PDIndexed) {
                this.parseIndexed(root, collection);
            } else if (this.colorSpace instanceof PDSeparation) {
                PDSeparation sep = (PDSeparation)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.createChildNode((String)"alternate", (FeatureTreeNode)root);
                    alt.setAttribute(ID, this.colorSpaceChild);
                }
                PBCreateNodeHelper.addNotEmptyNode("colorantName", sep.getColorantName(), root);
            } else if (this.colorSpace instanceof PDDeviceN) {
                List devNColorantNames;
                PDDeviceN devN = (PDDeviceN)this.colorSpace;
                if (this.colorSpaceChild != null) {
                    FeatureTreeNode alt = FeatureTreeNode.createChildNode((String)"alternate", (FeatureTreeNode)root);
                    alt.setAttribute(ID, this.colorSpaceChild);
                }
                if ((devNColorantNames = devN.getColorantNames()) != null) {
                    FeatureTreeNode colorantNames = FeatureTreeNode.createChildNode((String)"colorantNames", (FeatureTreeNode)root);
                    for (String name : devNColorantNames) {
                        PBCreateNodeHelper.addNotEmptyNode("colorantName", name, colorantNames);
                    }
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.COLORSPACE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private void parseIndexed(FeatureTreeNode root, FeaturesCollection collection) throws FeatureParsingException {
        PDIndexed index = (PDIndexed)this.colorSpace;
        if (this.colorSpaceChild != null) {
            FeatureTreeNode alt = FeatureTreeNode.createChildNode((String)"base", (FeatureTreeNode)root);
            alt.setAttribute(ID, this.colorSpaceChild);
        }
        if (index.getCOSObject() instanceof COSArray) {
            FeatureTreeNode hival = FeatureTreeNode.createChildNode((String)"hival", (FeatureTreeNode)root);
            if (((COSArray)index.getCOSObject()).size() >= 3 && ((COSArray)index.getCOSObject()).getObject(2) instanceof COSNumber) {
                hival.setValue(String.valueOf(((COSNumber)((COSArray)index.getCOSObject()).getObject(2)).intValue()));
            } else {
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)hival, (String)"Indexed color space has no element hival or hival is not a number");
            }
            FeatureTreeNode lookup = FeatureTreeNode.createChildNode((String)"lookup", (FeatureTreeNode)root);
            if (((COSArray)index.getCOSObject()).size() >= 4) {
                byte[] lookupData = null;
                COSBase lookupTable = ((COSArray)index.getCOSObject()).getObject(3);
                if (lookupTable instanceof COSString) {
                    lookupData = ((COSString)lookupTable).getBytes();
                } else if (lookupTable instanceof COSStream) {
                    try {
                        lookupData = new PDStream((COSStream)lookupTable).getByteArray();
                    }
                    catch (IOException e) {
                        LOGGER.info((Object)e);
                        ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)lookup, (String)e.getMessage());
                    }
                } else {
                    ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)lookup, (String)"Indexed color space has element lookup but it is not a String or a stream");
                }
                if (lookupData != null) {
                    lookup.setValue(DatatypeConverter.printHexBinary((byte[])lookupData));
                }
            } else {
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)lookup, (String)"Indexed color space has no element lookup");
            }
        } else {
            ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)root, (String)"Indexed color space is not an array");
        }
    }

    private void parseCIEDictionaryBased(FeatureTreeNode root) throws FeatureParsingException {
        PDCIEDictionaryBasedColorSpace cie = (PDCIEDictionaryBasedColorSpace)this.colorSpace;
        PBColorSpaceFeaturesObject.parseTristimulus(cie.getWhitepoint(), FeatureTreeNode.createChildNode((String)"whitePoint", (FeatureTreeNode)root));
        PBColorSpaceFeaturesObject.parseTristimulus(cie.getBlackPoint(), FeatureTreeNode.createChildNode((String)"blackPoint", (FeatureTreeNode)root));
        if (cie instanceof PDCalGray) {
            PDCalGray calGray = (PDCalGray)cie;
            FeatureTreeNode.createChildNode((String)"gamma", (FeatureTreeNode)root).setValue(String.valueOf(calGray.getGamma()));
        } else if (cie instanceof PDCalRGB) {
            PDCalRGB calRGB = (PDCalRGB)cie;
            FeatureTreeNode gamma = FeatureTreeNode.createChildNode((String)"gamma", (FeatureTreeNode)root);
            PDGamma pdGamma = calRGB.getGamma();
            gamma.setAttribute("red", String.valueOf(pdGamma.getR()));
            gamma.setAttribute("green", String.valueOf(pdGamma.getG()));
            gamma.setAttribute("blue", String.valueOf(pdGamma.getB()));
            PBColorSpaceFeaturesObject.parseFloatArray(calRGB.getMatrix(), FeatureTreeNode.createChildNode((String)"matrix", (FeatureTreeNode)root));
        } else if (cie instanceof PDLab) {
            PDLab lab = (PDLab)cie;
            FeatureTreeNode range = FeatureTreeNode.createChildNode((String)"range", (FeatureTreeNode)root);
            range.setAttribute("aMin", String.valueOf(lab.getARange().getMin()));
            range.setAttribute("aMax", String.valueOf(lab.getARange().getMax()));
            range.setAttribute("bMin", String.valueOf(lab.getBRange().getMin()));
            range.setAttribute("bMax", String.valueOf(lab.getBRange().getMax()));
        }
    }

    private static void parseFloatArray(float[] array, FeatureTreeNode parent) throws FeatureParsingException {
        for (int i = 0; i < array.length; ++i) {
            FeatureTreeNode element = FeatureTreeNode.createChildNode((String)"element", (FeatureTreeNode)parent);
            element.setAttribute("number", String.valueOf(i));
            element.setAttribute("value", String.valueOf(array[i]));
        }
    }

    private static void parseTristimulus(PDTristimulus tris, FeatureTreeNode curNode) {
        curNode.setAttribute("x", String.valueOf(tris.getX()));
        curNode.setAttribute("y", String.valueOf(tris.getY()));
        curNode.setAttribute("z", String.valueOf(tris.getZ()));
    }
}

