/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBExtGStateFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDExtendedGraphicsState exGState;
    private String id;
    private String fontChildID;

    public PBExtGStateFeaturesObject(PDExtendedGraphicsState exGState, String id, String fontChildID) {
        this.exGState = exGState;
        this.id = id;
        this.fontChildID = fontChildID;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.EXT_G_STATE;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.exGState != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"graphicsState");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            FeatureTreeNode.createChildNode((String)"transparency", (FeatureTreeNode)root).setValue(String.valueOf(!this.exGState.getAlphaSourceFlag()));
            FeatureTreeNode.createChildNode((String)"strokeAdjustment", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getAutomaticStrokeAdjustment()));
            FeatureTreeNode.createChildNode((String)"overprintForStroke", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getStrokingOverprintControl()));
            FeatureTreeNode.createChildNode((String)"overprintForFill", (FeatureTreeNode)root).setValue(String.valueOf(this.exGState.getNonStrokingOverprintControl()));
            if (this.fontChildID != null) {
                FeatureTreeNode resources = FeatureTreeNode.createChildNode((String)"resources", (FeatureTreeNode)root);
                FeatureTreeNode fonts = FeatureTreeNode.createChildNode((String)"fonts", (FeatureTreeNode)resources);
                FeatureTreeNode font = FeatureTreeNode.createChildNode((String)"font", (FeatureTreeNode)fonts);
                font.setAttribute(ID, this.fontChildID);
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.EXT_G_STATE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

