/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBOutlinesFeaturesObject
implements IFeaturesObject {
    private static final int RGB_COLORS_NUMBER = 3;
    private static final int RGB_RED_COLOR_NUMBER = 0;
    private static final int RGB_GREEN_COLOR_NUMBER = 1;
    private static final int RGB_BLUE_COLOR_NUMBER = 2;
    private PDDocumentOutline outline;

    public PBOutlinesFeaturesObject(PDDocumentOutline outline) {
        this.outline = outline;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.OUTLINES;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.outline != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"outlines");
            if (this.outline.children() != null) {
                HashSet<PDOutlineItem> items = new HashSet<PDOutlineItem>();
                for (PDOutlineItem item : this.outline.children()) {
                    if (items.contains(item)) continue;
                    PBOutlinesFeaturesObject.createItem(item, root, collection, items);
                }
            }
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.OUTLINES, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }

    private static void createItem(PDOutlineItem item, FeatureTreeNode root, FeaturesCollection collection, Set<PDOutlineItem> items) throws FeatureParsingException {
        if (item != null) {
            items.add(item);
            FeatureTreeNode itemNode = FeatureTreeNode.createChildNode((String)"outline", (FeatureTreeNode)root);
            PBCreateNodeHelper.addNotEmptyNode("title", item.getTitle(), itemNode);
            FeatureTreeNode color = FeatureTreeNode.createChildNode((String)"color", (FeatureTreeNode)itemNode);
            PDColor clr = item.getTextColor();
            float[] rgb = clr.getComponents();
            if (rgb.length == 3) {
                color.setAttribute("red", String.valueOf(rgb[0]));
                color.setAttribute("green", String.valueOf(rgb[1]));
                color.setAttribute("blue", String.valueOf(rgb[2]));
            } else {
                ErrorsHelper.addErrorIntoCollection((FeaturesCollection)collection, (FeatureTreeNode)color, (String)"Color must be in rgb form");
            }
            FeatureTreeNode style = FeatureTreeNode.createChildNode((String)"style", (FeatureTreeNode)itemNode);
            style.setAttribute("italic", String.valueOf(item.isItalic()));
            style.setAttribute("bold", String.valueOf(item.isBold()));
            for (PDOutlineItem child : item.children()) {
                if (items.contains(child)) continue;
                PBOutlinesFeaturesObject.createItem(child, itemNode, collection, items);
            }
        }
    }
}

