/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBShadingFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShading shading;
    private String id;
    private String colorSpaceChild;

    public PBShadingFeaturesObject(PDShading shading, String id, String colorSpaceChild) {
        this.shading = shading;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.SHADING;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.shading != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"shading");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            FeatureTreeNode.createChildNode((String)"shadingType", (FeatureTreeNode)root).setValue(String.valueOf(this.shading.getShadingType()));
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shadingClr = FeatureTreeNode.createChildNode((String)"colorSpace", (FeatureTreeNode)root);
                shadingClr.setAttribute(ID, this.colorSpaceChild);
            }
            PBCreateNodeHelper.addBoxFeature("bbox", this.shading.getBBox(), root);
            FeatureTreeNode.createChildNode((String)"antiAlias", (FeatureTreeNode)root).setValue(String.valueOf(this.shading.getAntiAlias()));
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.SHADING, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

