/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.FeaturesObjectTypesEnum;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.SignatureFeaturesData;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;
import org.verapdf.features.tools.FeaturesCollection;

public class PBSignatureFeaturesObject
implements IFeaturesObject {
    private PDSignature signature;

    public PBSignatureFeaturesObject(PDSignature signature) {
        this.signature = signature;
    }

    public FeaturesObjectTypesEnum getType() {
        return FeaturesObjectTypesEnum.SIGNATURE;
    }

    public FeatureTreeNode reportFeatures(FeaturesCollection collection) throws FeatureParsingException {
        if (this.signature != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"signature");
            PBCreateNodeHelper.addNotEmptyNode("filter", this.signature.getFilter(), root);
            PBCreateNodeHelper.addNotEmptyNode("subFilter", this.signature.getSubFilter(), root);
            byte[] contents = this.signature.getContents();
            if (contents != null) {
                PBCreateNodeHelper.addNotEmptyNode("contents", DatatypeConverter.printHexBinary((byte[])contents), root);
            }
            PBCreateNodeHelper.addNotEmptyNode("name", this.signature.getName(), root);
            PBCreateNodeHelper.createDateNode("signDate", root, this.signature.getSignDate(), collection);
            PBCreateNodeHelper.addNotEmptyNode("location", this.signature.getLocation(), root);
            PBCreateNodeHelper.addNotEmptyNode("reason", this.signature.getReason(), root);
            PBCreateNodeHelper.addNotEmptyNode("contactInfo", this.signature.getContactInfo(), root);
            collection.addNewFeatureTree(FeaturesObjectTypesEnum.SIGNATURE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        byte[] contents = this.signature.getContents();
        ByteArrayInputStream stream = contents == null ? null : new ByteArrayInputStream(contents);
        return SignatureFeaturesData.newInstance((InputStream)stream, (String)this.signature.getFilter(), (String)this.signature.getSubFilter(), (String)this.signature.getName(), (Calendar)this.signature.getSignDate(), (String)this.signature.getLocation(), (String)this.signature.getReason(), (String)this.signature.getContactInfo());
    }
}

