/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.EmbeddedFileFeaturesData;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.ErrorsHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBEmbeddedFileFeaturesObject
implements IFeaturesObject {
    private static final Logger LOGGER = Logger.getLogger(PBEmbeddedFileFeaturesObject.class);
    private static final String CREATION_DATE = "creationDate";
    private static final String MOD_DATE = "modDate";
    private PDComplexFileSpecification embFile;
    private int index;

    public PBEmbeddedFileFeaturesObject(PDComplexFileSpecification embFile, int index) {
        this.embFile = embFile;
        this.index = index;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.EMBEDDED_FILE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.embFile != null) {
            PDEmbeddedFile ef;
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"embeddedFile");
            root.setAttribute("id", "file" + this.index);
            PBCreateNodeHelper.addNotEmptyNode("fileName", this.embFile.getFilename(), root);
            PBCreateNodeHelper.addNotEmptyNode("description", this.embFile.getFileDescription(), root);
            COSDictionary dict = this.embFile.getCOSObject();
            if (dict != null) {
                PBCreateNodeHelper.addNotEmptyNode("afRelationship", dict.getNameAsString(COSName.getPDFName((String)"AFRelationship")), root);
            }
            if ((ef = this.embFile.getEmbeddedFile()) != null) {
                COSBase baseChecksum;
                PBCreateNodeHelper.addNotEmptyNode("subtype", ef.getSubtype(), root);
                PBCreateNodeHelper.addNotEmptyNode("filter", PBEmbeddedFileFeaturesObject.getFilters(ef.getFilters()), root);
                try {
                    PBCreateNodeHelper.createDateNode(CREATION_DATE, root, ef.getCreationDate(), collection);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"PDFBox error obtaining creation date", (Throwable)e);
                    FeatureTreeNode creationDate = root.addChild(CREATION_DATE);
                    ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)creationDate, (String)e.getMessage());
                }
                try {
                    PBCreateNodeHelper.createDateNode(MOD_DATE, root, ef.getModDate(), collection);
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"PDFBox error obtaining modification date", (Throwable)e);
                    FeatureTreeNode modDate = root.addChild(MOD_DATE);
                    ErrorsHelper.addErrorIntoCollection((FeatureExtractionResult)collection, (FeatureTreeNode)modDate, (String)e.getMessage());
                }
                COSBase baseParams = ef.getStream().getDictionaryObject(COSName.PARAMS);
                if (baseParams instanceof COSDictionary && (baseChecksum = ((COSDictionary)baseParams).getDictionaryObject(COSName.getPDFName((String)"CheckSum"))) instanceof COSString) {
                    COSString str = (COSString)baseChecksum;
                    if (str.isHex()) {
                        PBCreateNodeHelper.addNotEmptyNode("checkSum", str.toHexString(), root);
                    } else {
                        PBCreateNodeHelper.addNotEmptyNode("checkSum", str.getString(), root);
                    }
                }
                PBCreateNodeHelper.addNotEmptyNode("size", String.valueOf(ef.getSize()), root);
            }
            collection.addNewFeatureTree(FeatureObjectType.EMBEDDED_FILE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        try {
            COSBase baseChecksum;
            PDEmbeddedFile ef = this.embFile.getEmbeddedFile();
            if (ef == null) {
                LOGGER.debug((Object)"Missed embedded file in PDComplexFileSpecification");
                return null;
            }
            EmbeddedFileFeaturesData.Builder builder = new EmbeddedFileFeaturesData.Builder(ef.getStream().getUnfilteredStream());
            builder.name(this.embFile.getFilename());
            builder.description(this.embFile.getFileDescription());
            COSDictionary dict = this.embFile.getCOSObject();
            if (dict != null) {
                builder.afRelationship(dict.getNameAsString(COSName.getPDFName((String)"AFRelationship")));
            }
            builder.subtype(ef.getSubtype());
            builder.creationDate(ef.getCreationDate());
            builder.modDate(ef.getModDate());
            builder.size(Integer.valueOf(ef.getSize()));
            COSBase baseParams = ef.getStream().getDictionaryObject(COSName.PARAMS);
            if (baseParams instanceof COSDictionary && (baseChecksum = ((COSDictionary)baseParams).getDictionaryObject(COSName.getPDFName((String)"CheckSum"))) instanceof COSString) {
                COSString str = (COSString)baseChecksum;
                if (str.isHex()) {
                    builder.checkSum(str.toHexString());
                } else {
                    builder.checkSum(str.getString());
                }
            }
            return builder.build();
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Can not get embedded file stream", (Throwable)e);
            return null;
        }
    }

    private static String getFilters(List<COSName> list) {
        if (list != null) {
            StringBuilder builder = new StringBuilder();
            for (COSName filter : list) {
                if (filter == null || filter.getName() == null) continue;
                builder.append(filter.getName());
                builder.append(" ");
            }
            return builder.toString().trim();
        }
        return null;
    }
}

