/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBExtGStateFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDExtendedGraphicsState exGState;
    private String id;
    private String fontChildID;

    public PBExtGStateFeaturesObject(PDExtendedGraphicsState exGState, String id, String fontChildID) {
        this.exGState = exGState;
        this.id = id;
        this.fontChildID = fontChildID;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.EXT_G_STATE;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.exGState != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"graphicsState");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.addChild("transparency").setValue(String.valueOf(!this.exGState.getAlphaSourceFlag()));
            root.addChild("strokeAdjustment").setValue(String.valueOf(this.exGState.getAutomaticStrokeAdjustment()));
            root.addChild("overprintForStroke").setValue(String.valueOf(this.exGState.getStrokingOverprintControl()));
            root.addChild("overprintForFill").setValue(String.valueOf(this.exGState.getNonStrokingOverprintControl()));
            if (this.fontChildID != null) {
                FeatureTreeNode resources = root.addChild("resources");
                FeatureTreeNode fonts = resources.addChild("fonts");
                FeatureTreeNode font = fonts.addChild("font");
                font.setAttribute(ID, this.fontChildID);
            }
            collection.addNewFeatureTree(FeatureObjectType.EXT_G_STATE, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

