/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureObjectType;
import org.verapdf.features.FeaturesData;
import org.verapdf.features.IFeaturesObject;
import org.verapdf.features.pb.tools.PBCreateNodeHelper;
import org.verapdf.features.tools.FeatureTreeNode;

public class PBShadingFeaturesObject
implements IFeaturesObject {
    private static final String ID = "id";
    private PDShading shading;
    private String id;
    private String colorSpaceChild;

    public PBShadingFeaturesObject(PDShading shading, String id, String colorSpaceChild) {
        this.shading = shading;
        this.id = id;
        this.colorSpaceChild = colorSpaceChild;
    }

    public FeatureObjectType getType() {
        return FeatureObjectType.SHADING;
    }

    public FeatureTreeNode reportFeatures(FeatureExtractionResult collection) throws FeatureParsingException {
        if (this.shading != null) {
            FeatureTreeNode root = FeatureTreeNode.createRootNode((String)"shading");
            if (this.id != null) {
                root.setAttribute(ID, this.id);
            }
            root.addChild("shadingType").setValue(String.valueOf(this.shading.getShadingType()));
            if (this.colorSpaceChild != null) {
                FeatureTreeNode shadingClr = root.addChild("colorSpace");
                shadingClr.setAttribute(ID, this.colorSpaceChild);
            }
            PBCreateNodeHelper.addBoxFeature("bbox", this.shading.getBBox(), root);
            root.addChild("antiAlias").setValue(String.valueOf(this.shading.getAntiAlias()));
            collection.addNewFeatureTree(FeatureObjectType.SHADING, root);
            return root;
        }
        return null;
    }

    public FeaturesData getData() {
        return null;
    }
}

