/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.cos;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSName;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.impl.pb.cos.PBCosName;

public class PBCosUnicodeName
extends PBCosName
implements CosUnicodeName {
    public static final Logger LOGGER = Logger.getLogger(PBCosUnicodeName.class);
    public static final String COS_UNICODE_NAME_TYPE = "CosUnicodeName";

    public PBCosUnicodeName(COSName cosName) {
        super(cosName, COS_UNICODE_NAME_TYPE);
    }

    public Boolean getisValidUtf8() {
        ByteBuffer tmp;
        CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
        CharsetEncoder encoder = Charset.forName("Windows-1252").newEncoder();
        try {
            tmp = encoder.encode(CharBuffer.wrap(((COSName)this.baseObject).getName()));
        }
        catch (CharacterCodingException e) {
            LOGGER.debug((Object)e);
            return false;
        }
        try {
            decoder.decode(tmp);
            return true;
        }
        catch (CharacterCodingException e) {
            LOGGER.debug((Object)e);
            return false;
        }
    }

    public String getunicodeValue() {
        String name = ((COSName)this.baseObject).getName();
        byte[] bytes = name.getBytes();
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.debug((Object)("Can not transform " + name + " to unicode string."), (Throwable)e);
            return null;
        }
    }
}

